/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0001\u0003\u0001\u001d\u0011AbU8dW\u0016$8+\u001a:wKJT!a\u0001\u0003\u0002\u000f9,Go^8sW*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u000b\u0001A\u0001C\u0006\u000f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u001c1\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005A!M]8lKJLE-F\u0001&!\tib%\u0003\u0002(=\t\u0019\u0011J\u001c;\t\u0011%\u0002!\u0011!Q\u0001\n\u0015\n\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nA\u0001[8tiV\tQ\u0006\u0005\u0002/c9\u0011QdL\u0005\u0003ay\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001G\b\u0005\tk\u0001\u0011\t\u0011)A\u0005[\u0005)\u0001n\\:uA!Aq\u0007\u0001BC\u0002\u0013\u0005A%\u0001\u0003q_J$\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u000bA|'\u000f\u001e\u0011\t\u0011m\u0002!Q1A\u0005\u0002\u0011\n1C\\;n!J|7-Z:t_J$\u0006N]3bIND\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0015]Vl\u0007K]8dKN\u001cxN\u001d+ie\u0016\fGm\u001d\u0011\t\u0011}\u0002!Q1A\u0005\u0002\u0011\n\u0011#\\1y#V,W/\u001a3SKF,Xm\u001d;t\u0011!\t\u0005A!A!\u0002\u0013)\u0013AE7bqF+X-^3e%\u0016\fX/Z:ug\u0002B\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001J\u0001\u000fg\u0016tGMQ;gM\u0016\u00148+\u001b>f\u0011!)\u0005A!A!\u0002\u0013)\u0013aD:f]\u0012\u0014UO\u001a4feNK'0\u001a\u0011\t\u0011\u001d\u0003!Q1A\u0005\u0002\u0011\naB]3dm\n+hMZ3s'&TX\r\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003&\u0003=\u0011Xm\u0019<Ck\u001a4WM]*ju\u0016\u0004\u0003\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0002\u001d5\f\u0007PU3rk\u0016\u001cHoU5{K\"AQ\n\u0001B\u0001B\u0003%Q%A\bnCb\u0014V-];fgR\u001c\u0016N_3!\u0011!y\u0005A!b\u0001\n\u0003!\u0013aE7bq\u000e{gN\\3di&|gn\u001d)fe&\u0003\b\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002)5\f\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139!\u0011!\u0019\u0006A!b\u0001\n\u0003!\u0016\u0001F2p]:,7\r^5p]Nl\u0015\r_%eY\u0016l5/F\u0001V!\tib+\u0003\u0002X=\t!Aj\u001c8h\u0011!I\u0006A!A!\u0002\u0013)\u0016!F2p]:,7\r^5p]Nl\u0015\r_%eY\u0016l5\u000f\t\u0005\t7\u0002\u0011)\u0019!C\u00019\u0006aR.\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja>3XM\u001d:jI\u0016\u001cX#A/\u0011\ty\u000bW&J\u0007\u0002?*\u0011\u0001MH\u0001\u000bG>dG.Z2uS>t\u0017B\u00012`\u0005\ri\u0015\r\u001d\u0005\tI\u0002\u0011\t\u0011)A\u0005;\u0006iR.\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja>3XM\u001d:jI\u0016\u001c\b\u0005C\u0003g\u0001\u0011\u0005q-\u0001\u0004=S:LGO\u0010\u000b\rQ*\\G.\u001c8paF\u00148\u000f\u001e\t\u0003S\u0002i\u0011A\u0001\u0005\u0006G\u0015\u0004\r!\n\u0005\u0006W\u0015\u0004\r!\f\u0005\u0006o\u0015\u0004\r!\n\u0005\u0006w\u0015\u0004\r!\n\u0005\u0006\u007f\u0015\u0004\r!\n\u0005\u0006\u0007\u0016\u0004\r!\n\u0005\u0006\u000f\u0016\u0004\r!\n\u0005\b\u0017\u0016\u0004\n\u00111\u0001&\u0011\u001dyU\r%AA\u0002\u0015BQaU3A\u0002UCQaW3A\u0002uCqA\u001e\u0001C\u0002\u0013%q/\u0001\u0003uS6,W#\u0001=\u000f\u0005EI\u0018B\u0001>\u0013\u0003)\u0019\u0016p\u001d;f[RKW.\u001a\u0005\u0007y\u0002\u0001\u000b\u0011\u0002=\u0002\u000bQLW.\u001a\u0011\t\u000fy\u0004!\u0019!C\u0005\u007f\u0006Q\u0001O]8dKN\u001cxN]:\u0016\u0005\u0005\u0005\u0001#B\u000f\u0002\u0004\u0005\u001d\u0011bAA\u0003=\t)\u0011I\u001d:bsB\u0019\u0011.!\u0003\n\u0007\u0005-!AA\u0005Qe>\u001cWm]:pe\"A\u0011q\u0002\u0001!\u0002\u0013\t\t!A\u0006qe>\u001cWm]:peN\u0004\u0003\"CA\n\u0001\u0001\u0007I\u0011BA\u000b\u0003!\t7mY3qi>\u0014XCAA\f!\rI\u0017\u0011D\u0005\u0004\u00037\u0011!\u0001C!dG\u0016\u0004Ho\u001c:\t\u0013\u0005}\u0001\u00011A\u0005\n\u0005\u0005\u0012\u0001D1dG\u0016\u0004Ho\u001c:`I\u0015\fH\u0003BA\u0012\u0003S\u00012!HA\u0013\u0013\r\t9C\b\u0002\u0005+:LG\u000f\u0003\u0006\u0002,\u0005u\u0011\u0011!a\u0001\u0003/\t1\u0001\u001f\u00132\u0011!\ty\u0003\u0001Q!\n\u0005]\u0011!C1dG\u0016\u0004Ho\u001c:!Q\u0011\ti#a\r\u0011\u0007u\t)$C\u0002\u00028y\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003w\u0001!\u0019!C\u0001\u0003{\taB]3rk\u0016\u001cHo\u00115b]:,G.\u0006\u0002\u0002@A\u0019\u0011.!\u0011\n\u0007\u0005\r#A\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003\u007f\tqB]3rk\u0016\u001cHo\u00115b]:,G\u000e\t\u0005\n\u0003\u0017\u0002!\u0019!C\u0005\u0003\u001b\n!#Y4he\u0016<\u0017\r^3JI2,W*\u001a;feV\u0011\u0011q\n\t\u0005\u0003#\n\t'\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011\u0019wN]3\u000b\u0007e\tIF\u0003\u0003\u0002\\\u0005u\u0013AB=b[6,'O\u0003\u0002\u0002`\u0005\u00191m\\7\n\t\u0005\r\u00141\u000b\u0002\u0006\u001b\u0016$XM\u001d\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002P\u0005\u0019\u0012mZ4sK\u001e\fG/Z%eY\u0016lU\r^3sA!9\u00111\u000e\u0001\u0005\u0002\u00055\u0014aB:uCJ$X\u000f\u001d\u000b\u0003\u0003GAq!!\u001d\u0001\t\u0003\ti'\u0001\u0005tQV$Hm\\<o\u000f%\t)HAA\u0001\u0012\u000b\t9(\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fE\u0002j\u0003s2\u0001\"\u0001\u0002\u0002\u0002#\u0015\u00111P\n\u0005\u0003sBA\u0004C\u0004g\u0003s\"\t!a \u0015\u0005\u0005]\u0004BCAB\u0003s\n\n\u0011\"\u0001\u0002\u0006\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012BTCAADU\r)\u0013\u0011R\u0016\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0013\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0006=%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011QTA=#\u0003%\t!!\"\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%s\u0001")
public class SocketServer
implements Logging,
KafkaMetricsGroup,
ScalaObject {
    private final int brokerId;
    private final String host;
    private final int port;
    private final int numProcessorThreads;
    private final int maxQueuedRequests;
    private final int sendBufferSize;
    private final int recvBufferSize;
    private final int maxRequestSize;
    private final int maxConnectionsPerIp;
    private final long connectionsMaxIdleMs;
    private final Map<String, Object> maxConnectionsPerIpOverrides;
    private final SystemTime$ kafka$network$SocketServer$$time;
    private final Processor[] kafka$network$SocketServer$$processors;
    private volatile Acceptor acceptor;
    private final RequestChannel requestChannel;
    private final Meter kafka$network$SocketServer$$aggregateIdleMeter;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int init$default$9() {
        return SocketServer$.MODULE$.init$default$9();
    }

    public static final int init$default$8() {
        return SocketServer$.MODULE$.init$default$8();
    }

    public int brokerId() {
        return this.brokerId;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int numProcessorThreads() {
        return this.numProcessorThreads;
    }

    public int maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int sendBufferSize() {
        return this.sendBufferSize;
    }

    public int recvBufferSize() {
        return this.recvBufferSize;
    }

    public int maxRequestSize() {
        return this.maxRequestSize;
    }

    public int maxConnectionsPerIp() {
        return this.maxConnectionsPerIp;
    }

    public long connectionsMaxIdleMs() {
        return this.connectionsMaxIdleMs;
    }

    public Map<String, Object> maxConnectionsPerIpOverrides() {
        return this.maxConnectionsPerIpOverrides;
    }

    public final SystemTime$ kafka$network$SocketServer$$time() {
        return this.kafka$network$SocketServer$$time;
    }

    public final Processor[] kafka$network$SocketServer$$processors() {
        return this.kafka$network$SocketServer$$processors;
    }

    private Acceptor acceptor() {
        return this.acceptor;
    }

    private void acceptor_$eq(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public final Meter kafka$network$SocketServer$$aggregateIdleMeter() {
        return this.kafka$network$SocketServer$$aggregateIdleMeter;
    }

    public void startup() {
        ConnectionQuotas quotas$1 = new ConnectionQuotas(this.maxConnectionsPerIp(), this.maxConnectionsPerIpOverrides());
        Predef$.MODULE$.intWrapper(0).until(this.numProcessorThreads()).foreach$mVc$sp((Function1)new Serializable(this, quotas$1){
            public static final long serialVersionUID;
            private final SocketServer $outer;
            private final ConnectionQuotas quotas$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                this.$outer.kafka$network$SocketServer$$processors()[v1] = new Processor(v1, this.$outer.kafka$network$SocketServer$$time(), this.$outer.maxRequestSize(), this.$outer.kafka$network$SocketServer$$aggregateIdleMeter(), this.$outer.newMeter("IdlePercent", "percent", TimeUnit.NANOSECONDS, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"networkProcessor").$minus$greater((Object)((Object)BoxesRunTime.boxToInteger((int)v1)).toString())})))), this.$outer.numProcessorThreads(), this.$outer.requestChannel(), this.quotas$1, this.$outer.connectionsMaxIdleMs());
                Utils$.MODULE$.newThread(Predef$.MODULE$.augmentString("kafka-network-thread-%d-%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.port()), BoxesRunTime.boxToInteger((int)v1)})), this.$outer.kafka$network$SocketServer$$processors()[v1], false).start();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.quotas$1 = connectionQuotas;
            }
        });
        this.newGauge("ResponsesBeingSent", new Gauge<Object>(this){
            private final SocketServer $outer;

            public int value() {
                return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.refArrayOps((Object[])this.$outer.kafka$network$SocketServer$$processors()).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(int total, Processor p) {
                        return total + p.countInterestOps(4);
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.newGauge$default$3());
        this.requestChannel().addResponseListener((Function1<Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;
            private final SocketServer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int id) {
                this.apply$mcVI$sp(id);
            }

            public void apply$mcVI$sp(int v1) {
                this.$outer.kafka$network$SocketServer$$processors()[v1].wakeup();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.acceptor_$eq(new Acceptor(this.host(), this.port(), this.kafka$network$SocketServer$$processors(), this.sendBufferSize(), this.recvBufferSize(), quotas$1));
        Utils$.MODULE$.newThread("kafka-socket-acceptor", this.acceptor(), false).start();
        this.acceptor().awaitStartup();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Started";
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutting down";
            }
        });
        if (this.acceptor() != null) {
            this.acceptor().shutdown();
        }
        Predef$.MODULE$.refArrayOps((Object[])this.kafka$network$SocketServer$$processors()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Processor processor) {
                processor.shutdown();
            }
        });
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutdown completed";
            }
        });
    }

    public SocketServer(int brokerId, String host, int port, int numProcessorThreads, int maxQueuedRequests, int sendBufferSize, int recvBufferSize, int maxRequestSize, int maxConnectionsPerIp, long connectionsMaxIdleMs, Map<String, Object> maxConnectionsPerIpOverrides) {
        this.brokerId = brokerId;
        this.host = host;
        this.port = port;
        this.numProcessorThreads = numProcessorThreads;
        this.maxQueuedRequests = maxQueuedRequests;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
        this.maxRequestSize = maxRequestSize;
        this.maxConnectionsPerIp = maxConnectionsPerIp;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.maxConnectionsPerIpOverrides = maxConnectionsPerIpOverrides;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Socket Server on Broker ").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).append((Object)"], ").toString());
        this.kafka$network$SocketServer$$time = SystemTime$.MODULE$;
        this.kafka$network$SocketServer$$processors = new Processor[numProcessorThreads];
        this.acceptor = null;
        this.requestChannel = new RequestChannel(numProcessorThreads, maxQueuedRequests);
        this.kafka$network$SocketServer$$aggregateIdleMeter = this.newMeter("NetworkProcessorAvgIdlePercent", "percent", TimeUnit.NANOSECONDS, (Map<String, String>)this.newMeter$default$4());
    }
}

