/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.util.concurrent.TimeUnit;
import kafka.api.FetchResponse;
import kafka.api.FetchResponseSend;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.RequestChannel;
import kafka.server.DelayedFetch;
import kafka.server.ReplicaManager;
import kafka.server.RequestPurgatory;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u000f\t)b)\u001a;dQJ+\u0017/^3tiB+(oZ1u_JL(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aq\u0002E\u0002\n\u00151i\u0011AA\u0005\u0003\u0017\t\u0011\u0001CU3rk\u0016\u001cH\u000fU;sO\u0006$xN]=\u0011\u0005%i\u0011B\u0001\b\u0003\u00051!U\r\\1zK\u00124U\r^2i!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011Y\u0001!\u0011!Q\u0001\n]\taB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\n1%\u0011\u0011D\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!Y\u0002A!A!\u0002\u0013a\u0012A\u0004:fcV,7\u000f^\"iC:tW\r\u001c\t\u0003;\u0001j\u0011A\b\u0006\u0003?\u0011\tqA\\3uo>\u00148.\u0003\u0002\"=\tq!+Z9vKN$8\t[1o]\u0016d\u0007\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\bF\u0002&M\u001d\u0002\"!\u0003\u0001\t\u000bY\u0011\u0003\u0019A\f\t\u000bm\u0011\u0003\u0019\u0001\u000f\u0007\t%\u0002AA\u000b\u0002\u001b\t\u0016d\u0017-_3e\r\u0016$8\r\u001b*fcV,7\u000f^'fiJL7m]\n\u0005Q-\u001at\u0002\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A.\u00198h\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\r=\u0013'.Z2u!\t!t'D\u00016\u0015\t1D!A\u0004nKR\u0014\u0018nY:\n\u0005a*$!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\"A!\b\u000bB\u0001B\u0003%1(A\u0006g_J4u\u000e\u001c7po\u0016\u0014\bC\u0001\t=\u0013\ti\u0014CA\u0004C_>dW-\u00198\t\u000b\rBC\u0011A \u0015\u0005\u0001\u0013\u0005CA!)\u001b\u0005\u0001\u0001\"\u0002\u001e?\u0001\u0004Y\u0004b\u0002#)\u0005\u0004%I!R\u0001\r[\u0016$(/[2Qe\u00164\u0017\u000e_\u000b\u0002\rB\u0011AfR\u0005\u0003\u00116\u0012aa\u0015;sS:<\u0007B\u0002&)A\u0003%a)A\u0007nKR\u0014\u0018n\u0019)sK\u001aL\u0007\u0010\t\u0005\b\u0019\"\u0012\r\u0011\"\u0001N\u0003M)\u0007\u0010]5sK\u0012\u0014V-];fgRlU\r^3s+\u0005q\u0005CA(X\u001b\u0005\u0001&BA)S\u0003\u0011\u0019wN]3\u000b\u0005Y\u001a&B\u0001+V\u0003\u0019I\u0018-\\7fe*\ta+A\u0002d_6L!\u0001\u0017)\u0003\u000b5+G/\u001a:\t\riC\u0003\u0015!\u0003O\u0003Q)\u0007\u0010]5sK\u0012\u0014V-];fgRlU\r^3sA!9A\f\u0001b\u0001\n\u0013i\u0016\u0001J1hOJ,w-\u0019;f\r>dGn\\<fe\u001a+Go\u00195SKF,Xm\u001d;NKR\u0014\u0018nY:\u0016\u0003\u0001Caa\u0018\u0001!\u0002\u0013\u0001\u0015!J1hOJ,w-\u0019;f\r>dGn\\<fe\u001a+Go\u00195SKF,Xm\u001d;NKR\u0014\u0018nY:!\u0011\u001d\t\u0007A1A\u0005\nu\u000bq%Y4he\u0016<\u0017\r^3O_:4u\u000e\u001c7po\u0016\u0014h)\u001a;dQJ+\u0017/^3ti6+GO]5dg\"11\r\u0001Q\u0001\n\u0001\u000b\u0001&Y4he\u0016<\u0017\r^3O_:4u\u000e\u001c7po\u0016\u0014h)\u001a;dQJ+\u0017/^3ti6+GO]5dg\u0002BQ!\u001a\u0001\u0005\n\u0019\f\u0011D]3d_J$G)\u001a7bs\u0016$g)\u001a;dQ\u0016C\b/\u001b:fIR\u0011qM\u001b\t\u0003!!L!![\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006u\u0011\u0004\ra\u000f\u0005\u0006Y\u0002!\t!\\\u0001\u000fG\",7m[*bi&\u001ch-[3e)\tYd\u000eC\u0003pW\u0002\u0007A\"\u0001\u0007eK2\f\u00170\u001a3GKR\u001c\u0007\u000eC\u0003r\u0001\u0011\u0005!/\u0001\u0004fqBL'/\u001a\u000b\u0003ONDQa\u001c9A\u00021AQ!\u001e\u0001\u0005\u0002Y\fqA]3ta>tG\r\u0006\u0002ho\")q\u000e\u001ea\u0001\u0019\u0001")
public class FetchRequestPurgatory
extends RequestPurgatory<DelayedFetch>
implements ScalaObject {
    private final ReplicaManager replicaManager;
    private final RequestChannel requestChannel;
    private final DelayedFetchRequestMetrics aggregateFollowerFetchRequestMetrics;
    private final DelayedFetchRequestMetrics aggregateNonFollowerFetchRequestMetrics;

    private DelayedFetchRequestMetrics aggregateFollowerFetchRequestMetrics() {
        return this.aggregateFollowerFetchRequestMetrics;
    }

    private DelayedFetchRequestMetrics aggregateNonFollowerFetchRequestMetrics() {
        return this.aggregateNonFollowerFetchRequestMetrics;
    }

    private void recordDelayedFetchExpired(boolean forFollower) {
        DelayedFetchRequestMetrics metrics = forFollower ? this.aggregateFollowerFetchRequestMetrics() : this.aggregateNonFollowerFetchRequestMetrics();
        metrics.expiredRequestMeter().mark();
    }

    @Override
    public boolean checkSatisfied(DelayedFetch delayedFetch) {
        return delayedFetch.isSatisfied(this.replicaManager);
    }

    @Override
    public void expire(DelayedFetch delayedFetch$1) {
        this.debug((Function0<String>)new Serializable(this, delayedFetch$1){
            public static final long serialVersionUID;
            private final DelayedFetch delayedFetch$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Expiring fetch request %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.delayedFetch$1.fetch()}));
            }
            {
                this.delayedFetch$1 = delayedFetch;
            }
        });
        boolean fromFollower = delayedFetch$1.fetch().isFromFollower();
        this.recordDelayedFetchExpired(fromFollower);
        this.respond(delayedFetch$1);
    }

    public void respond(DelayedFetch delayedFetch) {
        FetchResponse response = delayedFetch.respond(this.replicaManager);
        this.requestChannel.sendResponse(new RequestChannel.Response(delayedFetch.request(), new FetchResponseSend(response)));
    }

    public FetchRequestPurgatory(ReplicaManager replicaManager, RequestChannel requestChannel) {
        this.replicaManager = replicaManager;
        this.requestChannel = requestChannel;
        super(replicaManager.config().brokerId(), replicaManager.config().fetchPurgatoryPurgeIntervalRequests());
        this.logIdent_$eq(Predef$.MODULE$.augmentString("[FetchRequestPurgatory-%d] ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaManager.config().brokerId())})));
        this.aggregateFollowerFetchRequestMetrics = new DelayedFetchRequestMetrics(this, true);
        this.aggregateNonFollowerFetchRequestMetrics = new DelayedFetchRequestMetrics(this, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DelayedFetchRequestMetrics
    implements KafkaMetricsGroup,
    ScalaObject {
        private final String metricPrefix;
        private final Meter expiredRequestMeter;
        public final FetchRequestPurgatory $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        private String metricPrefix() {
            return this.metricPrefix;
        }

        public Meter expiredRequestMeter() {
            return this.expiredRequestMeter;
        }

        public FetchRequestPurgatory kafka$server$FetchRequestPurgatory$DelayedFetchRequestMetrics$$$outer() {
            return this.$outer;
        }

        public DelayedFetchRequestMetrics(FetchRequestPurgatory $outer, boolean forFollower) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            KafkaMetricsGroup$class.$init$(this);
            this.metricPrefix = forFollower ? "Follower" : "Consumer";
            this.expiredRequestMeter = this.newMeter(new StringBuilder().append((Object)this.metricPrefix()).append((Object)"ExpiresPerSecond").toString(), "requests", TimeUnit.SECONDS, (Map<String, String>)this.newMeter$default$4());
        }
    }
}

