/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.cluster.Replica$;
import kafka.common.KafkaException;
import kafka.log.Log;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t;\u0001\u0011)\u0019!C\u0001=\u0005A!M]8lKJLE-F\u0001 !\t9\u0002%\u0003\u0002\"1\t\u0019\u0011J\u001c;\t\u0011\r\u0002!\u0011!Q\u0001\n}\t\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\t\u0011\u0015\u0002!Q1A\u0005\u0002\u0019\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003\u001d\u0002\"\u0001K\u0015\u000e\u0003\tI!A\u000b\u0002\u0003\u0013A\u000b'\u000f^5uS>t\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u0015A\f'\u000f^5uS>t\u0007\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003\u0011!\u0018.\\3\u0011\u0005E\u0001\u0014BA\u0019\u0013\u0005\u0011!\u0016.\\3\t\u0011M\u0002!\u0011!Q\u0001\nQ\n\u0011$\u001b8ji&\fG\u000eS5hQ^\u000bG/\u001a:nCJ\\g+\u00197vKB\u0011q#N\u0005\u0003ma\u0011A\u0001T8oO\"A\u0001\b\u0001BC\u0002\u0013\u0005\u0011(A\u0002m_\u001e,\u0012A\u000f\t\u0004/mj\u0014B\u0001\u001f\u0019\u0005\u0019y\u0005\u000f^5p]B\u0011a\bQ\u0007\u0002\u007f)\u0011\u0001\bB\u0005\u0003\u0003~\u00121\u0001T8h\u0011!\u0019\u0005A!A!\u0002\u0013Q\u0014\u0001\u00027pO\u0002BQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0001P5oSRtDCB$I\u0013*[E\n\u0005\u0002)\u0001!)Q\u0004\u0012a\u0001?!)Q\u0005\u0012a\u0001O!9a\u0006\u0012I\u0001\u0002\u0004y\u0003bB\u001aE!\u0003\u0005\r\u0001\u000e\u0005\bq\u0011\u0003\n\u00111\u0001;\u0011\u0019q\u0005\u0001)Q\u0005\u001f\u0006\u0011\u0002.[4i/\u0006$XM]7be.4\u0016\r\\;f!\t\u0001v+D\u0001R\u0015\t\u00116+\u0001\u0004bi>l\u0017n\u0019\u0006\u0003)V\u000b!bY8oGV\u0014(/\u001a8u\u0015\t1F\"\u0001\u0003vi&d\u0017B\u0001-R\u0005)\tEo\\7jG2{gn\u001a\u0005\u00075\u0002\u0001\u000b\u0015B(\u0002#1|w-\u00128e\u001f\u001a47/\u001a;WC2,X\r\u0003\u0004]\u0001\u0001\u0006KaT\u0001\u001eY><WI\u001c3PM\u001a\u001cX\r^+qI\u0006$X\rV5nK6\u001bh+\u00197vK\"9a\f\u0001b\u0001\n\u0003y\u0016!\u0002;pa&\u001cW#\u00011\u0011\u0005\u0005$gBA\fc\u0013\t\u0019\u0007$\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2\u0019\u0011\u0019A\u0007\u0001)A\u0005A\u00061Ao\u001c9jG\u0002BqA\u001b\u0001C\u0002\u0013\u0005a$A\u0006qCJ$\u0018\u000e^5p]&#\u0007B\u00027\u0001A\u0003%q$\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007\u0005C\u0003o\u0001\u0011\u0005q.\u0001\tm_\u001e,e\u000eZ(gMN,Go\u0018\u0013fcR\u0011\u0001o\u001d\t\u0003/EL!A\u001d\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006i6\u0004\r\u0001N\u0001\u0010]\u0016<Hj\\4F]\u0012|eMZ:fi\")a\u000f\u0001C\u0001o\u0006aAn\\4F]\u0012|eMZ:fiV\tA\u0007C\u0003z\u0001\u0011\u0005!0A\u0004jg2{7-\u00197\u0016\u0003m\u0004\"a\u0006?\n\u0005uD\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u007f\u0002!\ta^\u0001\u0019Y><WI\u001c3PM\u001a\u001cX\r^+qI\u0006$X\rV5nK6\u001b\bbBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0012Q&<\u0007nV1uKJl\u0017M]6`I\u0015\fHc\u00019\u0002\b!9\u0011\u0011BA\u0001\u0001\u0004!\u0014\u0001\u00058fo\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0011\u0019\ti\u0001\u0001C\u0001o\u0006i\u0001.[4i/\u0006$XM]7be.Dq!!\u0005\u0001\t\u0003\n\u0019\"\u0001\u0004fcV\fGn\u001d\u000b\u0004w\u0006U\u0001\u0002CA\f\u0003\u001f\u0001\r!!\u0007\u0002\tQD\u0017\r\u001e\t\u0004/\u0005m\u0011bAA\u000f1\t\u0019\u0011I\\=\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$\u0005A\u0001.Y:i\u0007>$W\rF\u0001 \u0011\u001d\t9\u0003\u0001C!\u0003S\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002A\u001eI\u0011Q\u0006\u0002\u0002\u0002#\u0015\u0011qF\u0001\b%\u0016\u0004H.[2b!\rA\u0013\u0011\u0007\u0004\t\u0003\t\t\t\u0011#\u0002\u00024M!\u0011\u0011\u0007\u0005\u0017\u0011\u001d)\u0015\u0011\u0007C\u0001\u0003o!\"!a\f\t\u0015\u0005m\u0012\u0011GI\u0001\n\u0003\ti$\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}\"fA\u0018\u0002B-\u0012\u00111\t\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003%)hn\u00195fG.,GMC\u0002\u0002Na\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t&a\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002V\u0005E\u0012\u0013!C\u0001\u0003/\na\"\u001b8ji\u0012\"WMZ1vYR$C'\u0006\u0002\u0002Z)\u001aA'!\u0011\t\u0015\u0005u\u0013\u0011GI\u0001\n\u0003\ty&\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\u0005$f\u0001\u001e\u0002B\u0001")
public class Replica
implements Logging {
    private final int brokerId;
    private final Partition partition;
    private final Time time;
    private final Option<Log> log;
    private AtomicLong highWatermarkValue;
    public AtomicLong kafka$cluster$Replica$$logEndOffsetValue;
    private AtomicLong logEndOffsetUpdateTimeMsValue;
    private final String topic;
    private final int partitionId;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Option init$default$5() {
        return Replica$.MODULE$.init$default$5();
    }

    public static final long init$default$4() {
        return Replica$.MODULE$.init$default$4();
    }

    public static final Time init$default$3() {
        return Replica$.MODULE$.init$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Replica replica = this;
        synchronized (replica) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public void logEndOffset_$eq(long l) {
        if (this.isLocal()) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Shouldn't set logEndOffset for replica %d partition [%s,%d] since it's local").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId())})));
        }
        this.kafka$cluster$Replica$$logEndOffsetValue.set(l);
        this.logEndOffsetUpdateTimeMsValue.set(this.time.milliseconds());
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final Replica $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Setting log end offset for replica %d for partition [%s,%d] to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), BoxesRunTime.boxToLong((long)this.$outer.kafka$cluster$Replica$$logEndOffsetValue.get())}));
            }
            {
                if (replica == null) {
                    throw new NullPointerException();
                }
                this.$outer = replica;
            }
        });
    }

    public long logEndOffset() {
        return this.isLocal() ? ((Log)this.log().get()).logEndOffset() : this.kafka$cluster$Replica$$logEndOffsetValue.get();
    }

    public boolean isLocal() {
        Option<Log> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.log();
                    if (!(option instanceof Some)) break block2;
                    bl = true;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Log> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public long logEndOffsetUpdateTimeMs() {
        return this.logEndOffsetUpdateTimeMsValue.get();
    }

    public void highWatermark_$eq(long l) {
        if (this.isLocal()) {
            this.trace((Function0<String>)new Serializable(this, l){
                public static final long serialVersionUID;
                private final Replica $outer;
                private final long newHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Setting hw for replica %d partition [%s,%d] on broker %d to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), BoxesRunTime.boxToInteger((int)this.$outer.brokerId()), BoxesRunTime.boxToLong((long)this.newHighWatermark$1)}));
                }
                {
                    if (replica == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = replica;
                    this.newHighWatermark$1 = l;
                }
            });
            this.highWatermarkValue.set(l);
            return;
        }
        throw new KafkaException(Predef$.MODULE$.augmentString("Unable to set highwatermark for replica %d partition [%s,%d] since it's not local").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId())})));
    }

    public long highWatermark() {
        if (this.isLocal()) {
            return this.highWatermarkValue.get();
        }
        throw new KafkaException(Predef$.MODULE$.augmentString("Unable to get highwatermark for replica %d partition [%s,%d] since it's not local").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.brokerId()), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId())})));
    }

    public boolean equals(Object object) {
        if (object instanceof Replica) {
            Replica replica = (Replica)object;
            return this.topic().equals(replica.topic()) && this.brokerId() == replica.brokerId() && this.partition().equals(replica.partition());
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.brokerId() + this.partition().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new StringBuilder().append((Object)"ReplicaId: ").append((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString());
        stringBuilder.append(new StringBuilder().append((Object)"; Topic: ").append((Object)this.topic()).toString());
        stringBuilder.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partition().partitionId())).toString());
        stringBuilder.append(new StringBuilder().append((Object)"; isLocal: ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.isLocal())).toString());
        Object object = this.isLocal() ? stringBuilder.append(new StringBuilder().append((Object)"; Highwatermark: ").append((Object)BoxesRunTime.boxToLong((long)this.highWatermark())).toString()) : BoxedUnit.UNIT;
        return stringBuilder.toString();
    }

    public Replica(int n, Partition partition, Time time, long l, Option<Log> option) {
        this.brokerId = n;
        this.partition = partition;
        this.time = time;
        this.log = option;
        Logging$class.$init$(this);
        this.highWatermarkValue = new AtomicLong(l);
        this.kafka$cluster$Replica$$logEndOffsetValue = new AtomicLong(ReplicaManager$.MODULE$.UnknownLogEndOffset());
        this.logEndOffsetUpdateTimeMsValue = new AtomicLong(time.milliseconds());
        this.topic = partition.topic();
        this.partitionId = partition.partitionId();
    }
}

