/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.nio.ByteBuffer;
import kafka.common.BrokerNotAvailableException;
import kafka.common.ControllerMovedException;
import kafka.common.ErrorMapping$;
import kafka.common.InvalidMessageSizeException;
import kafka.common.LeaderNotAvailableException;
import kafka.common.MessageSizeTooLargeException;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.OffsetOutOfRangeException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.RequestTimedOutException;
import kafka.common.UnknownException;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.message.InvalidMessageException;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorMapping$
implements ScalaObject {
    public static final ErrorMapping$ MODULE$;
    private final ByteBuffer EmptyByteBuffer;
    private final short UnknownCode;
    private final short NoError;
    private final short OffsetOutOfRangeCode;
    private final short InvalidMessageCode;
    private final short UnknownTopicOrPartitionCode;
    private final short InvalidFetchSizeCode;
    private final short LeaderNotAvailableCode;
    private final short NotLeaderForPartitionCode;
    private final short RequestTimedOutCode;
    private final short BrokerNotAvailableCode;
    private final short ReplicaNotAvailableCode;
    private final short MessageSizeTooLargeCode;
    private final short StaleControllerEpochCode;
    private final Map<Class<Throwable>, Object> exceptionToCode;
    private final Map<Object, Class<? extends Throwable>> codeToException;

    static {
        new ErrorMapping$();
    }

    public ByteBuffer EmptyByteBuffer() {
        return this.EmptyByteBuffer;
    }

    public short UnknownCode() {
        return this.UnknownCode;
    }

    public short NoError() {
        return this.NoError;
    }

    public short OffsetOutOfRangeCode() {
        return this.OffsetOutOfRangeCode;
    }

    public short InvalidMessageCode() {
        return this.InvalidMessageCode;
    }

    public short UnknownTopicOrPartitionCode() {
        return this.UnknownTopicOrPartitionCode;
    }

    public short InvalidFetchSizeCode() {
        return this.InvalidFetchSizeCode;
    }

    public short LeaderNotAvailableCode() {
        return this.LeaderNotAvailableCode;
    }

    public short NotLeaderForPartitionCode() {
        return this.NotLeaderForPartitionCode;
    }

    public short RequestTimedOutCode() {
        return this.RequestTimedOutCode;
    }

    public short BrokerNotAvailableCode() {
        return this.BrokerNotAvailableCode;
    }

    public short ReplicaNotAvailableCode() {
        return this.ReplicaNotAvailableCode;
    }

    public short MessageSizeTooLargeCode() {
        return this.MessageSizeTooLargeCode;
    }

    public short StaleControllerEpochCode() {
        return this.StaleControllerEpochCode;
    }

    private Map<Class<Throwable>, Object> exceptionToCode() {
        return this.exceptionToCode;
    }

    private Map<Object, Class<? extends Throwable>> codeToException() {
        return this.codeToException;
    }

    public short codeFor(Class<Throwable> clazz) {
        return BoxesRunTime.unboxToShort((Object)this.exceptionToCode().apply(clazz));
    }

    public void maybeThrowException(short s) {
        if (s != 0) {
            throw (Throwable)((Class)this.codeToException().apply((Object)BoxesRunTime.boxToShort((short)s))).newInstance();
        }
    }

    public Throwable exceptionFor(short s) {
        return (Throwable)((Class)this.codeToException().apply((Object)BoxesRunTime.boxToShort((short)s))).newInstance();
    }

    private ErrorMapping$() {
        MODULE$ = this;
        this.EmptyByteBuffer = ByteBuffer.allocate(0);
        this.UnknownCode = (short)-1;
        this.NoError = 0;
        this.OffsetOutOfRangeCode = 1;
        this.InvalidMessageCode = (short)2;
        this.UnknownTopicOrPartitionCode = (short)3;
        this.InvalidFetchSizeCode = (short)4;
        this.LeaderNotAvailableCode = (short)5;
        this.NotLeaderForPartitionCode = (short)6;
        this.RequestTimedOutCode = (short)7;
        this.BrokerNotAvailableCode = (short)8;
        this.ReplicaNotAvailableCode = (short)9;
        this.MessageSizeTooLargeCode = (short)10;
        this.StaleControllerEpochCode = (short)11;
        this.exceptionToCode = ((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(OffsetOutOfRangeException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.OffsetOutOfRangeCode())), Predef$.MODULE$.any2ArrowAssoc(InvalidMessageException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.InvalidMessageCode())), Predef$.MODULE$.any2ArrowAssoc(UnknownTopicOrPartitionException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.UnknownTopicOrPartitionCode())), Predef$.MODULE$.any2ArrowAssoc(InvalidMessageSizeException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.InvalidFetchSizeCode())), Predef$.MODULE$.any2ArrowAssoc(NotLeaderForPartitionException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.NotLeaderForPartitionCode())), Predef$.MODULE$.any2ArrowAssoc(LeaderNotAvailableException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.LeaderNotAvailableCode())), Predef$.MODULE$.any2ArrowAssoc(RequestTimedOutException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.RequestTimedOutCode())), Predef$.MODULE$.any2ArrowAssoc(BrokerNotAvailableException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.BrokerNotAvailableCode())), Predef$.MODULE$.any2ArrowAssoc(ReplicaNotAvailableException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.ReplicaNotAvailableCode())), Predef$.MODULE$.any2ArrowAssoc(MessageSizeTooLargeException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.MessageSizeTooLargeCode())), Predef$.MODULE$.any2ArrowAssoc(ControllerMovedException.class).$minus$greater((Object)BoxesRunTime.boxToShort((short)this.StaleControllerEpochCode()))}))).withDefaultValue((Object)BoxesRunTime.boxToShort((short)this.UnknownCode()));
        this.codeToException = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)this.exceptionToCode().iterator().map((Function1)new anonfun.1())).withDefaultValue(UnknownException.class);
    }
}

