/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.IOException;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$loadLogs$1$;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig;
import kafka.utils.FileLock;
import kafka.utils.KafkaScheduler;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tea!B\u0001\u0003\u0001\u00111!A\u0003'pO6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019q\"\u0006\t\u0003\u00115i\u0011!\u0003\u0006\u0003\u0015-\tA\u0001\\1oO*\tA\"\u0001\u0003kCZ\f\u0017B\u0001\b\n\u0005\u0019y%M[3diB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003B\u0001\u0006kRLGn]\u0005\u0003)E\u0011q\u0001T8hO&tw\r\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\r\r|gNZ5h\u0007\u0001)\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0003E\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u0013\"\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0011\u0019\u0002!\u0011!Q\u0001\n}\tqaY8oM&<\u0007\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002\u0011U%\u00111&\u0005\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0011!i\u0003A!b\u0001\n\u0013q\u0013\u0001\u0002;j[\u0016,\u0012a\f\t\u0003!AJ!!M\t\u0003\tQKW.\u001a\u0005\tg\u0001\u0011\t\u0011)A\u0005_\u0005)A/[7fA!)Q\u0007\u0001C\u0001m\u00051A(\u001b8jiz\"BaN\u001d;wA\u0011\u0001\bA\u0007\u0002\u0005!)A\u0004\u000ea\u0001?!)\u0001\u0006\u000ea\u0001S!)Q\u0006\u000ea\u0001_!9Q\b\u0001b\u0001\n\u0003q\u0014!E\"mK\u0006t7\u000b[;uI><hNR5mKV\tq\b\u0005\u0002\t\u0001&\u0011\u0011)\u0003\u0002\u0007'R\u0014\u0018N\\4\t\r\r\u0003\u0001\u0015!\u0003@\u0003I\u0019E.Z1o'\",H\u000fZ8x]\u001aKG.\u001a\u0011\t\u000f\u0015\u0003!\u0019!C\u0001}\u0005AAj\\2l\r&dW\r\u0003\u0004H\u0001\u0001\u0006IaP\u0001\n\u0019>\u001c7NR5mK\u0002Bq!\u0013\u0001C\u0002\u0013\u0005!*A\u0004m_\u001e$\u0015N]:\u0016\u0003-\u00032A\u0006'O\u0013\tiuCA\u0003BeJ\f\u0017\u0010\u0005\u0002P%6\t\u0001K\u0003\u0002R\u0017\u0005\u0011\u0011n\\\u0005\u0003'B\u0013AAR5mK\"1Q\u000b\u0001Q\u0001\n-\u000b\u0001\u0002\\8h\t&\u00148\u000f\t\u0005\b/\u0002\u0011\r\u0011\"\u0003Y\u00039awn\u001a$jY\u0016\u001c\u0016N_3NCB,\u0012!\u0017\t\u00055v{V-D\u0001\\\u0015\tav#\u0001\u0006d_2dWm\u0019;j_:L!AX.\u0003\u00075\u000b\u0007\u000f\u0005\u0002aG:\u0011a#Y\u0005\u0003E^\ta\u0001\u0015:fI\u00164\u0017BA!e\u0015\t\u0011w\u0003\u0005\u0002\u0017M&\u0011qm\u0006\u0002\u0004\u0013:$\bBB5\u0001A\u0003%\u0011,A\bm_\u001e4\u0015\u000e\\3TSj,W*\u00199!\u0011\u001dY\u0007A1A\u0005\n1\f\u0001\u0003\\8h\r2,8\u000f[%oi\u0016\u0014h/\u00197\u0016\u0003\u0015DaA\u001c\u0001!\u0002\u0013)\u0017!\u00057pO\u001acWo\u001d5J]R,'O^1mA!9\u0001\u000f\u0001b\u0001\n\u0013A\u0016!\u00057pO\u001acWo\u001d5J]R,'O^1mg\"1!\u000f\u0001Q\u0001\ne\u000b!\u0003\\8h\r2,8\u000f[%oi\u0016\u0014h/\u00197tA!9A\u000f\u0001b\u0001\n\u0013)\u0018a\u00047pO\u000e\u0013X-\u0019;j_:dunY6\u0016\u0003\u001dAaa\u001e\u0001!\u0002\u00139\u0011\u0001\u00057pO\u000e\u0013X-\u0019;j_:dunY6!\u0011\u001dI\bA1A\u0005\ni\f1\u0003\\8h%\u0016$XM\u001c;j_:\u001c\u0016N_3NCB,\u0012a\u001f\t\u00055v{F\u0010\u0005\u0002\u0017{&\u0011ap\u0006\u0002\u0005\u0019>tw\rC\u0004\u0002\u0002\u0001\u0001\u000b\u0011B>\u0002)1|wMU3uK:$\u0018n\u001c8TSj,W*\u00199!\u0011!\t)\u0001\u0001b\u0001\n\u0013Q\u0018!\u00057pOJ+G/\u001a8uS>tWj]'ba\"9\u0011\u0011\u0002\u0001!\u0002\u0013Y\u0018A\u00057pOJ+G/\u001a8uS>tWj]'ba\u0002B\u0001\"!\u0004\u0001\u0005\u0004%IA_\u0001\rY><'k\u001c7m\u001bNl\u0015\r\u001d\u0005\b\u0003#\u0001\u0001\u0015!\u0003|\u00035awn\u001a*pY2l5/T1qA!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011qC\u0001\u0019Y><'k\u001c7m\t\u00164\u0017-\u001e7u\u0013:$XM\u001d<bY6\u001bX#\u0001?\t\u000f\u0005m\u0001\u0001)A\u0005y\u0006IBn\\4S_2dG)\u001a4bk2$\u0018J\u001c;feZ\fG.T:!\u0011%\ty\u0002\u0001b\u0001\n\u0013\t9\"\u0001\u000bm_\u001e\u001cE.Z1okBLe\u000e^3sm\u0006dWj\u001d\u0005\b\u0003G\u0001\u0001\u0015!\u0003}\u0003UawnZ\"mK\u0006tW\u000f]%oi\u0016\u0014h/\u00197Ng\u0002B\u0011\"a\n\u0001\u0005\u0004%I!a\u0006\u0002-1|wm\u00117fC:,\b\u000fR3gCVdG/Q4f\u001bNDq!a\u000b\u0001A\u0003%A0A\fm_\u001e\u001cE.Z1okB$UMZ1vYR\fu-Z'tA!I\u0011q\u0006\u0001C\u0002\u0013%\u0011\u0011G\u0001\u0005Y><7/\u0006\u0002\u00024A9\u0001#!\u000e\u0002:\u0005\u0015\u0013bAA\u001c#\t!\u0001k\\8m!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA \t\u000511m\\7n_:LA!a\u0011\u0002>\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\u0007a\n9%C\u0002\u0002J\t\u00111\u0001T8h\u0011!\ti\u0005\u0001Q\u0001\n\u0005M\u0012!\u00027pON\u0004\u0003\"CA)\u0001\u0001\u0007I\u0011BA*\u0003!!\u0017N\u001d'pG.\u001cXCAA+!\u0015Q\u0016qKA.\u0013\r\tIf\u0017\u0002\u0004'\u0016\f\bc\u0001\t\u0002^%\u0019\u0011qL\t\u0003\u0011\u0019KG.\u001a'pG.D\u0011\"a\u0019\u0001\u0001\u0004%I!!\u001a\u0002\u0019\u0011L'\u000fT8dWN|F%Z9\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004-\u0005%\u0014bAA6/\t!QK\\5u\u0011)\ty'!\u0019\u0002\u0002\u0003\u0007\u0011QK\u0001\u0004q\u0012\n\u0004\u0002CA:\u0001\u0001\u0006K!!\u0016\u0002\u0013\u0011L'\u000fT8dWN\u0004\u0003bBA<\u0001\u0011%\u0011\u0011P\u0001\u0019GJ,\u0017\r^3B]\u00124\u0016\r\\5eCR,Gj\\4ESJ\u001cH\u0003BA4\u0003wB\u0001\"! \u0002v\u0001\u0007\u0011qP\u0001\u0005I&\u00148\u000f\u0005\u0003[\u0003/r\u0005bBAB\u0001\u0011%\u0011QQ\u0001\fY>\u001c7\u000eT8h\t&\u00148\u000f\u0006\u0003\u0002V\u0005\u001d\u0005\u0002CA?\u0003\u0003\u0003\r!a \t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\u0006AAn\\1e\u0019><7\u000f\u0006\u0003\u0002h\u0005=\u0005\u0002CA?\u0003\u0013\u0003\r!a \t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u000691\u000f^1siV\u0004HCAA4\u0011\u001d\tI\n\u0001C\u0001\u00037\u000baaZ3u\u0019><GCBAO\u0003G\u000b9\u000bE\u0003\u0017\u0003?\u000b)%C\u0002\u0002\"^\u0011aa\u00149uS>t\u0007bBAS\u0003/\u0003\raX\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003S\u000b9\n1\u0001f\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u0002.\u0002!\t!a,\u0002\u001d\u001d,Go\u0014:De\u0016\fG/\u001a'pOR1\u0011QIAY\u0003gCq!!*\u0002,\u0002\u0007q\fC\u0004\u0002*\u0006-\u0006\u0019A3\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\u0006!2M]3bi\u0016dunZ%g\u001d>$X\t_5tiN$B!!\u0012\u0002<\"A\u0011QXA[\u0001\u0004\tI$A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:Dq!!1\u0001\t\u0013\t\u0019-\u0001\u0006oKb$Hj\\4ESJ$\u0012A\u0014\u0005\b\u0003\u000f\u0004A\u0011AAe\u0003)9W\r^(gMN,Go\u001d\u000b\t\u0003\u0017\fi-a4\u0002TB!!,a\u0016}\u0011!\ti,!2A\u0002\u0005e\u0002bBAi\u0003\u000b\u0004\r\u0001`\u0001\ni&lWm\u001d;b[BDq!!6\u0002F\u0002\u0007Q-A\u0007nCbtU/\\(gMN,Go\u001d\u0005\b\u00033\u0004A\u0011BAn\u0003Y\u0019G.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001cHcA3\u0002^\"91!a6A\u0002\u0005\u0015\u0003bBAq\u0001\u0011%\u00111]\u0001\u001eG2,\u0017M\\;q'\u0016<W.\u001a8ugR{W*Y5oi\u0006LgnU5{KR\u0019Q-!:\t\u000f\r\ty\u000e1\u0001\u0002F!9\u0011\u0011\u001e\u0001\u0005\u0002\u0005U\u0015aC2mK\u0006tW\u000f\u001d'pONDq!!<\u0001\t\u0003\t)*\u0001\u0005tQV$Hm\\<o\u0011\u001d\t\t\u0010\u0001C\u0001\u0003g\fq!\u00197m\u0019><7\u000f\u0006\u0002\u0002vB)!,a>\u0002F%\u0019\u0011\u0011`.\u0003\u0011%#XM]1cY\u0016Dq!!@\u0001\t\u0013\t)*\u0001\bgYV\u001c\b\u000eR5sifdunZ:\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u00059\u0002/\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a\u000b\u0005\u0003s\u0011)\u0001C\u0004\u0003\b\u0005}\b\u0019A0\u0002\t9\fW.\u001a\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0003\u0019!x\u000e]5dgR\u0011!q\u0002\t\u00055\u0006]x\fK\u0002\u0001\u0005'\u00012\u0001\u0005B\u000b\u0013\r\u00119\"\u0005\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0007")
public class LogManager
implements Logging {
    private final KafkaConfig config;
    private final KafkaScheduler scheduler;
    private final Time kafka$log$LogManager$$time;
    private final String CleanShutdownFile;
    private final String LockFile;
    private final File[] logDirs;
    private final Map<String, Object> kafka$log$LogManager$$logFileSizeMap;
    private final int kafka$log$LogManager$$logFlushInterval;
    private final Map<String, Object> kafka$log$LogManager$$logFlushIntervals;
    private final Object logCreationLock;
    private final Map<String, Object> logRetentionSizeMap;
    private final Map<String, Object> logRetentionMsMap;
    private final Map<String, Object> kafka$log$LogManager$$logRollMsMap;
    private final long kafka$log$LogManager$$logRollDefaultIntervalMs;
    private final long kafka$log$LogManager$$logCleanupIntervalMs;
    private final long kafka$log$LogManager$$logCleanupDefaultAgeMs;
    private final Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs;
    private Seq<FileLock> dirLocks;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogManager logManager = this;
        synchronized (logManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public final Time kafka$log$LogManager$$time() {
        return this.kafka$log$LogManager$$time;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String LockFile() {
        return this.LockFile;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public final Map<String, Object> kafka$log$LogManager$$logFileSizeMap() {
        return this.kafka$log$LogManager$$logFileSizeMap;
    }

    public final int kafka$log$LogManager$$logFlushInterval() {
        return this.kafka$log$LogManager$$logFlushInterval;
    }

    public final Map<String, Object> kafka$log$LogManager$$logFlushIntervals() {
        return this.kafka$log$LogManager$$logFlushIntervals;
    }

    private Object logCreationLock() {
        return this.logCreationLock;
    }

    private Map<String, Object> logRetentionSizeMap() {
        return this.logRetentionSizeMap;
    }

    private Map<String, Object> logRetentionMsMap() {
        return this.logRetentionMsMap;
    }

    public final Map<String, Object> kafka$log$LogManager$$logRollMsMap() {
        return this.kafka$log$LogManager$$logRollMsMap;
    }

    public final long kafka$log$LogManager$$logRollDefaultIntervalMs() {
        return this.kafka$log$LogManager$$logRollDefaultIntervalMs;
    }

    public final long kafka$log$LogManager$$logCleanupIntervalMs() {
        return this.kafka$log$LogManager$$logCleanupIntervalMs;
    }

    public final long kafka$log$LogManager$$logCleanupDefaultAgeMs() {
        return this.kafka$log$LogManager$$logCleanupDefaultAgeMs;
    }

    public final Pool<TopicAndPartition, Log> kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    private Seq<FileLock> dirLocks() {
        return this.dirLocks;
    }

    private void dirLocks_$eq(Seq<FileLock> seq) {
        this.dirLocks = seq;
    }

    private void createAndValidateLogDirs(Seq<File> seq) {
        if (((TraversableOnce)seq.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(File file) {
                return file.getCanonicalPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().size() < seq.size()) {
            throw new KafkaException(new StringBuilder().append((Object)"Duplicate log directory found: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).mkString(", ")).toString());
        }
        seq.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File file) {
                block5: {
                    block4: {
                        if (file.exists()) break block4;
                        this.$outer.info((Function0<String>)new Serializable(this, file){
                            public static final long serialVersionUID;
                            private final File dir$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Log directory '").append((Object)this.dir$1.getAbsolutePath()).append((Object)"' not found, creating it.").toString();
                            }
                            {
                                this.dir$1 = file;
                            }
                        });
                        boolean bl = file.mkdirs();
                        if (!bl) break block5;
                    }
                    if (file.isDirectory() && file.canRead()) {
                        return;
                    }
                    throw new KafkaException(new StringBuilder().append((Object)file.getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to create data directory ").append((Object)file.getAbsolutePath()).toString());
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        });
    }

    private Seq<FileLock> lockLogDirs(Seq<File> seq) {
        return (Seq)seq.map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final FileLock apply(File file) {
                FileLock fileLock = new FileLock(new File(file, this.$outer.LockFile()));
                if (fileLock.tryLock()) {
                    return fileLock;
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to acquire lock on file .lock in ").append((Object)fileLock.file().getParentFile().getAbsolutePath()).append((Object)". A Kafka instance in another process or thread is using this directory.").toString());
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void loadLogs(Seq<File> seq) {
        seq.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(File file) {
                File file2 = new File(file, this.$outer.CleanShutdownFile());
                boolean bl = !file2.exists();
                file2.delete();
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    Predef$.MODULE$.refArrayOps((Object[])fileArray).foreach((Function1)new Serializable(this, bl){
                        public static final long serialVersionUID;
                        private final $anonfun$loadLogs$1 $outer;
                        private final boolean needsRecovery$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(File file) {
                            if (file.isDirectory()) {
                                this.$outer.kafka$log$LogManager$$anonfun$$$outer().info((Function0<String>)new Serializable(this, file){
                                    public static final long serialVersionUID;
                                    private final File dir$2;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Loading log '").append((Object)this.dir$2.getName()).append((Object)"'").toString();
                                    }
                                    {
                                        this.dir$2 = file;
                                    }
                                });
                                TopicAndPartition topicAndPartition = this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$parseTopicPartitionName(file.getName());
                                long l = BoxesRunTime.unboxToLong((Object)this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logRollMsMap().get((Object)topicAndPartition.topic()).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID;
                                    private final $anonfun$loadLogs$1$$anonfun$apply$3 $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final long apply() {
                                        return this.apply$mcJ$sp();
                                    }

                                    public long apply$mcJ$sp() {
                                        return this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logRollDefaultIntervalMs();
                                    }
                                    {
                                        if (var1_1 == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = var1_1;
                                    }
                                }));
                                int n = BoxesRunTime.unboxToInt((Object)this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logFileSizeMap().get((Object)topicAndPartition.topic()).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID;
                                    private final $anonfun$loadLogs$1$$anonfun$apply$3 $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().config().logSegmentBytes();
                                    }
                                    {
                                        if (var1_1 == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = var1_1;
                                    }
                                }));
                                Log log = new Log(file, n, this.$outer.kafka$log$LogManager$$anonfun$$$outer().config().messageMaxBytes(), this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logFlushInterval(), l, this.needsRecovery$1, this.$outer.kafka$log$LogManager$$anonfun$$$outer().config().logIndexSizeMaxBytes(), this.$outer.kafka$log$LogManager$$anonfun$$$outer().config().logIndexIntervalBytes(), this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$time(), this.$outer.kafka$log$LogManager$$anonfun$$$outer().config().brokerId());
                                Log log2 = this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logs().put(topicAndPartition, log);
                                if (log2 != null) {
                                    throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Duplicate log directories found: %s, %s!").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.dir().getAbsolutePath(), log2.dir().getAbsolutePath()})));
                                }
                            }
                        }

                        public $anonfun$loadLogs$1 kafka$log$LogManager$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                            this.needsRecovery$1 = bl;
                        }
                    });
                }
            }

            public LogManager kafka$log$LogManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        });
    }

    public void startup() {
        if (this.scheduler != null) {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Starting log cleaner every ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$log$LogManager$$logCleanupIntervalMs())).append((Object)" ms").toString();
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            });
            this.scheduler.scheduleWithRate((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.cleanupLogs();
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            }, "kafka-logcleaner-", 60000L, this.kafka$log$LogManager$$logCleanupIntervalMs(), false);
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Starting log flusher every ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.config().logFlushSchedulerIntervalMs())).append((Object)" ms with the following overrides ").append(this.$outer.kafka$log$LogManager$$logFlushIntervals()).toString();
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            });
            this.scheduler.scheduleWithRate((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$log$LogManager$$flushDirtyLogs();
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            }, "kafka-logflusher-", this.config().logFlushSchedulerIntervalMs(), this.config().logFlushSchedulerIntervalMs(), false);
        }
    }

    public Option<Log> getLog(String string, int n) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        Log log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
        return log == null ? None$.MODULE$ : new Some((Object)log);
    }

    public Log getOrCreateLog(String string, int n) {
        Log log;
        block4: {
            Log log2;
            block3: {
                block2: {
                    TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
                    log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
                    if (log != null) break block2;
                    log2 = this.createLogIfNotExists(topicAndPartition);
                    break block3;
                }
                if (log == null) break block4;
                log2 = log;
            }
            return log2;
        }
        throw new MatchError((Object)log);
    }

    private Log createLogIfNotExists(TopicAndPartition topicAndPartition) {
        Object object = this.logCreationLock();
        synchronized (object) {
            Log log;
            block4: {
                log = this.kafka$log$LogManager$$logs().get(topicAndPartition);
                if (log != null) break block4;
                File file = this.nextLogDir();
                File file2 = new File(file, new StringBuilder().append((Object)topicAndPartition.topic()).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)topicAndPartition.partition())).toString());
                file2.mkdirs();
                long l = BoxesRunTime.unboxToLong((Object)this.kafka$log$LogManager$$logRollMsMap().get((Object)topicAndPartition.topic()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final LogManager $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.$outer.kafka$log$LogManager$$logRollDefaultIntervalMs();
                    }
                    {
                        if (logManager == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = logManager;
                    }
                }));
                int n = BoxesRunTime.unboxToInt((Object)this.kafka$log$LogManager$$logFileSizeMap().get((Object)topicAndPartition.topic()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final LogManager $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.$outer.config().logSegmentBytes();
                    }
                    {
                        if (logManager == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = logManager;
                    }
                }));
                log = new Log(file2, n, this.config().messageMaxBytes(), this.kafka$log$LogManager$$logFlushInterval(), l, false, this.config().logIndexSizeMaxBytes(), this.config().logIndexIntervalBytes(), this.kafka$log$LogManager$$time(), this.config().brokerId());
                this.info((Function0<String>)new Serializable(this, topicAndPartition, file){
                    public static final long serialVersionUID;
                    private final TopicAndPartition topicAndPartition$1;
                    private final File dataDir$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Created log for partition [%s,%d] in %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1.topic(), BoxesRunTime.boxToInteger((int)this.topicAndPartition$1.partition()), this.dataDir$1.getAbsolutePath()}));
                    }
                    {
                        this.topicAndPartition$1 = topicAndPartition;
                        this.dataDir$1 = file;
                    }
                });
                this.kafka$log$LogManager$$logs().put(topicAndPartition, log);
                Log log2 = log;
                return log2;
            }
            return log;
        }
    }

    private File nextLogDir() {
        File file;
        if (Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).size() == 1) {
            file = this.logDirs()[0];
        } else {
            scala.collection.immutable.Map map = this.allLogs().groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Log log) {
                    return log.dir().getParent();
                }
            }).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Iterable<Log> iterable) {
                    return iterable.size();
                }
            });
            scala.collection.immutable.Map map2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<String, Object> apply(File file) {
                    return new Tuple2((Object)file.getPath(), (Object)BoxesRunTime.boxToInteger((int)0));
                }
            }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(Tuple2.class, (OptManifest)ClassManifest$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[]{Manifest$.MODULE$.Int()}))))).toMap(Predef$.MODULE$.conforms());
            Buffer buffer = map2.$plus$plus((GenTraversableOnce)map).toBuffer();
            Tuple2 tuple2 = (Tuple2)((IterableLike)buffer.sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Tuple2<String, Object> tuple2) {
                    return tuple2._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$)).head();
            file = new File((String)tuple2._1());
        }
        return file;
    }

    public Seq<Object> getOffsets(TopicAndPartition topicAndPartition, long l, int n) {
        Option<Log> option;
        block4: {
            Seq<Object> seq;
            block3: {
                block2: {
                    Option<Log> option2 = this.getLog(topicAndPartition.topic(), topicAndPartition.partition());
                    option = option2;
                    if (!(option instanceof Some)) break block2;
                    seq = ((Log)((Some)option).x()).getOffsetsBefore(l, n);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Log> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                seq = Log$.MODULE$.getEmptyOffsets(l);
            }
            return seq;
        }
        throw new MatchError(option);
    }

    public final int kafka$log$LogManager$$cleanupExpiredSegments(Log log) {
        long l = this.kafka$log$LogManager$$time().milliseconds();
        String string = this.kafka$log$LogManager$$parseTopicPartitionName(log.name()).topic();
        long l2 = BoxesRunTime.unboxToLong((Object)this.logRetentionMsMap().get((Object)string).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.kafka$log$LogManager$$logCleanupDefaultAgeMs();
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        }));
        Seq<LogSegment> seq = log.markDeletedWhile((Function1<LogSegment, Object>)new Serializable(this, l, l2){
            public static final long serialVersionUID;
            private final long startMs$1;
            private final long logCleanupThresholdMs$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(LogSegment logSegment) {
                return this.startMs$1 - logSegment.messageSet().file().lastModified() > this.logCleanupThresholdMs$1;
            }
            {
                this.startMs$1 = l;
                this.logCleanupThresholdMs$1 = l2;
            }
        });
        int n = log.deleteSegments(seq);
        return n;
    }

    public final int kafka$log$LogManager$$cleanupSegmentsToMaintainSize(Log log) {
        String string = this.kafka$log$LogManager$$parseTopicPartitionName(log.dir().getName()).topic();
        long l = BoxesRunTime.unboxToLong((Object)this.logRetentionSizeMap().get((Object)string).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.config().logRetentionBytes();
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        }));
        if (l < 0L || log.size() < l) {
            return 0;
        }
        LongRef longRef = new LongRef(log.size() - l);
        Seq<LogSegment> seq = log.markDeletedWhile((Function1<LogSegment, Object>)new Serializable(this, longRef){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final LongRef diff$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(LogSegment logSegment) {
                return this.$outer.shouldDelete$1(logSegment, this.diff$1);
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
                this.diff$1 = longRef;
            }
        });
        int n = log.deleteSegments(seq);
        return n;
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Beginning log cleanup...";
            }
        });
        IntRef intRef = new IntRef(0);
        long l = this.kafka$log$LogManager$$time().milliseconds();
        this.allLogs().foreach((Function1)new Serializable(this, intRef){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final IntRef total$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Log log) {
                this.$outer.debug((Function0<String>)new Serializable(this, log){
                    public static final long serialVersionUID;
                    private final Log log$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Garbage collecting '").append((Object)this.log$2.name()).append((Object)"'").toString();
                    }
                    {
                        this.log$2 = log;
                    }
                });
                this.total$1.elem += this.$outer.kafka$log$LogManager$$cleanupExpiredSegments(log) + this.$outer.kafka$log$LogManager$$cleanupSegmentsToMaintainSize(log);
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
                this.total$1 = intRef;
            }
        });
        this.debug((Function0<String>)new Serializable(this, intRef, l){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final IntRef total$1;
            private final long startMs$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Log cleanup completed. ").append((Object)BoxesRunTime.boxToInteger((int)this.total$1.elem)).append((Object)" files deleted in ").append((Object)BoxesRunTime.boxToLong((long)((this.$outer.kafka$log$LogManager$$time().milliseconds() - this.startMs$2) / 1000L))).append((Object)" seconds").toString();
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
                this.total$1 = intRef;
                this.startMs$2 = l;
            }
        });
    }

    public void shutdown() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutting down.";
            }
        });
        try {
            this.allLogs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Log log) {
                    log.close();
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(File file) {
                    Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, file){
                        public static final long serialVersionUID;
                        private final $anonfun$shutdown$3 $outer;
                        private final File dir$3;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            new File(this.dir$3, this.$outer.kafka$log$LogManager$$anonfun$$$outer().CleanShutdownFile()).createNewFile();
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                            this.dir$3 = file;
                        }
                    });
                }

                public LogManager kafka$log$LogManager$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if (logManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = logManager;
                }
            });
        }
        catch (Throwable throwable) {
            this.dirLocks().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(FileLock fileLock) {
                    fileLock.destroy();
                }
            });
            throw throwable;
        }
        this.dirLocks().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutdown complete.";
            }
        });
    }

    public Iterable<Log> allLogs() {
        return this.kafka$log$LogManager$$logs().values();
    }

    public final void kafka$log$LogManager$$flushDirtyLogs() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Checking for dirty logs to flush...";
            }
        });
        this.allLogs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Log log) {
                block4: {
                    try {
                        long l = System.currentTimeMillis() - log.getLastFlushedTime();
                        IntRef intRef = new IntRef(this.$outer.config().logFlushIntervalMs());
                        if (this.$outer.kafka$log$LogManager$$logFlushIntervals().contains((Object)log.topicName())) {
                            intRef.elem = BoxesRunTime.unboxToInt((Object)this.$outer.kafka$log$LogManager$$logFlushIntervals().apply((Object)log.topicName()));
                        }
                        this.$outer.debug((Function0<String>)new Serializable(this, log, l, intRef){
                            public static final long serialVersionUID;
                            private final Log log$1;
                            private final long timeSinceLastFlush$1;
                            private final IntRef logFlushInterval$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)this.log$1.topicName()).append((Object)" flush interval  ").append((Object)BoxesRunTime.boxToInteger((int)this.logFlushInterval$1.elem)).append((Object)" last flushed ").append((Object)BoxesRunTime.boxToLong((long)this.log$1.getLastFlushedTime())).append((Object)" time since last flush: ").append((Object)BoxesRunTime.boxToLong((long)this.timeSinceLastFlush$1)).toString();
                            }
                            {
                                this.log$1 = log;
                                this.timeSinceLastFlush$1 = l;
                                this.logFlushInterval$1 = intRef;
                            }
                        });
                        if (l >= (long)intRef.elem) {
                            log.flush();
                        }
                    }
                    catch (Throwable throwable) {
                        this.$outer.error((Function0<String>)new Serializable(this, log){
                            public static final long serialVersionUID;
                            private final Log log$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Error flushing topic ").append((Object)this.log$1.topicName()).toString();
                            }
                            {
                                this.log$1 = log;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID;
                            private final Throwable e$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Throwable apply() {
                                return this.e$1;
                            }
                            {
                                this.e$1 = throwable;
                            }
                        });
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof IOException)) break block4;
                        this.$outer.fatal((Function0<String>)new Serializable(this, throwable){
                            public static final long serialVersionUID;
                            private final Throwable e$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Halting due to unrecoverable I/O error while flushing logs: ").append((Object)this.e$1.getMessage()).toString();
                            }
                            {
                                this.e$1 = throwable;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID;
                            private final Throwable e$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Throwable apply() {
                                return this.e$1;
                            }
                            {
                                this.e$1 = throwable;
                            }
                        });
                        System.exit(1);
                    }
                }
            }
            {
                if (logManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = logManager;
            }
        });
    }

    public final TopicAndPartition kafka$log$LogManager$$parseTopicPartitionName(String string) {
        int n = string.lastIndexOf(45);
        return new TopicAndPartition(string.substring(0, n), Predef$.MODULE$.augmentString(string.substring(n + 1)).toInt());
    }

    public Iterable<String> topics() {
        return (Iterable)this.kafka$log$LogManager$$logs().keys().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(TopicAndPartition topicAndPartition) {
                return topicAndPartition.topic();
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public final boolean shouldDelete$1(LogSegment logSegment, LongRef longRef) {
        boolean bl;
        if (longRef.elem - logSegment.size() >= 0L) {
            longRef.elem -= logSegment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(KafkaConfig kafkaConfig, KafkaScheduler kafkaScheduler, Time time) {
        this.config = kafkaConfig;
        this.scheduler = kafkaScheduler;
        this.kafka$log$LogManager$$time = time;
        Logging$class.$init$(this);
        this.CleanShutdownFile = ".kafka_cleanshutdown";
        this.LockFile = ".lock";
        this.logDirs = (File[])((TraversableOnce)kafkaConfig.logDirs().map((Function1)new $anonfun$7(this), Seq$.MODULE$.canBuildFrom())).toArray(ClassManifest$.MODULE$.classType(File.class));
        this.kafka$log$LogManager$$logFileSizeMap = kafkaConfig.logSegmentBytesPerTopicMap();
        this.kafka$log$LogManager$$logFlushInterval = kafkaConfig.logFlushIntervalMessages();
        this.kafka$log$LogManager$$logFlushIntervals = kafkaConfig.logFlushIntervalMsPerTopicMap();
        this.logCreationLock = new Object();
        this.logRetentionSizeMap = kafkaConfig.logRetentionBytesPerTopicMap();
        this.logRetentionMsMap = (Map)kafkaConfig.logRetentionHoursPerTopicMap().map((Function1)new $anonfun$8(this), Map$.MODULE$.canBuildFrom());
        this.kafka$log$LogManager$$logRollMsMap = (Map)kafkaConfig.logRollHoursPerTopicMap().map((Function1)new $anonfun$9(this), Map$.MODULE$.canBuildFrom());
        this.kafka$log$LogManager$$logRollDefaultIntervalMs = 3600000L * (long)kafkaConfig.logRollHours();
        this.kafka$log$LogManager$$logCleanupIntervalMs = 60000L * (long)kafkaConfig.logCleanupIntervalMins();
        this.kafka$log$LogManager$$logCleanupDefaultAgeMs = 3600000L * (long)kafkaConfig.logRetentionHours();
        this.logIdent_$eq(new StringBuilder().append((Object)"[Log Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)kafkaConfig.brokerId())).append((Object)"] ").toString());
        this.kafka$log$LogManager$$logs = new Pool(Pool$.MODULE$.init$default$1());
        this.createAndValidateLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])this.logDirs()));
        this.dirLocks = this.lockLogDirs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])this.logDirs()));
        this.loadLogs((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])this.logDirs()));
    }
}

