/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.common.InvalidOffsetException;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\t\u0017!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t;\u0001\u0011)\u0019!C\u0001=\u0005!a-\u001b7f+\u0005y\u0002C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\r\u0003\tIw.\u0003\u0002%C\t!a)\u001b7f\u0011!1\u0003A!A!\u0002\u0013y\u0012!\u00024jY\u0016\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011A\u0015\u0002\u0015\t\f7/Z(gMN,G/F\u0001+!\t92&\u0003\u0002-1\t!Aj\u001c8h\u0011!q\u0003A!A!\u0002\u0013Q\u0013a\u00032bg\u0016|eMZ:fi\u0002B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!M\u0001\r[\u0006D\u0018J\u001c3fqNK'0Z\u000b\u0002eA\u0011qcM\u0005\u0003ia\u00111!\u00138u\u0011!1\u0004A!A!\u0002\u0013\u0011\u0014!D7bq&sG-\u001a=TSj,\u0007\u0005C\u00039\u0001\u0011\u0005\u0011(\u0001\u0004=S:LGO\u0010\u000b\u0005uqjd\b\u0005\u0002<\u00015\t!\u0001C\u0003\u001eo\u0001\u0007q\u0004C\u0003)o\u0001\u0007!\u0006C\u00041oA\u0005\t\u0019\u0001\u001a\t\u000f\u0001\u0003\u0001\u0019!C\u0005\u0003\u0006!Q.\\1q+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#\r\u0003\rq\u0017n\\\u0005\u0003\u000f\u0012\u0013\u0001#T1qa\u0016$')\u001f;f\u0005V4g-\u001a:\t\u000f%\u0003\u0001\u0019!C\u0005\u0015\u0006AQ.\\1q?\u0012*\u0017\u000f\u0006\u0002L\u001dB\u0011q\u0003T\u0005\u0003\u001bb\u0011A!\u00168ji\"9q\nSA\u0001\u0002\u0004\u0011\u0015a\u0001=%c!1\u0011\u000b\u0001Q!\n\t\u000bQ!\\7ba\u0002Bqa\u0015\u0001A\u0002\u0013%A+\u0001\u0003tSj,W#A+\u0011\u0005YkV\"A,\u000b\u0005aK\u0016AB1u_6L7M\u0003\u0002[7\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005qc\u0011\u0001B;uS2L!AX,\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011\u001d\u0001\u0007\u00011A\u0005\n\u0005\f\u0001b]5{K~#S-\u001d\u000b\u0003\u0017\nDqaT0\u0002\u0002\u0003\u0007Q\u000b\u0003\u0004e\u0001\u0001\u0006K!V\u0001\u0006g&TX\r\t\u0005\bM\u0002\u0001\r\u0011\"\u0001*\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0005\bQ\u0002\u0001\r\u0011\"\u0001j\u00039a\u0017m\u001d;PM\u001a\u001cX\r^0%KF$\"a\u00136\t\u000f=;\u0017\u0011!a\u0001U!1A\u000e\u0001Q!\n)\n1\u0002\\1ti>3gm]3uA!)a\u000e\u0001C\u0001c\u0005QQ.\u0019=F]R\u0014\u0018.Z:\t\u000bA\u0004A\u0011B9\u0002\u001dI,\u0017\r\u001a'bgR|eMZ:fiR\t!\u0006C\u0003t\u0001\u0011\u0005A/\u0001\u0004m_>\\W\u000f\u001d\u000b\u0003kb\u0004\"a\u000f<\n\u0005]\u0014!AD(gMN,G\u000fU8tSRLwN\u001c\u0005\u0006sJ\u0004\rAK\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r\u001e\u0005\u0006w\u0002!I\u0001`\u0001\rS:$W\r_*m_R4uN\u001d\u000b\u0005eu\f)\u0001C\u0003\u007fu\u0002\u0007q0A\u0002jIb\u00042aQA\u0001\u0013\r\t\u0019\u0001\u0012\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B={\u0001\u0004Q\u0003bBA\u0005\u0001\u0011%\u00111B\u0001\u000fe\u0016d\u0017\r^5wK>3gm]3u)\u0015\u0011\u0014QBA\t\u0011\u001d\ty!a\u0002A\u0002}\faAY;gM\u0016\u0014\bbBA\n\u0003\u000f\u0001\rAM\u0001\u0002]\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0011\u0001\u00039isNL7-\u00197\u0015\u000bI\nY\"!\b\t\u000f\u0005=\u0011Q\u0003a\u0001\u007f\"9\u00111CA\u000b\u0001\u0004\u0011\u0004bBA\u0011\u0001\u0011\u0005\u00111E\u0001\u0006K:$(/\u001f\u000b\u0004k\u0006\u0015\u0002bBA\n\u0003?\u0001\rA\r\u0005\b\u0003S\u0001A\u0011AA\u0016\u0003\u0019\t\u0007\u000f]3oIR)1*!\f\u00022!9\u0011qFA\u0014\u0001\u0004Q\u0013AB8gMN,G\u000fC\u0004\u00024\u0005\u001d\u0002\u0019\u0001\u001a\u0002\u0011A|7/\u001b;j_:Dq!a\u000e\u0001\t\u0003\tI$\u0001\u0004jg\u001a+H\u000e\\\u000b\u0003\u0003w\u00012aFA\u001f\u0013\r\ty\u0004\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\n\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0002\u0017\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013A\u0003;sk:\u001c\u0017\r^3U_R\u00191*!\u0014\t\u000f\u0005=\u0012q\ta\u0001U!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0013!\u0005;sk:\u001c\u0017\r^3U_\u0016sGO]5fgR\u00191*!\u0016\t\u000f\u0005]\u0013q\na\u0001e\u00059QM\u001c;sS\u0016\u001c\bbBA.\u0001\u0011\u0005\u0011QI\u0001\u0010iJLW\u000eV8WC2LGmU5{K\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014A\u0002:fg&TX\rF\u0002L\u0003GBq!!\u001a\u0002^\u0001\u0007!'A\u0004oK^\u001c\u0016N_3\t\u000f\u0005%\u0004\u0001\"\u0001\u0002F\u0005)a\r\\;tQ\"9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0014A\u00023fY\u0016$X\r\u0006\u0002\u0002<!9\u0011q\u000b\u0001\u0005\u0002\u0005MD#\u0001\u001a\t\u000f\u0005]\u0004\u0001\"\u0001\u0002F\u0005)1\r\\8tK\"9\u00111\u0010\u0001\u0005\n\u0005u\u0014\u0001\u0006:pk:$Gk\\#yC\u000e$X*\u001e7uSBdW\rF\u00033\u0003\u007f\n\u0019\tC\u0004\u0002\u0002\u0006e\u0004\u0019\u0001\u001a\u0002\r9,XNY3s\u0011\u001d\t))!\u001fA\u0002I\naAZ1di>\u0014x!CAE\u0005\u0005\u0005\tRAAF\u0003-yeMZ:fi&sG-\u001a=\u0011\u0007m\niI\u0002\u0005\u0002\u0005\u0005\u0005\tRAAH'\u0011\ti\t\u0003\f\t\u000fa\ni\t\"\u0001\u0002\u0014R\u0011\u00111\u0012\u0005\u000b\u0003/\u000bi)%A\u0005\u0002\u0005e\u0015AD5oSR$C-\u001a4bk2$HeM\u000b\u0003\u00037S3AMAOW\t\ty\n\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\u0013Ut7\r[3dW\u0016$'bAAU1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00161\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class OffsetIndex
implements Logging {
    private final File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private MappedByteBuffer kafka$log$OffsetIndex$$mmap;
    private AtomicInteger kafka$log$OffsetIndex$$size;
    private long lastOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int init$default$3() {
        return OffsetIndex$.MODULE$.init$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public File file() {
        return this.file;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public final MappedByteBuffer kafka$log$OffsetIndex$$mmap() {
        return this.kafka$log$OffsetIndex$$mmap;
    }

    private void kafka$log$OffsetIndex$$mmap_$eq(MappedByteBuffer mappedByteBuffer) {
        this.kafka$log$OffsetIndex$$mmap = mappedByteBuffer;
    }

    public final AtomicInteger kafka$log$OffsetIndex$$size() {
        return this.kafka$log$OffsetIndex$$size;
    }

    private void kafka$log$OffsetIndex$$size_$eq(AtomicInteger atomicInteger) {
        this.kafka$log$OffsetIndex$$size = atomicInteger;
    }

    public long lastOffset() {
        return this.lastOffset;
    }

    public void lastOffset_$eq(long l) {
        this.lastOffset = l;
    }

    public int maxEntries() {
        return this.kafka$log$OffsetIndex$$mmap().limit() / 8;
    }

    private long readLastOffset() {
        int n = this.kafka$log$OffsetIndex$$size().get();
        int n2 = n == 0 ? 0 : this.relativeOffset(this.kafka$log$OffsetIndex$$mmap(), n - 1);
        return this.baseOffset() + (long)n2;
    }

    public OffsetPosition lookup(long l) {
        ByteBuffer byteBuffer = this.kafka$log$OffsetIndex$$mmap().duplicate();
        int n = this.indexSlotFor(byteBuffer, l);
        return n == -1 ? new OffsetPosition(this.baseOffset(), 0) : new OffsetPosition(this.baseOffset() + (long)this.relativeOffset(byteBuffer, n), this.physical(byteBuffer, n));
    }

    private int indexSlotFor(ByteBuffer byteBuffer, long l) {
        long l2 = l - this.baseOffset();
        if (this.entries() == 0) {
            return -1;
        }
        if ((long)this.relativeOffset(byteBuffer, 0) > l2) {
            return -1;
        }
        int n = 0;
        int n2 = this.entries() - 1;
        while (n < n2) {
            int n3 = (int)package$.MODULE$.ceil((double)n2 / 2.0 + (double)n / 2.0);
            int n4 = this.relativeOffset(byteBuffer, n3);
            if ((long)n4 == l2) {
                return n3;
            }
            if ((long)n4 < l2) {
                n = n3;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    private int relativeOffset(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n * 8);
    }

    private int physical(ByteBuffer byteBuffer, int n) {
        return byteBuffer.getInt(n * 8 + 4);
    }

    public OffsetPosition entry(int n) {
        if (n >= this.entries()) {
            throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.entries())})));
        }
        ByteBuffer byteBuffer = this.kafka$log$OffsetIndex$$mmap().duplicate();
        return new OffsetPosition(this.relativeOffset(byteBuffer, n), this.physical(byteBuffer, n));
    }

    public void append(long l, int n) {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            Predef$.MODULE$.require(!this.isFull(), (Function0)new Serializable(this){
                public static final long serialVersionUID;
                private final OffsetIndex $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append((Object)this.$outer.kafka$log$OffsetIndex$$size()).append((Object)").").toString();
                }
                {
                    if (offsetIndex == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = offsetIndex;
                }
            });
            if (this.kafka$log$OffsetIndex$$size().get() == 0 || l > this.lastOffset()) {
                this.debug((Function0<String>)new Serializable(this, l, n){
                    public static final long serialVersionUID;
                    private final OffsetIndex $outer;
                    private final long offset$1;
                    private final int position$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.position$1), this.$outer.file().getName()}));
                    }
                    {
                        if (offsetIndex == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = offsetIndex;
                        this.offset$1 = l;
                        this.position$1 = n;
                    }
                });
                this.kafka$log$OffsetIndex$$mmap().putInt((int)(l - this.baseOffset()));
                this.kafka$log$OffsetIndex$$mmap().putInt(n);
                this.kafka$log$OffsetIndex$$size().incrementAndGet();
                this.lastOffset_$eq(l);
                Predef$.MODULE$.require(this.entries() * 8 == this.kafka$log$OffsetIndex$$mmap().position(), (Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final OffsetIndex $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append(this.$outer.entries()).append((Object)" entries but file position in index is ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$mmap().position())).append((Object)".").toString();
                    }
                    {
                        if (offsetIndex == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = offsetIndex;
                    }
                });
                return;
            }
            throw new InvalidOffsetException(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l), BoxesRunTime.boxToInteger((int)this.entries()), BoxesRunTime.boxToLong((long)this.lastOffset()), this.file().getName()})));
        }
    }

    public boolean isFull() {
        return this.entries() >= this.maxEntries();
    }

    public void truncate() {
        this.truncateToEntries(0);
    }

    public void truncateTo(long l) {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            ByteBuffer byteBuffer = this.kafka$log$OffsetIndex$$mmap().duplicate();
            int n = this.indexSlotFor(byteBuffer, l);
            int n2 = n < 0 ? 0 : ((long)this.relativeOffset(byteBuffer, n) == l - this.baseOffset() ? n : n + 1);
            this.truncateToEntries(n2);
            return;
        }
    }

    private void truncateToEntries(int n) {
        this.kafka$log$OffsetIndex$$size().set(n);
        this.kafka$log$OffsetIndex$$mmap().position(this.kafka$log$OffsetIndex$$size().get() * 8);
        this.lastOffset_$eq(this.readLastOffset());
    }

    public void trimToValidSize() {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            this.resize(this.entries() * 8);
            return;
        }
    }

    public void resize(int n) {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            this.flush();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file(), "rws");
            int n2 = this.roundToExactMultiple(n, 8);
            this.liftedTree2$1(randomAccessFile, n2);
            return;
        }
    }

    public void flush() {
        OffsetIndex offsetIndex = this;
        synchronized (offsetIndex) {
            this.kafka$log$OffsetIndex$$mmap().force();
            return;
        }
    }

    public boolean delete() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Deleting index ").append((Object)this.$outer.file().getAbsolutePath()).toString();
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        });
        return this.file().delete();
    }

    public int entries() {
        return this.kafka$log$OffsetIndex$$size().get();
    }

    public void close() {
        this.trimToValidSize();
    }

    private int roundToExactMultiple(int n, int n2) {
        return n2 * (n / n2);
    }

    private final MappedByteBuffer liftedTree1$1(boolean bl, RandomAccessFile randomAccessFile) {
        MappedByteBuffer mappedByteBuffer = null;
        try {
            long l;
            if (bl) {
                if (this.maxIndexSize() < 8) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append((Object)BoxesRunTime.boxToInteger((int)this.maxIndexSize())).toString());
                }
                randomAccessFile.setLength(this.roundToExactMultiple(this.maxIndexSize(), 8));
            }
            if ((l = randomAccessFile.length()) < 0L || l % 8L != 0L) {
                throw new IllegalStateException(new StringBuilder().append((Object)"Index file ").append((Object)this.file().getName()).append((Object)" is corrupt, found ").append((Object)BoxesRunTime.boxToLong((long)l)).append((Object)" bytes which is not positive or not a multiple of 8.").toString());
            }
            MappedByteBuffer mappedByteBuffer2 = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, l);
            Buffer buffer = bl ? mappedByteBuffer2.position(0) : mappedByteBuffer2.position(this.roundToExactMultiple(mappedByteBuffer2.limit(), 8));
            mappedByteBuffer = mappedByteBuffer2;
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, randomAccessFile){
                public static final long serialVersionUID;
                private final RandomAccessFile raf$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = randomAccessFile;
                }
            });
            return mappedByteBuffer;
        }
        catch (Throwable throwable) {
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    private final Buffer liftedTree2$1(RandomAccessFile randomAccessFile, int n) {
        Buffer buffer = null;
        try {
            randomAccessFile.setLength(n);
            int n2 = this.kafka$log$OffsetIndex$$mmap().position();
            this.kafka$log$OffsetIndex$$mmap_$eq(randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, n));
            buffer = this.kafka$log$OffsetIndex$$mmap().position(n2);
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this, randomAccessFile){
                public static final long serialVersionUID;
                private final RandomAccessFile raf$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$2.close();
                }
                {
                    this.raf$2 = randomAccessFile;
                }
            });
            return buffer;
        }
        catch (Throwable throwable) {
            Utils$.MODULE$.swallow((Function0<BoxedUnit>)new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    public OffsetIndex(File file, long l, int n) {
        this.file = file;
        this.baseOffset = l;
        this.maxIndexSize = n;
        Logging$class.$init$(this);
        boolean bl = file.createNewFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        this.kafka$log$OffsetIndex$$mmap = this.liftedTree1$1(bl, randomAccessFile);
        this.kafka$log$OffsetIndex$$size = new AtomicInteger(this.kafka$log$OffsetIndex$$mmap().position() / 8);
        this.lastOffset = this.readLastOffset();
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final OffsetIndex $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)this.$outer.maxEntries()), BoxesRunTime.boxToInteger((int)this.$outer.maxIndexSize()), BoxesRunTime.boxToInteger((int)this.$outer.entries()), BoxesRunTime.boxToLong((long)this.$outer.lastOffset()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$OffsetIndex$$mmap().position())}));
            }
            {
                if (offsetIndex == null) {
                    throw new NullPointerException();
                }
                this.$outer = offsetIndex;
            }
        });
    }
}

