/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFactory$;
import kafka.message.Message;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import scala.Function0;
import scala.Function1;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.package$;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteBufferMessageSet$
implements ScalaObject {
    public static final ByteBufferMessageSet$ MODULE$;

    static {
        new ByteBufferMessageSet$();
    }

    public final ByteBuffer kafka$message$ByteBufferMessageSet$$create(AtomicLong atomicLong, CompressionCodec compressionCodec, Seq<Message> seq) {
        DataOutputStream dataOutputStream;
        ByteBuffer byteBuffer;
        if (seq.size() == 0) {
            byteBuffer = MessageSet$.MODULE$.Empty().buffer();
        } else {
            CompressionCodec compressionCodec2 = compressionCodec;
            NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)seq));
                seq.foreach((Function1)new Serializable(atomicLong, byteBuffer2){
                    public static final long serialVersionUID;
                    private final AtomicLong offsetCounter$1;
                    private final ByteBuffer buffer$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Message message) {
                        ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$writeMessage(this.buffer$1, message, this.offsetCounter$1.getAndIncrement());
                    }
                    {
                        this.offsetCounter$1 = atomicLong;
                        this.buffer$1 = byteBuffer;
                    }
                });
                byteBuffer2.rewind();
                byteBuffer = byteBuffer2;
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(MessageSet$.MODULE$.messageSetSize((Iterable<Message>)seq));
                dataOutputStream = new DataOutputStream(CompressionFactory$.MODULE$.apply(compressionCodec, byteArrayOutputStream));
                LongRef longRef = new LongRef(-1L);
                seq.foreach((Function1)new Serializable(atomicLong, dataOutputStream, longRef){
                    public static final long serialVersionUID;
                    private final AtomicLong offsetCounter$1;
                    private final DataOutputStream output$1;
                    private final LongRef offset$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Message message) {
                        this.offset$1.elem = this.offsetCounter$1.getAndIncrement();
                        this.output$1.writeLong(this.offset$1.elem);
                        this.output$1.writeInt(message.size());
                        this.output$1.write(message.buffer().array(), message.buffer().arrayOffset(), message.buffer().limit());
                    }
                    {
                        this.offsetCounter$1 = atomicLong;
                        this.output$1 = dataOutputStream;
                        this.offset$1 = longRef;
                    }
                });
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Message message = new Message(byArray, compressionCodec);
                ByteBuffer byteBuffer3 = ByteBuffer.allocate(message.size() + MessageSet$.MODULE$.LogOverhead());
                this.kafka$message$ByteBufferMessageSet$$writeMessage(byteBuffer3, message, longRef.elem);
                byteBuffer3.rewind();
                byteBuffer = byteBuffer3;
            }
        }
        return byteBuffer;
        finally {
            dataOutputStream.close();
        }
    }

    public ByteBufferMessageSet decompress(Message message) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteBufferBackedInputStream byteBufferBackedInputStream = new ByteBufferBackedInputStream(message.payload());
        byte[] byArray = new byte[1024];
        InputStream inputStream = CompressionFactory$.MODULE$.apply(message.compressionCodec(), byteBufferBackedInputStream);
        package$.MODULE$.Stream().continually((Function0)new Serializable(byArray, inputStream){
            public static final long serialVersionUID;
            private final byte[] intermediateBuffer$1;
            private final InputStream compressed$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.compressed$1.read(this.intermediateBuffer$1);
            }
            {
                this.intermediateBuffer$1 = byArray;
                this.compressed$1 = inputStream;
            }
        }).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int n) {
                return this.apply$mcZI$sp(n);
            }

            public boolean apply$mcZI$sp(int n) {
                return n > 0;
            }
        }).foreach((Function1)new Serializable(byteArrayOutputStream, byArray){
            public static final long serialVersionUID;
            private final ByteArrayOutputStream outputStream$1;
            private final byte[] intermediateBuffer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int n) {
                this.apply$mcVI$sp(n);
            }

            public void apply$mcVI$sp(int n) {
                this.outputStream$1.write(this.intermediateBuffer$1, 0, n);
            }
            {
                this.outputStream$1 = byteArrayOutputStream;
                this.intermediateBuffer$1 = byArray;
            }
        });
        ByteBuffer byteBuffer = ByteBuffer.allocate(byteArrayOutputStream.size());
        byteBuffer.put(byteArrayOutputStream.toByteArray());
        byteBuffer.rewind();
        return new ByteBufferMessageSet(byteBuffer);
        finally {
            inputStream.close();
        }
    }

    public final void kafka$message$ByteBufferMessageSet$$writeMessage(ByteBuffer byteBuffer, Message message, long l) {
        byteBuffer.putLong(l);
        byteBuffer.putInt(message.size());
        byteBuffer.put(message.buffer());
        message.buffer().rewind();
    }

    private ByteBufferMessageSet$() {
        MODULE$ = this;
    }
}

