/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.TopicMetadata;
import kafka.common.QueueFullException;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.producer.KeyedMessage;
import kafka.producer.Partitioner;
import kafka.producer.Producer$;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.ProducerTopicStats;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.serializer.Encoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0002\u0015:pIV\u001cWM\u001d\u0006\u0003\u0007\u0011\t\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001Qc\u0001\u00052wM!\u0001!C\t\u0018!\tQq\"D\u0001\f\u0015\taQ\"\u0001\u0003mC:<'\"\u0001\b\u0002\t)\fg/Y\u0005\u0003!-\u0011aa\u00142kK\u000e$\bC\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t12CA\u0004M_\u001e<\u0017N\\4\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t=\u0001\u0011)\u0019!C\u0001?\u000511m\u001c8gS\u001e,\u0012\u0001\t\t\u0003C\tj\u0011AA\u0005\u0003G\t\u0011a\u0002\u0015:pIV\u001cWM]\"p]\u001aLw\r\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003!\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\n\u0001\u0003\u0006\u0004%I\u0001K\u0001\rKZ,g\u000e\u001e%b]\u0012dWM]\u000b\u0002SA!!&L\u0018;\u001b\u0005Y#B\u0001\u0017\u0003\u0003\u0015\t7/\u001f8d\u0013\tq3F\u0001\u0007Fm\u0016tG\u000fS1oI2,'\u000f\u0005\u00021c1\u0001A!\u0002\u001a\u0001\u0005\u0004\u0019$!A&\u0012\u0005Q:\u0004C\u0001\r6\u0013\t1\u0014DA\u0004O_RD\u0017N\\4\u0011\u0005aA\u0014BA\u001d\u001a\u0005\r\te.\u001f\t\u0003am\"Q\u0001\u0010\u0001C\u0002M\u0012\u0011A\u0016\u0005\t}\u0001\u0011\t\u0011)A\u0005S\u0005iQM^3oi\"\u000bg\u000e\u001a7fe\u0002BQ\u0001\u0011\u0001\u0005\u0002\u0005\u000ba\u0001P5oSRtDc\u0001\"D\tB!\u0011\u0005A\u0018;\u0011\u0015qr\b1\u0001!\u0011\u00159s\b1\u0001*\u0011\u001d1\u0005A1A\u0005\n\u001d\u000b1\u0002[1t'\",H\u000fZ8x]V\t\u0001\n\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u00061\u0011\r^8nS\u000eT!!\u0014(\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002P\u001b\u0005!Q\u000f^5m\u0013\t\t&JA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007'\u0002\u0001\u000b\u0011\u0002%\u0002\u0019!\f7o\u00155vi\u0012|wO\u001c\u0011\t\u000fU\u0003!\u0019!C\u0005-\u0006)\u0011/^3vKV\tq\u000bE\u0002Y3nk\u0011\u0001T\u0005\u000352\u00131\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\u0004B!\t/0u%\u0011QL\u0001\u0002\r\u0017\u0016LX\rZ'fgN\fw-\u001a\u0005\u0007?\u0002\u0001\u000b\u0011B,\u0002\rE,X-^3!\u0011\u001d\t\u0007A1A\u0005\n\t\faA]1oI>lW#A2\u0011\u0005\u0011,W\"\u0001(\n\u0005\u0019t%A\u0002*b]\u0012|W\u000e\u0003\u0004i\u0001\u0001\u0006IaY\u0001\be\u0006tGm\\7!\u0011\u001dQ\u0007\u00011A\u0005\n-\fAa]=oGV\tA\u000e\u0005\u0002\u0019[&\u0011a.\u0007\u0002\b\u0005>|G.Z1o\u0011\u001d\u0001\b\u00011A\u0005\nE\f\u0001b]=oG~#S-\u001d\u000b\u0003eV\u0004\"\u0001G:\n\u0005QL\"\u0001B+oSRDqA^8\u0002\u0002\u0003\u0007A.A\u0002yIEBa\u0001\u001f\u0001!B\u0013a\u0017!B:z]\u000e\u0004\u0003b\u0002>\u0001\u0001\u0004%Ia_\u0001\u0013aJ|G-^2feN+g\u000e\u001a+ie\u0016\fG-F\u0001}!\u0011QSp\f\u001e\n\u0005y\\#A\u0005)s_\u0012,8-\u001a:TK:$G\u000b\u001b:fC\u0012D\u0011\"!\u0001\u0001\u0001\u0004%I!a\u0001\u0002-A\u0014x\u000eZ;dKJ\u001cVM\u001c3UQJ,\u0017\rZ0%KF$2A]A\u0003\u0011\u001d1x0!AA\u0002qDq!!\u0003\u0001A\u0003&A0A\nqe>$WoY3s'\u0016tG\r\u00165sK\u0006$\u0007\u0005C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010\u0005\u0011\u0002O]8ek\u000e,'\u000fV8qS\u000e\u001cF/\u0019;t+\t\t\t\u0002E\u0002\"\u0003'I1!!\u0006\u0003\u0005I\u0001&o\u001c3vG\u0016\u0014Hk\u001c9jGN#\u0018\r^:\t\u0011\u0005e\u0001\u0001)A\u0005\u0003#\t1\u0003\u001d:pIV\u001cWM\u001d+pa&\u001c7\u000b^1ug\u0002Ba\u0001\u0011\u0001\u0005\u0002\u0005uAc\u0001\"\u0002 !1a$a\u0007A\u0002\u0001Bq!a\t\u0001\t\u0003\t)#\u0001\u0003tK:$Gc\u0001:\u0002(!A\u0011\u0011FA\u0011\u0001\u0004\tY#\u0001\u0005nKN\u001c\u0018mZ3t!\u0011A\u0012QF.\n\u0007\u0005=\u0012D\u0001\u0006=e\u0016\u0004X-\u0019;fIzBq!a\r\u0001\t\u0013\t)$A\u0006sK\u000e|'\u000fZ*uCR\u001cHc\u0001:\u00028!A\u0011\u0011FA\u0019\u0001\u0004\tI\u0004E\u0003\u0002<\u0005-3L\u0004\u0003\u0002>\u0005\u001dc\u0002BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\rc!\u0001\u0004=e>|GOP\u0005\u00025%\u0019\u0011\u0011J\r\u0002\u000fA\f7m[1hK&!\u0011QJA(\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0013J\u0002bBA*\u0001\u0011%\u0011QK\u0001\nCNLhnY*f]\u0012$2A]A,\u0011!\tI#!\u0015A\u0002\u0005e\u0002bBA.\u0001\u0011\u0005\u0011QL\u0001\u0006G2|7/\u001a\u000b\u0002e\u0002")
public class Producer<K, V>
implements Logging,
ScalaObject {
    private final ProducerConfig config;
    private final EventHandler<K, V> eventHandler;
    private final AtomicBoolean hasShutdown;
    private final LinkedBlockingQueue<KeyedMessage<K, V>> kafka$producer$Producer$$queue;
    private final Random random;
    private boolean sync;
    private ProducerSendThread<K, V> producerSendThread;
    private final ProducerTopicStats kafka$producer$Producer$$producerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Producer producer = this;
        synchronized (producer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public ProducerConfig config() {
        return this.config;
    }

    private EventHandler<K, V> eventHandler() {
        return this.eventHandler;
    }

    private AtomicBoolean hasShutdown() {
        return this.hasShutdown;
    }

    public final LinkedBlockingQueue<KeyedMessage<K, V>> kafka$producer$Producer$$queue() {
        return this.kafka$producer$Producer$$queue;
    }

    private Random random() {
        return this.random;
    }

    private boolean sync() {
        return this.sync;
    }

    private void sync_$eq(boolean bl) {
        this.sync = bl;
    }

    private ProducerSendThread<K, V> producerSendThread() {
        return this.producerSendThread;
    }

    private void producerSendThread_$eq(ProducerSendThread<K, V> producerSendThread) {
        this.producerSendThread = producerSendThread;
    }

    public final ProducerTopicStats kafka$producer$Producer$$producerTopicStats() {
        return this.kafka$producer$Producer$$producerTopicStats;
    }

    public void send(Seq<KeyedMessage<K, V>> seq) {
        boolean bl;
        block6: {
            block5: {
                block4: {
                    if (this.hasShutdown().get()) {
                        throw new ProducerClosedException();
                    }
                    this.recordStats(seq);
                    bl = this.sync();
                    if (!bl) break block4;
                    this.eventHandler().handle(seq);
                    break block5;
                }
                if (bl) break block6;
                this.asyncSend(seq);
            }
            return;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private void recordStats(Seq<KeyedMessage<K, V>> seq) {
        seq.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final Producer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(KeyedMessage<K, V> keyedMessage) {
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerTopicStats(keyedMessage.topic()).messageRate().mark();
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerAllTopicsStats().messageRate().mark();
            }
            {
                if (producer == null) {
                    throw new NullPointerException();
                }
                this.$outer = producer;
            }
        });
    }

    private void asyncSend(Seq<KeyedMessage<K, V>> seq) {
        seq.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final Producer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(KeyedMessage<K, V> keyedMessage) {
                boolean bl;
                boolean bl2;
                int n = this.$outer.config().queueEnqueueTimeoutMs();
                if (n == 0) {
                    bl2 = this.$outer.kafka$producer$Producer$$queue().offer(keyedMessage);
                } else {
                    boolean bl3 = false;
                    try {
                        boolean bl4;
                        boolean bl5;
                        boolean bl6 = bl5 = this.$outer.config().queueEnqueueTimeoutMs() < 0;
                        if (bl5) {
                            this.$outer.kafka$producer$Producer$$queue().put(keyedMessage);
                            bl4 = true;
                        } else {
                            bl4 = this.$outer.kafka$producer$Producer$$queue().offer(keyedMessage, this.$outer.config().queueEnqueueTimeoutMs(), TimeUnit.MILLISECONDS);
                        }
                        bl3 = bl4;
                    }
                    catch (InterruptedException interruptedException) {
                        bl3 = false;
                    }
                    bl2 = bl = bl3;
                }
                if (bl) {
                    this.$outer.trace((Function0<String>)new Serializable(this, keyedMessage){
                        public static final long serialVersionUID;
                        private final KeyedMessage message$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Added to send queue an event: ").append((Object)this.message$1.toString()).toString();
                        }
                        {
                            this.message$1 = var2_2;
                        }
                    });
                    this.$outer.trace((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$asyncSend$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Remaining queue size: ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$producer$Producer$$anonfun$$$outer().kafka$producer$Producer$$queue().remainingCapacity())).toString();
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                        }
                    });
                    return;
                }
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerTopicStats(keyedMessage.topic()).droppedMessageRate().mark();
                this.$outer.kafka$producer$Producer$$producerTopicStats().getProducerAllTopicsStats().droppedMessageRate().mark();
                throw new QueueFullException(new StringBuilder().append((Object)"Event queue is full of unsent messages, could not send event: ").append((Object)keyedMessage.toString()).toString());
            }

            public Producer kafka$producer$Producer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (producer == null) {
                    throw new NullPointerException();
                }
                this.$outer = producer;
            }
        });
    }

    public void close() {
        boolean bl = this.hasShutdown().compareAndSet(false, true);
        if (bl) {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Shutting down producer";
                }
            });
            if (this.producerSendThread() != null) {
                this.producerSendThread().shutdown();
            }
            this.eventHandler().close();
        }
    }

    public Producer(ProducerConfig producerConfig, EventHandler<K, V> eventHandler) {
        String string;
        block3: {
            block2: {
                this.config = producerConfig;
                this.eventHandler = eventHandler;
                Logging$class.$init$(this);
                this.hasShutdown = new AtomicBoolean(false);
                this.kafka$producer$Producer$$queue = new LinkedBlockingQueue(producerConfig.queueBufferingMaxMessages());
                this.random = new Random();
                this.sync = true;
                this.producerSendThread = null;
                String string2 = string = producerConfig.producerType();
                String string3 = "sync";
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block2;
                String string4 = string;
                String string5 = "async";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
                this.sync_$eq(false);
                this.producerSendThread_$eq(new ProducerSendThread<K, V>(new StringBuilder().append((Object)"ProducerSendThread-").append((Object)producerConfig.clientId()).toString(), this.kafka$producer$Producer$$queue(), eventHandler, producerConfig.queueBufferingMaxMs(), producerConfig.batchNumMessages(), producerConfig.clientId()));
                this.producerSendThread().start();
            }
            this.kafka$producer$Producer$$producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(producerConfig.clientId());
            KafkaMetricsReporter$.MODULE$.startReporters(producerConfig.props());
            return;
        }
        throw new MatchError((Object)string);
    }

    public Producer(ProducerConfig producerConfig) {
        this(producerConfig, new DefaultEventHandler(producerConfig, (Partitioner)Utils$.MODULE$.createObject(producerConfig.partitionerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{producerConfig.props()})), (Encoder)Utils$.MODULE$.createObject(producerConfig.serializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{producerConfig.props()})), (Encoder)Utils$.MODULE$.createObject(producerConfig.keySerializerClass(), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{producerConfig.props()})), new ProducerPool(producerConfig), (HashMap<String, TopicMetadata>)DefaultEventHandler$.MODULE$.init$default$6()));
    }
}

