/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.TopicAndPartition;
import kafka.server.HighwaterMarkCheckpoint$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001u<Q!\u0001\u0002\t\u0006\u001d\tq\u0003S5hQ^\fG/\u001a:NCJ\\7\t[3dWB|\u0017N\u001c;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0006-\u0011q\u0003S5hQ^\fG/\u001a:NCJ\\7\t[3dWB|\u0017N\u001c;\u0014\u0007%aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000bmIA\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\u0010\n\u0005\u0004%\taH\u0001\u0016Q&<\u0007nV1uKJl\u0017M]6GS2,g*Y7f+\u0005\u0001\u0003CA\u0007\"\u0013\t\u0011cB\u0001\u0004TiJLgn\u001a\u0005\u0007I%\u0001\u000b\u0011\u0002\u0011\u0002-!Lw\r[,bi\u0016\u0014X.\u0019:l\r&dWMT1nK\u0002BqAJ\u0005C\u0002\u0013\u0005q%A\u0010dkJ\u0014XM\u001c;IS\u001eDw/\u0019;fe6\u000b'o\u001b$jY\u00164VM]:j_:,\u0012\u0001\u000b\t\u0003+%J!A\u000b\f\u0003\u0007%sG\u000f\u0003\u0004-\u0013\u0001\u0006I\u0001K\u0001!GV\u0014(/\u001a8u\u0011&<\u0007n^1uKJl\u0015M]6GS2,g+\u001a:tS>t\u0007E\u0002\u0003\u000b\u0005\u0001q3\u0003B\u0017\r_Q\u0001\"\u0001M\u001a\u000e\u0003ER!A\r\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\n$a\u0002'pO\u001eLgn\u001a\u0005\tm5\u0012)\u0019!C\u0001o\u0005!\u0001/\u0019;i+\u0005A\u0004CA\u001d=\u001d\t)\"(\u0003\u0002<-\u00051\u0001K]3eK\u001aL!AI\u001f\u000b\u0005m2\u0002\u0002C .\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u000bA\fG\u000f\u001b\u0011\t\u000bmiC\u0011A!\u0015\u0005\t\u001b\u0005C\u0001\u0005.\u0011\u00151\u0004\t1\u00019\u0011\u001d)UF1A\u0005\u0002}\tAA\\1nK\"1q)\fQ\u0001\n\u0001\nQA\\1nK\u0002Bq!S\u0017C\u0002\u0013%!*\u0001\u0004io\u001aKG.Z\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a\nE\u0001\u0003S>L!\u0001U'\u0003\t\u0019KG.\u001a\u0005\u0007%6\u0002\u000b\u0011B&\u0002\u000f!<h)\u001b7fA!9A+\fb\u0001\n\u0013)\u0016A\u00035x\r&dW\rT8dWV\ta\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006)An\\2lg*\u00111\fX\u0001\u000bG>t7-\u001e:sK:$(BA/\u0011\u0003\u0011)H/\u001b7\n\u0005}C&!\u0004*fK:$(/\u00198u\u0019>\u001c7\u000e\u0003\u0004b[\u0001\u0006IAV\u0001\fQ^4\u0015\u000e\\3M_\u000e\\\u0007\u0005C\u0003d[\u0011\u0005A-A\u0003xe&$X\r\u0006\u0002fQB\u0011QCZ\u0005\u0003OZ\u0011A!\u00168ji\")\u0011N\u0019a\u0001U\u0006Q\u0002.[4io\u0006$XM]'be.\u001c\b+\u001a:QCJ$\u0018\u000e^5p]B!\u0011h[7t\u0013\taWHA\u0002NCB\u0004\"A\\9\u000e\u0003=T!\u0001\u001d\u0003\u0002\r\r|W.\\8o\u0013\t\u0011xNA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004\"!\u0006;\n\u0005U4\"\u0001\u0002'p]\u001eDQa^\u0017\u0005\u0002a\fAA]3bIR\u00191/_>\t\u000bi4\b\u0019\u0001\u001d\u0002\u000bQ|\u0007/[2\t\u000bq4\b\u0019\u0001\u0015\u0002\u0013A\f'\u000f^5uS>t\u0007")
public class HighwaterMarkCheckpoint
implements Logging {
    private final String path;
    private final String name;
    private final File hwFile;
    private final ReentrantLock hwFileLock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int currentHighwaterMarkFileVersion() {
        return HighwaterMarkCheckpoint$.MODULE$.currentHighwaterMarkFileVersion();
    }

    public static final String highWatermarkFileName() {
        return HighwaterMarkCheckpoint$.MODULE$.highWatermarkFileName();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        HighwaterMarkCheckpoint highwaterMarkCheckpoint = this;
        synchronized (highwaterMarkCheckpoint) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public String path() {
        return this.path;
    }

    public String name() {
        return this.name;
    }

    private File hwFile() {
        return this.hwFile;
    }

    private ReentrantLock hwFileLock() {
        return this.hwFileLock;
    }

    public void write(Map<TopicAndPartition, Object> map) {
        this.hwFileLock().lock();
        try {
            File file = new File(Predef$.MODULE$.any2stringadd((Object)this.hwFile()).$plus(".tmp"));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger((int)HighwaterMarkCheckpoint$.MODULE$.currentHighwaterMarkFileVersion())).toString());
            bufferedWriter.newLine();
            bufferedWriter.write(((Object)BoxesRunTime.boxToInteger((int)map.size())).toString());
            bufferedWriter.newLine();
            map.foreach((Function1)new Serializable(this, bufferedWriter){
                public static final long serialVersionUID;
                private final BufferedWriter hwFileWriter$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<TopicAndPartition, Object> tuple2) {
                    this.hwFileWriter$1.write(Predef$.MODULE$.augmentString("%s %s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TopicAndPartition)tuple2._1()).topic(), BoxesRunTime.boxToInteger((int)((TopicAndPartition)tuple2._1()).partition()), BoxesRunTime.boxToLong((long)tuple2._2$mcJ$sp())})));
                    this.hwFileWriter$1.newLine();
                }
                {
                    this.hwFileWriter$1 = bufferedWriter;
                }
            });
            bufferedWriter.flush();
            bufferedWriter.close();
            if (!file.renameTo(this.hwFile())) {
                this.hwFile().delete();
                if (!file.renameTo(this.hwFile())) {
                    this.fatal((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Attempt to swap the new high watermark file with the old one failed";
                        }
                    });
                    System.exit(1);
                }
            }
            return;
        }
        finally {
            this.hwFileLock().unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long read(String string, int n) {
        this.hwFileLock().lock();
        long l = 0L;
        try {
            long l2;
            long l3 = this.hwFile().length();
            if (l3 == 0L) {
                this.warn((Function0<String>)new Serializable(this, string, n){
                    public static final long serialVersionUID;
                    private final String topic$1;
                    private final int partition$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("No highwatermark file is found. Returning 0 as the highwatermark for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                    }
                    {
                        this.topic$1 = string;
                        this.partition$1 = n;
                    }
                });
                l2 = 0L;
            } else {
                short s;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.hwFile()));
                short s2 = s = Predef$.MODULE$.augmentString(bufferedReader.readLine()).toShort();
                if (BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)HighwaterMarkCheckpoint$.MODULE$.currentHighwaterMarkFileVersion()), (Object)BoxesRunTime.boxToShort((short)s2))) {
                    Option option;
                    int n2 = Predef$.MODULE$.augmentString(bufferedReader.readLine()).toInt();
                    IndexedSeq indexedSeq = (IndexedSeq)Predef$.MODULE$.intWrapper(0).until(n2).map((Function1)new Serializable(this, bufferedReader){
                        public static final long serialVersionUID;
                        private final BufferedReader hwFileReader$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Tuple2<TopicAndPartition, Object> apply(int n) {
                            String string = this.hwFileReader$1.readLine();
                            String[] stringArray = string.split(" ");
                            String string2 = stringArray[0];
                            int n2 = Predef$.MODULE$.augmentString(stringArray[1]).toInt();
                            long l = Predef$.MODULE$.augmentString(stringArray[2]).toLong();
                            return Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(string2, n2)).$minus$greater((Object)BoxesRunTime.boxToLong((long)l));
                        }
                        {
                            this.hwFileReader$1 = bufferedReader;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    bufferedReader.close();
                    Option option2 = option = indexedSeq.toMap(Predef$.MODULE$.conforms()).get((Object)new TopicAndPartition(string, n));
                    if (option2 instanceof Some) {
                        long l4;
                        Some some = (Some)option2;
                        long l5 = l4 = BoxesRunTime.unboxToLong((Object)some.x());
                        this.debug((Function0<String>)new Serializable(this, string, n, l5){
                            public static final long serialVersionUID;
                            private final String topic$1;
                            private final int partition$1;
                            private final long hw$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Read hw %d for partition [%s,%d] from highwatermark checkpoint file").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.hw$1), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                            }
                            {
                                this.topic$1 = string;
                                this.partition$1 = n;
                                this.hw$1 = l;
                            }
                        });
                        l2 = l5;
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option3 = option2;
                        if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)option2);
                        this.warn((Function0<String>)new Serializable(this, string, n){
                            public static final long serialVersionUID;
                            private final String topic$1;
                            private final int partition$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("No previously checkpointed highwatermark value found for topic %s ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1}))).append((Object)Predef$.MODULE$.augmentString("partition %d. Returning 0 as the highwatermark").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partition$1)}))).toString();
                            }
                            {
                                this.topic$1 = string;
                                this.partition$1 = n;
                            }
                        });
                        l2 = 0L;
                    }
                } else {
                    this.fatal((Function0<String>)new Serializable(this, s){
                        public static final long serialVersionUID;
                        private final short version$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Unrecognized version of the highwatermark checkpoint file ").append((Object)BoxesRunTime.boxToShort((short)this.version$1)).toString();
                        }
                        {
                            this.version$1 = s;
                        }
                    });
                    System.exit(1);
                    l2 = -1L;
                }
            }
            l = l2;
            return l;
        }
        finally {
            this.hwFileLock().unlock();
        }
    }

    public HighwaterMarkCheckpoint(String string) {
        this.path = string;
        Logging$class.$init$(this);
        this.name = new StringBuilder().append((Object)string).append((Object)File.separator).append((Object)HighwaterMarkCheckpoint$.MODULE$.highWatermarkFileName()).toString();
        this.hwFile = new File(this.name());
        this.hwFileLock = new ReentrantLock();
    }
}

