/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsrRequest;
import kafka.api.PartitionStateInfo;
import kafka.api.StopReplicaRequest;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.common.ErrorMapping$;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.ReplicaNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.HighwaterMarkCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager$;
import kafka.utils.KafkaScheduler;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Time;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rMr!B\u0001\u0003\u0011\u000b9\u0011A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0003\u0017\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u00148cA\u0005\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\u000e\n\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001dq\u0012B1A\u0005\u0002}\t1#\u00168l]><h\u000eT8h\u000b:$wJ\u001a4tKR,\u0012\u0001\t\t\u0003+\u0005J!A\t\f\u0003\t1{gn\u001a\u0005\u0007I%\u0001\u000b\u0011\u0002\u0011\u0002)Us7N\\8x]2{w-\u00128e\u001f\u001a47/\u001a;!\r\u0011Q!\u0001\u0001\u0014\u0014\u000b\u0015bq%\f\u000b\u0011\u0005!ZS\"A\u0015\u000b\u0005)\"\u0011!B;uS2\u001c\u0018B\u0001\u0017*\u0005\u001daunZ4j]\u001e\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u0003\u0002\u000f5,GO]5dg&\u0011!g\f\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u001b&\u0005\u000b\u0007I\u0011A\u001b\u0002\r\r|gNZ5h+\u00051\u0004C\u0001\u00058\u0013\tA$AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002\u0003\u001e&\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002\u000f\r|gNZ5hA!AA(\nB\u0001B\u0003%Q(\u0001\u0003uS6,\u0007C\u0001\u0015?\u0013\ty\u0014F\u0001\u0003US6,\u0007\u0002C!&\u0005\u000b\u0007I\u0011\u0001\"\u0002\u0011i\\7\t\\5f]R,\u0012a\u0011\t\u0003\t.k\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0001B_6dY&,g\u000e\u001e\u0006\u0003\u0011&\u000ba!\u0013\u0019Ji\u0016\u001c'\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\u000b\nA!l[\"mS\u0016tG\u000f\u0003\u0005OK\t\u0005\t\u0015!\u0003D\u0003%Q8n\u00117jK:$\b\u0005\u0003\u0005QK\t\u0005\t\u0015!\u0003R\u00039Y\u0017MZ6b'\u000eDW\rZ;mKJ\u0004\"\u0001\u000b*\n\u0005MK#AD&bM.\f7k\u00195fIVdWM\u001d\u0005\t+\u0016\u0012)\u0019!C\u0001-\u0006QAn\\4NC:\fw-\u001a:\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!A\u0017\u0003\u0002\u00071|w-\u0003\u0002]3\nQAj\\4NC:\fw-\u001a:\t\u0011y+#\u0011!Q\u0001\n]\u000b1\u0002\\8h\u001b\u0006t\u0017mZ3sA!A\u0001-\nBC\u0002\u0013\u0005\u0011-\u0001\bjgNCW\u000f\u001e;j]\u001e$un\u001e8\u0016\u0003\t\u0004\"a\u00196\u000e\u0003\u0011T!!\u001a4\u0002\r\u0005$x.\\5d\u0015\t9\u0007.\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u001b\t\u0002\tU$\u0018\u000e\\\u0005\u0003W\u0012\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\u0002C7&\u0005\u0003\u0005\u000b\u0011\u00022\u0002\u001f%\u001c8\u000b[;ui&tw\rR8x]\u0002BQaG\u0013\u0005\u0002=$r\u0001]9sgR,h\u000f\u0005\u0002\tK!)AG\u001ca\u0001m!)AH\u001ca\u0001{!)\u0011I\u001ca\u0001\u0007\")\u0001K\u001ca\u0001#\")QK\u001ca\u0001/\")\u0001M\u001ca\u0001E\"9\u00010\na\u0001\n\u0003I\u0018aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0016\u0003i\u0004\"!F>\n\u0005q4\"aA%oi\"9a0\na\u0001\n\u0003y\u0018aE2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195`I\u0015\fH\u0003BA\u0001\u0003\u000f\u00012!FA\u0002\u0013\r\t)A\u0006\u0002\u0005+:LG\u000f\u0003\u0005\u0002\nu\f\t\u00111\u0001{\u0003\rAH%\r\u0005\b\u0003\u001b)\u0003\u0015)\u0003{\u0003A\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007\u0005\u000b\u0003\u0002\f\u0005E\u0001cA\u000b\u0002\u0014%\u0019\u0011Q\u0003\f\u0003\u0011Y|G.\u0019;jY\u0016D\u0001\"!\u0007&\u0005\u0004%I!_\u0001\u000eY>\u001c\u0017\r\u001c\"s_.,'/\u00133\t\u000f\u0005uQ\u0005)A\u0005u\u0006qAn\\2bY\n\u0013xn[3s\u0013\u0012\u0004\u0003\"CA\u0011K\t\u0007I\u0011BA\u0012\u00035\tG\u000e\u001c)beRLG/[8ogV\u0011\u0011Q\u0005\t\bQ\u0005\u001d\u00121FA \u0013\r\tI#\u000b\u0002\u0005!>|G\u000e\u0005\u0004\u0016\u0003[\t\tD_\u0005\u0004\u0003_1\"A\u0002+va2,'\u0007\u0005\u0003\u00024\u0005ebbA\u000b\u00026%\u0019\u0011q\u0007\f\u0002\rA\u0013X\rZ3g\u0013\u0011\tY$!\u0010\u0003\rM#(/\u001b8h\u0015\r\t9D\u0006\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0003\u0002\u000f\rdWo\u001d;fe&!\u0011\u0011JA\"\u0005%\u0001\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002N\u0015\u0002\u000b\u0011BA\u0013\u00039\tG\u000e\u001c)beRLG/[8og\u0002B\u0011\"!\u0015&\u0001\u0004%I!a\u0015\u0002!1,\u0017\rZ3s!\u0006\u0014H/\u001b;j_:\u001cXCAA+!\u0019\t9&!\u0019\u0002@5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&A\u0004nkR\f'\r\\3\u000b\u0007\u0005}c#\u0001\u0006d_2dWm\u0019;j_:LA!a\u0019\u0002Z\t9\u0001*Y:i'\u0016$\b\"CA4K\u0001\u0007I\u0011BA5\u0003QaW-\u00193feB\u000b'\u000f^5uS>t7o\u0018\u0013fcR!\u0011\u0011AA6\u0011)\tI!!\u001a\u0002\u0002\u0003\u0007\u0011Q\u000b\u0005\t\u0003_*\u0003\u0015)\u0003\u0002V\u0005\tB.Z1eKJ\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u0013\u0005MTE1A\u0005\n\u0005U\u0014\u0001\u00067fC\u0012,'\u000fU1si&$\u0018n\u001c8t\u0019>\u001c7.F\u0001\r\u0011\u001d\tI(\nQ\u0001\n1\tQ\u0003\\3bI\u0016\u0014\b+\u0019:uSRLwN\\:M_\u000e\\\u0007\u0005C\u0005\u0002~\u0015\u0012\r\u0011\"\u0001\u0002\u0000\u0005)\"/\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014XCAAA!\rA\u00111Q\u0005\u0004\u0003\u000b\u0013!!\u0006*fa2L7-\u0019$fi\u000eDWM]'b]\u0006<WM\u001d\u0005\t\u0003\u0013+\u0003\u0015!\u0003\u0002\u0002\u00061\"/\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005\u0003\u0005\u0002\u000e\u0016\u0012\r\u0011\"\u0003b\u0003\u0011B\u0017n\u001a5XCR,'/\\1sW\u000eCWmY6Q_&tG\u000f\u00165sK\u0006$7\u000b^1si\u0016$\u0007bBAIK\u0001\u0006IAY\u0001&Q&<\u0007nV1uKJl\u0017M]6DQ\u0016\u001c7\u000eU8j]R$\u0006N]3bIN#\u0018M\u001d;fI\u0002B\u0011\"!&&\u0005\u0004%\t!a&\u00021!Lw\r[,bi\u0016\u0014X.\u0019:l\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002\u001aBA\u00111TAQ\u0003c\t)+\u0004\u0002\u0002\u001e*!\u0011qTA/\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002$\u0006u%aA'baB\u0019\u0001\"a*\n\u0007\u0005%&AA\fIS\u001eDw/\u0019;fe6\u000b'o[\"iK\u000e\\\u0007o\\5oi\"A\u0011QV\u0013!\u0002\u0013\tI*A\riS\u001eDw+\u0019;fe6\f'o[\"iK\u000e\\\u0007o\\5oiN\u0004\u0003\"CAYK\u0001\u0007I\u0011BAZ\u0003MAw\u000f\u00165sK\u0006$\u0017J\\5uS\u0006d\u0017N_3e+\t\t)\fE\u0002\u0016\u0003oK1!!/\u0017\u0005\u001d\u0011un\u001c7fC:D\u0011\"!0&\u0001\u0004%I!a0\u0002/!<H\u000b\u001b:fC\u0012Le.\u001b;jC2L'0\u001a3`I\u0015\fH\u0003BA\u0001\u0003\u0003D!\"!\u0003\u0002<\u0006\u0005\t\u0019AA[\u0011!\t)-\nQ!\n\u0005U\u0016\u0001\u00065x)\"\u0014X-\u00193J]&$\u0018.\u00197ju\u0016$\u0007\u0005C\u0005\u0002J\u0016\u0012\r\u0011\"\u0001\u0002L\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0005\u00055\u0007\u0003BAh\u00033l!!!5\u000b\t\u0005M\u0017Q[\u0001\u0006Y><GG\u001b\u0006\u0004\u0003/L\u0015AB1qC\u000eDW-\u0003\u0003\u0002\\\u0006E'A\u0002'pO\u001e,'\u000f\u0003\u0005\u0002`\u0016\u0002\u000b\u0011BAg\u0003I\u0019H/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0011\t\u0013\u0005\rXE1A\u0005\u0002\u0005\u0015\u0018!D5te\u0016C\b/\u00198e%\u0006$X-\u0006\u0002\u0002hB!\u0011\u0011^A}\u001b\t\tYO\u0003\u0003\u0002n\u0006=\u0018\u0001B2pe\u0016T1\u0001MAy\u0015\u0011\t\u00190!>\u0002\re\fW.\\3s\u0015\t\t90A\u0002d_6LA!a?\u0002l\n)Q*\u001a;fe\"A\u0011q`\u0013!\u0002\u0013\t9/\u0001\bjgJ,\u0005\u0010]1oIJ\u000bG/\u001a\u0011\t\u0013\t\rQE1A\u0005\u0002\u0005\u0015\u0018!D5teNC'/\u001b8l%\u0006$X\r\u0003\u0005\u0003\b\u0015\u0002\u000b\u0011BAt\u00039I7O]*ie&t7NU1uK\u0002BqAa\u0003&\t\u0003\u0011i!A\u0012ti\u0006\u0014H\u000fS5hQ^\u000bG/\u001a:NCJ\\7o\u00115fG.\u0004v.\u001b8u)\"\u0014X-\u00193\u0015\u0005\t=\u0001cA\u000b\u0003\u0012%\u0019!1\u0003\f\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\u0018\u0015\"\tA!\u0007\u0002A\u001d,GOU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\u0006u\nm!q\u0004\u0005\t\u0005;\u0011)\u00021\u0001\u00022\u0005)Ao\u001c9jG\"9!\u0011\u0005B\u000b\u0001\u0004Q\u0018a\u00039beRLG/[8o\u0013\u0012DqA!\n&\t\u0003\u00119#A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005\u0005\u0001b\u0002B\u0016K\u0011\u0005!QF\u0001\fgR|\u0007OU3qY&\u001c\u0017\r\u0006\u0005\u00030\tU\"q\u0007B\u001d!\r)\"\u0011G\u0005\u0004\u0005g1\"!B*i_J$\b\u0002\u0003B\u000f\u0005S\u0001\r!!\r\t\u000f\t\u0005\"\u0011\u0006a\u0001u\"A!1\bB\u0015\u0001\u0004\t),A\beK2,G/\u001a)beRLG/[8o\u0011\u001d\u0011y$\nC\u0001\u0005\u0003\nAb\u001d;paJ+\u0007\u000f\\5dCN$BAa\u0011\u0003JA9Q#!\f\u0003F\t=\u0002\u0003CA,\u0005\u000f\nYCa\f\n\t\u0005\r\u0016\u0011\f\u0005\t\u0005\u0017\u0012i\u00041\u0001\u0003N\u0005\u00112\u000f^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u!\u0011\u0011yE!\u0016\u000e\u0005\tE#b\u0001B*\t\u0005\u0019\u0011\r]5\n\t\t]#\u0011\u000b\u0002\u0013'R|\u0007OU3qY&\u001c\u0017MU3rk\u0016\u001cH\u000fC\u0004\u0003\\\u0015\"\tA!\u0018\u0002)\u001d,Go\u0014:De\u0016\fG/\u001a)beRLG/[8o)!\tyDa\u0018\u0003b\t\r\u0004\u0002\u0003B\u000f\u00053\u0002\r!!\r\t\u000f\t\u0005\"\u0011\fa\u0001u\"9!Q\rB-\u0001\u0004Q\u0018!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\"9!\u0011N\u0013\u0005\u0002\t-\u0014\u0001D4fiB\u000b'\u000f^5uS>tGC\u0002B7\u0005g\u0012)\bE\u0003\u0016\u0005_\ny$C\u0002\u0003rY\u0011aa\u00149uS>t\u0007\u0002\u0003B\u000f\u0005O\u0002\r!!\r\t\u000f\t\u0005\"q\ra\u0001u\"9!\u0011P\u0013\u0005\u0002\tm\u0014!F4fiJ+\u0007\u000f\\5dC>\u0013X\t_2faRLwN\u001c\u000b\u0007\u0005{\u0012\u0019I!\"\u0011\t\u0005\u0005#qP\u0005\u0005\u0005\u0003\u000b\u0019EA\u0004SKBd\u0017nY1\t\u0011\tu!q\u000fa\u0001\u0003cAqAa\"\u0003x\u0001\u0007!0A\u0005qCJ$\u0018\u000e^5p]\"9!1R\u0013\u0005\u0002\t5\u0015aF4fi2+\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u001adunY1m)\u0019\u0011iHa$\u0003\u0012\"A!Q\u0004BE\u0001\u0004\t\t\u0004C\u0004\u0003\"\t%\u0005\u0019\u0001>\t\u000f\tUU\u0005\"\u0001\u0003\u0018\u0006Qq-\u001a;SKBd\u0017nY1\u0015\u0011\te%1\u0014BO\u0005?\u0003R!\u0006B8\u0005{B\u0001B!\b\u0003\u0014\u0002\u0007\u0011\u0011\u0007\u0005\b\u0005C\u0011\u0019\n1\u0001{\u0011%\u0011\tKa%\u0011\u0002\u0003\u0007!0A\u0005sKBd\u0017nY1JI\"9!QU\u0013\u0005\u0002\t\u001d\u0016A\u00062fG>lW\rT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:\u0015\t\t%&\u0011\u0017\t\b+\u00055\"1\u0016B\u0018!!\u0011iKa,\u0002,\t=RBAA/\u0013\u0011\t\u0019+!\u0018\t\u0011\tM&1\u0015a\u0001\u0005k\u000b1\u0003\\3bI\u0016\u0014\u0018I\u001c3J'J\u0013V-];fgR\u0004BAa\u0014\u00038&!!\u0011\u0018B)\u0005MaU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u\u0011\u001d\u0011i,\nC\u0005\u0005\u007f\u000b!\"\\1lK2+\u0017\rZ3s)9\t\tA!1\u0003F\n%'1\u001aBg\u0005/DqAa1\u0003<\u0002\u0007!0\u0001\u0007d_:$(o\u001c7mKJLE\rC\u0004\u0003H\nm\u0006\u0019\u0001>\u0002\u000b\u0015\u0004xn\u00195\t\u0011\tu!1\u0018a\u0001\u0003cAqA!\t\u0003<\u0002\u0007!\u0010\u0003\u0005\u0003P\nm\u0006\u0019\u0001Bi\u0003I\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016LeNZ8\u0011\t\t=#1[\u0005\u0005\u0005+\u0014\tF\u0001\nQCJ$\u0018\u000e^5p]N#\u0018\r^3J]\u001a|\u0007b\u0002Bm\u0005w\u0003\rA_\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\t\u000f\tuW\u0005\"\u0003\u0003`\u0006aQ.Y6f\r>dGn\\<feR\u0001\u0012\u0011\u0001Bq\u0005G\u0014)Oa:\u0003j\n-(1 \u0005\b\u0005\u0007\u0014Y\u000e1\u0001{\u0011\u001d\u00119Ma7A\u0002iD\u0001B!\b\u0003\\\u0002\u0007\u0011\u0011\u0007\u0005\b\u0005C\u0011Y\u000e1\u0001{\u0011!\u0011yMa7A\u0002\tE\u0007\u0002\u0003Bw\u00057\u0004\rAa<\u0002\u0019\u0005d\u0017N^3MK\u0006$WM]:\u0011\r\t5&\u0011\u001fB{\u0013\u0011\u0011\u00190!\u0018\u0003\u0007M+G\u000f\u0005\u0003\u0002B\t]\u0018\u0002\u0002B}\u0003\u0007\u0012aA\u0011:pW\u0016\u0014\bb\u0002Bm\u00057\u0004\rA\u001f\u0005\b\u0005\u007f,C\u0011\u0002B\u0014\u00039i\u0017-\u001f2f'\"\u0014\u0018N\\6JgJDqaa\u0001&\t\u0003\u0019)!\u0001\fsK\u000e|'\u000f\u001a$pY2|w/\u001a:Q_NLG/[8o))\t\taa\u0002\u0004\n\r-1Q\u0002\u0005\t\u0005;\u0019\t\u00011\u0001\u00022!9!\u0011EB\u0001\u0001\u0004Q\bb\u0002BQ\u0007\u0003\u0001\rA\u001f\u0005\b\u0007\u001f\u0019\t\u00011\u0001!\u0003\u0019ygMZ:fi\"911C\u0013\u0005\u0002\t\u001d\u0012\u0001G2iK\u000e\\\u0007o\\5oi\"Kw\r[,bi\u0016\u0014X.\u0019:lg\"91qC\u0013\u0005\u0002\t\u001d\u0012\u0001C:ikR$wn\u001e8\t\u0013\rmQ%%A\u0005\u0002\ru\u0011\u0001F4fiJ+\u0007\u000f\\5dC\u0012\"WMZ1vYR$3'\u0006\u0002\u0004 )\u001a!p!\t,\u0005\r\r\u0002\u0003BB\u0013\u0007_i!aa\n\u000b\t\r%21F\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\f\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007c\u00199CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ReplicaManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Time time;
    private final ZkClient zkClient;
    private final KafkaScheduler kafkaScheduler;
    private final LogManager logManager;
    private final AtomicBoolean isShuttingDown;
    private volatile int controllerEpoch;
    private final int kafka$server$ReplicaManager$$localBrokerId;
    private final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions;
    private HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions;
    private final Object kafka$server$ReplicaManager$$leaderPartitionsLock;
    private final ReplicaFetcherManager replicaFetcherManager;
    private final AtomicBoolean highWatermarkCheckPointThreadStarted;
    private final scala.collection.immutable.Map<String, HighwaterMarkCheckpoint> highWatermarkCheckpoints;
    private boolean hwThreadInitialized;
    private final Logger stateChangeLogger;
    private final Meter isrExpandRate;
    private final Meter isrShrinkRate;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final long UnknownLogEndOffset() {
        return ReplicaManager$.MODULE$.UnknownLogEndOffset();
    }

    @Override
    public <T> Gauge<T> newGauge(String string, Gauge<T> gauge) {
        return KafkaMetricsGroup$class.newGauge(this, string, gauge);
    }

    @Override
    public Meter newMeter(String string, String string2, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, string, string2, timeUnit);
    }

    @Override
    public Histogram newHistogram(String string, boolean bl) {
        return KafkaMetricsGroup$class.newHistogram(this, string, bl);
    }

    @Override
    public Timer newTimer(String string, TimeUnit timeUnit, TimeUnit timeUnit2) {
        return KafkaMetricsGroup$class.newTimer(this, string, timeUnit, timeUnit2);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaManager replicaManager = this;
        synchronized (replicaManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public AtomicBoolean isShuttingDown() {
        return this.isShuttingDown;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    public final int kafka$server$ReplicaManager$$localBrokerId() {
        return this.kafka$server$ReplicaManager$$localBrokerId;
    }

    public final Pool<Tuple2<String, Object>, Partition> kafka$server$ReplicaManager$$allPartitions() {
        return this.kafka$server$ReplicaManager$$allPartitions;
    }

    public final HashSet<Partition> kafka$server$ReplicaManager$$leaderPartitions() {
        return this.kafka$server$ReplicaManager$$leaderPartitions;
    }

    private void kafka$server$ReplicaManager$$leaderPartitions_$eq(HashSet<Partition> hashSet) {
        this.kafka$server$ReplicaManager$$leaderPartitions = hashSet;
    }

    public final Object kafka$server$ReplicaManager$$leaderPartitionsLock() {
        return this.kafka$server$ReplicaManager$$leaderPartitionsLock;
    }

    public ReplicaFetcherManager replicaFetcherManager() {
        return this.replicaFetcherManager;
    }

    private AtomicBoolean highWatermarkCheckPointThreadStarted() {
        return this.highWatermarkCheckPointThreadStarted;
    }

    public scala.collection.immutable.Map<String, HighwaterMarkCheckpoint> highWatermarkCheckpoints() {
        return this.highWatermarkCheckpoints;
    }

    private boolean hwThreadInitialized() {
        return this.hwThreadInitialized;
    }

    private void hwThreadInitialized_$eq(boolean bl) {
        this.hwThreadInitialized = bl;
    }

    public Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public Meter isrExpandRate() {
        return this.isrExpandRate;
    }

    public Meter isrShrinkRate() {
        return this.isrShrinkRate;
    }

    public Object startHighWaterMarksCheckPointThread() {
        return this.highWatermarkCheckPointThreadStarted().compareAndSet(false, true) ? this.kafkaScheduler.scheduleWithRate((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.checkpointHighWatermarks();
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        }, "highwatermark-checkpoint-thread", 0L, this.config().replicaHighWatermarkCheckpointIntervalMs(), this.kafkaScheduler.scheduleWithRate$default$5()) : BoxedUnit.UNIT;
    }

    public int getReplicationFactorForPartition(String string, int n) {
        Option<Partition> option;
        block4: {
            int n2;
            block3: {
                block2: {
                    Option<Partition> option2 = this.getPartition(string, n);
                    option = option2;
                    if (!(option instanceof Some)) break block2;
                    n2 = ((Partition)((Some)option).x()).replicationFactor();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Partition> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                n2 = -1;
            }
            return n2;
        }
        throw new MatchError(option);
    }

    public void startup() {
        this.kafkaScheduler.scheduleWithRate((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$ReplicaManager$$maybeShrinkIsr();
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        }, "isr-expiration-thread-", 0L, this.config().replicaLagTimeMaxMs(), this.kafkaScheduler.scheduleWithRate$default$5());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short stopReplica(String string, int n, boolean bl) {
        Object object;
        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d handling stop replica for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), string, BoxesRunTime.boxToInteger((int)n)})));
        short s = ErrorMapping$.MODULE$.NoError();
        Option<Replica> option = this.getReplica(string, n, this.getReplica$default$3());
        if (option instanceof Some) {
            this.replicaFetcherManager().removeFetcher(string, n);
            Object object2 = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
            synchronized (object2) {
                this.kafka$server$ReplicaManager$$leaderPartitions().$minus$eq((Object)((Replica)((Some)option).x()).partition());
                // MONITOREXIT @DISABLED, blocks:[0, 1, 8] lbl11 : MonitorExitStatement: MONITOREXIT : object2
                if (bl) {
                    object = this.kafka$server$ReplicaManager$$allPartitions().remove((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)));
                }
                object = BoxedUnit.UNIT;
            }
        } else {
            None$ none$ = None$.MODULE$;
            Option<Replica> option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError(option);
                }
            } else if (!none$.equals(option2)) throw new MatchError(option);
            object = BoxedUnit.UNIT;
        }
        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d finished handling stop replica for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), string, BoxesRunTime.boxToInteger((int)n)})));
        return s;
    }

    public Tuple2<scala.collection.mutable.Map<Tuple2<String, Object>, Object>, Object> stopReplicas(StopReplicaRequest stopReplicaRequest) {
        Tuple2 tuple2;
        HashMap hashMap = new HashMap();
        if (stopReplicaRequest.controllerEpoch() < this.controllerEpoch()) {
            this.stateChangeLogger().warn((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Broker %d received stop replica request from an old controller epoch %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)stopReplicaRequest.controllerEpoch())}))).append((Object)" Latest known controller epoch is %d ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerEpoch())).toString());
            tuple2 = new Tuple2((Object)hashMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
        } else {
            this.controllerEpoch_$eq(stopReplicaRequest.controllerEpoch());
            HashMap hashMap2 = new HashMap();
            ((IterableLike)stopReplicaRequest.partitions().filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<String, Object> tuple2) {
                    Tuple2<String, Object> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(this, stopReplicaRequest, hashMap2){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;
                private final StopReplicaRequest stopReplicaRequest$1;
                private final HashMap responseMap$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Option<Object> apply(Tuple2<String, Object> tuple2) {
                    Tuple2<String, Object> tuple22 = tuple2;
                    if (tuple22 != null) {
                        String string = (String)tuple22._1();
                        int n = BoxesRunTime.unboxToInt((Object)tuple22._2());
                        String string2 = string;
                        int n2 = n;
                        short s = this.$outer.stopReplica(string2, n2, this.stopReplicaRequest$1.deletePartitions());
                        return this.responseMap$1.put((Object)new Tuple2((Object)string2, (Object)BoxesRunTime.boxToInteger((int)n2)), (Object)BoxesRunTime.boxToShort((short)s));
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if (replicaManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = replicaManager;
                    this.stopReplicaRequest$1 = stopReplicaRequest;
                    this.responseMap$1 = hashMap;
                }
            });
            tuple2 = new Tuple2((Object)hashMap2, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
        }
        return tuple2;
    }

    public Partition getOrCreatePartition(String string, int n, int n2) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)));
        if (partition == null) {
            this.kafka$server$ReplicaManager$$allPartitions().putIfNotExists((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)), new Partition(string, n, n2, this.time, this));
            partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)));
        }
        return partition;
    }

    public Option<Partition> getPartition(String string, int n) {
        Partition partition = this.kafka$server$ReplicaManager$$allPartitions().get((Tuple2<String, Object>)new Tuple2((Object)string, (Object)BoxesRunTime.boxToInteger((int)n)));
        return partition == null ? None$.MODULE$ : new Some((Object)partition);
    }

    public Replica getReplicaOrException(String string, int n) {
        Option<Replica> option = this.getReplica(string, n, this.getReplica$default$3());
        if (option.isDefined()) {
            return (Replica)option.get();
        }
        throw new ReplicaNotAvailableException(Predef$.MODULE$.augmentString("Replica %d is not available for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config().brokerId()), string, BoxesRunTime.boxToInteger((int)n)})));
    }

    public Replica getLeaderReplicaIfLocal(String string, int n) {
        Option<Partition> option;
        Option<Partition> option2 = option = this.getPartition(string, n);
        None$ none$ = None$.MODULE$;
        Option<Partition> option3 = option2;
        if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
            throw new UnknownTopicOrPartitionException(Predef$.MODULE$.augmentString("Partition [%s,%d] doesn't exist on %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
        }
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Partition partition = (Partition)some.x();
            Partition partition2 = partition;
            Option<Replica> option4 = partition2.leaderReplicaIfLocal();
            if (option4 instanceof Some) {
                return (Replica)((Some)option4).x();
            }
            None$ none$2 = None$.MODULE$;
            Option<Replica> option5 = option4;
            if (!(none$2 != null ? !none$2.equals(option5) : option5 != null)) {
                throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.config().brokerId())})));
            }
            throw new MatchError(option4);
        }
        throw new MatchError(option2);
    }

    public Option<Replica> getReplica(String string, int n, int n2) {
        Option<Partition> option;
        block4: {
            Option<Replica> option2;
            block3: {
                block2: {
                    Option<Partition> option3;
                    option = option3 = this.getPartition(string, n);
                    None$ none$ = None$.MODULE$;
                    Option<Partition> option4 = option;
                    if (none$ != null ? !none$.equals(option4) : option4 != null) break block2;
                    option2 = None$.MODULE$;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                option2 = ((Partition)((Some)option).x()).getReplica(n2);
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public int getReplica$default$3() {
        return this.config().brokerId();
    }

    public Tuple2<Map<Tuple2<String, Object>, Object>, Object> becomeLeaderOrFollower(LeaderAndIsrRequest leaderAndIsrRequest) {
        Tuple2 tuple2;
        leaderAndIsrRequest.partitionStateInfos().foreach((Function1)new Serializable(this, leaderAndIsrRequest){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;
            private final LeaderAndIsrRequest leaderAndISRRequest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                this.$outer.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d handling LeaderAndIsr request correlation id %d received from controller %d epoch %d for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), ((Tuple2)tuple2._1())._1(), BoxesRunTime.boxToInteger((int)((Tuple2)tuple2._1())._2$mcI$sp())})));
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
                this.leaderAndISRRequest$1 = leaderAndIsrRequest;
            }
        });
        this.info((Function0<String>)new Serializable(this, leaderAndIsrRequest){
            public static final long serialVersionUID;
            private final LeaderAndIsrRequest leaderAndISRRequest$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Handling LeaderAndIsr request %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leaderAndISRRequest$1}));
            }
            {
                this.leaderAndISRRequest$1 = leaderAndIsrRequest;
            }
        });
        HashMap hashMap = new HashMap();
        if (leaderAndIsrRequest.controllerEpoch() < this.controllerEpoch()) {
            this.stateChangeLogger().warn((Object)Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlation id %d with an old controller epoch %d. Latest known controller epoch is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)leaderAndIsrRequest.controllerEpoch()), BoxesRunTime.boxToInteger((int)leaderAndIsrRequest.correlationId()), BoxesRunTime.boxToInteger((int)this.controllerEpoch())})));
            tuple2 = new Tuple2((Object)hashMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.StaleControllerEpochCode()));
        } else {
            int n = leaderAndIsrRequest.controllerId();
            this.controllerEpoch_$eq(leaderAndIsrRequest.controllerEpoch());
            ((IterableLike)leaderAndIsrRequest.partitionStateInfos().filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                    Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(this, leaderAndIsrRequest, hashMap, n){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;
                private final LeaderAndIsrRequest leaderAndISRRequest$1;
                private final HashMap responseMap$2;
                private final int controllerId$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void apply(Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple2) {
                    Tuple2<Tuple2<String, Object>, PartitionStateInfo> tuple23 = tuple2;
                    if (tuple23 == null) throw new MatchError(tuple23);
                    Tuple2 tuple24 = (Tuple2)tuple23._1();
                    PartitionStateInfo partitionStateInfo = (PartitionStateInfo)tuple23._2();
                    Tuple2 tuple22 = tuple24;
                    PartitionStateInfo partitionStateInfo2 = partitionStateInfo;
                    short s = ErrorMapping$.MODULE$.NoError();
                    String string = (String)tuple22._1();
                    int n = tuple22._2$mcI$sp();
                    int n2 = partitionStateInfo2.leaderIsrAndControllerEpoch().leaderAndIsr().leader();
                    try {
                        if (n2 == this.$outer.config().brokerId()) {
                            this.$outer.kafka$server$ReplicaManager$$makeLeader(this.controllerId$1, this.$outer.controllerEpoch(), string, n, partitionStateInfo2, this.leaderAndISRRequest$1.correlationId());
                        } else {
                            this.$outer.kafka$server$ReplicaManager$$makeFollower(this.controllerId$1, this.$outer.controllerEpoch(), string, n, partitionStateInfo2, (Set<Broker>)this.leaderAndISRRequest$1.aliveLeaders(), this.leaderAndISRRequest$1.correlationId());
                        }
                    }
                    catch (Throwable throwable) {
                        string = Predef$.MODULE$.augmentString("Error on broker %d while processing LeaderAndIsr request correlationId %d received from controller %d epoch %d for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), tuple22}));
                        this.$outer.stateChangeLogger().error((Object)string, throwable);
                        s = ErrorMapping$.MODULE$.codeFor(throwable.getClass());
                    }
                    this.responseMap$2.put((Object)tuple22, (Object)BoxesRunTime.boxToShort((short)s));
                    this.$outer.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d handled LeaderAndIsr request correlationId %d received from controller %d epoch %d for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.correlationId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerId()), BoxesRunTime.boxToInteger((int)this.leaderAndISRRequest$1.controllerEpoch()), tuple22._1(), BoxesRunTime.boxToInteger((int)tuple22._2$mcI$sp())})));
                }
                {
                    if (replicaManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = replicaManager;
                    this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                    this.responseMap$2 = hashMap;
                    this.controllerId$1 = n;
                }
            });
            this.info((Function0<String>)new Serializable(this, leaderAndIsrRequest){
                public static final long serialVersionUID;
                private final LeaderAndIsrRequest leaderAndISRRequest$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Handled leader and isr request %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leaderAndISRRequest$1}));
                }
                {
                    this.leaderAndISRRequest$1 = leaderAndIsrRequest;
                }
            });
            if (!this.hwThreadInitialized()) {
                this.startHighWaterMarksCheckPointThread();
                this.hwThreadInitialized_$eq(true);
            }
            this.replicaFetcherManager().shutdownIdleFetcherThreads();
            tuple2 = new Tuple2((Object)hashMap, (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
        }
        return tuple2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void kafka$server$ReplicaManager$$makeLeader(int n, int n2, String string, int n3, PartitionStateInfo partitionStateInfo, int n4) {
        BoxedUnit boxedUnit;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = partitionStateInfo.leaderIsrAndControllerEpoch();
        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlationId %d from controller %d epoch %d starting the become-leader transition for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)n4), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)n2), string, BoxesRunTime.boxToInteger((int)n3)})));
        Partition partition = this.getOrCreatePartition(string, n3, partitionStateInfo.replicationFactor());
        if (partition.makeLeader(n, string, n3, leaderIsrAndControllerEpoch, n4)) {
            Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
            synchronized (object) {
                HashSet hashSet = this.kafka$server$ReplicaManager$$leaderPartitions().$plus$eq((Object)partition);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl9 : MonitorExitStatement: MONITOREXIT : object
                boxedUnit = hashSet;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d completed become-leader transition for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), string, BoxesRunTime.boxToInteger((int)n3)})));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void kafka$server$ReplicaManager$$makeFollower(int n, int n2, String string, int n3, PartitionStateInfo partitionStateInfo, Set<Broker> set, int n4) {
        BoxedUnit boxedUnit;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = partitionStateInfo.leaderIsrAndControllerEpoch();
        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d received LeaderAndIsr request correlationId %d from controller %d epoch %d starting the become-follower transition for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), BoxesRunTime.boxToInteger((int)n4), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)n2), string, BoxesRunTime.boxToInteger((int)n3)})));
        Partition partition = this.getOrCreatePartition(string, n3, partitionStateInfo.replicationFactor());
        if (partition.makeFollower(n, string, n3, leaderIsrAndControllerEpoch, set, n4)) {
            Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
            synchronized (object) {
                HashSet hashSet = this.kafka$server$ReplicaManager$$leaderPartitions().$minus$eq((Object)partition);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl9 : MonitorExitStatement: MONITOREXIT : object
                boxedUnit = hashSet;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d completed the become-follower transition for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId()), string, BoxesRunTime.boxToInteger((int)n3)})));
    }

    public final void kafka$server$ReplicaManager$$maybeShrinkIsr() {
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Evaluating ISR list of partitions to see which replicas can be removed from the ISR";
            }
        });
        Object object = this.kafka$server$ReplicaManager$$leaderPartitionsLock();
        synchronized (object) {
            this.kafka$server$ReplicaManager$$leaderPartitions().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final ReplicaManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Partition partition) {
                    partition.maybeShrinkIsr(this.$outer.config().replicaLagTimeMaxMs(), this.$outer.config().replicaLagMaxMessages());
                }
                {
                    if (replicaManager == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = replicaManager;
                }
            });
            return;
        }
    }

    public void recordFollowerPosition(String string, int n, int n2, long l) {
        Option<Partition> option = this.getPartition(string, n);
        if (option.isDefined()) {
            ((Partition)option.get()).updateLeaderHWAndMaybeExpandIsr(n2, l);
        } else {
            this.warn((Function0<String>)new Serializable(this, string, n){
                public static final long serialVersionUID;
                private final String topic$1;
                private final int partitionId$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("While recording the follower position, the partition [%s,%d] hasn't been created, skip updating leader HW").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1)}));
                }
                {
                    this.topic$1 = string;
                    this.partitionId$1 = n;
                }
            });
        }
    }

    public void checkpointHighWatermarks() {
        Iterable iterable = (Iterable)((TraversableLike)this.kafka$server$ReplicaManager$$allPartitions().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Replica> apply(Partition partition) {
                return partition.getReplica(this.$outer.config().brokerId());
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        }, Iterable$.MODULE$.canBuildFrom())).collect(new PartialFunction(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public <A1 extends Option<Replica>, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> partialFunction) {
                return PartialFunction.class.orElse((PartialFunction)this, partialFunction);
            }

            public <C> PartialFunction<Option<Replica>, C> andThen(Function1<Replica, C> function1) {
                return PartialFunction.class.andThen((PartialFunction)this, function1);
            }

            public Function1<Option<Replica>, Option<Replica>> lift() {
                return PartialFunction.class.lift((PartialFunction)this);
            }

            public boolean apply$mcZD$sp(double d) {
                return Function1.class.apply$mcZD$sp((Function1)this, (double)d);
            }

            public double apply$mcDD$sp(double d) {
                return Function1.class.apply$mcDD$sp((Function1)this, (double)d);
            }

            public float apply$mcFD$sp(double d) {
                return Function1.class.apply$mcFD$sp((Function1)this, (double)d);
            }

            public int apply$mcID$sp(double d) {
                return Function1.class.apply$mcID$sp((Function1)this, (double)d);
            }

            public long apply$mcJD$sp(double d) {
                return Function1.class.apply$mcJD$sp((Function1)this, (double)d);
            }

            public void apply$mcVD$sp(double d) {
                Function1.class.apply$mcVD$sp((Function1)this, (double)d);
            }

            public boolean apply$mcZF$sp(float f) {
                return Function1.class.apply$mcZF$sp((Function1)this, (float)f);
            }

            public double apply$mcDF$sp(float f) {
                return Function1.class.apply$mcDF$sp((Function1)this, (float)f);
            }

            public float apply$mcFF$sp(float f) {
                return Function1.class.apply$mcFF$sp((Function1)this, (float)f);
            }

            public int apply$mcIF$sp(float f) {
                return Function1.class.apply$mcIF$sp((Function1)this, (float)f);
            }

            public long apply$mcJF$sp(float f) {
                return Function1.class.apply$mcJF$sp((Function1)this, (float)f);
            }

            public void apply$mcVF$sp(float f) {
                Function1.class.apply$mcVF$sp((Function1)this, (float)f);
            }

            public boolean apply$mcZI$sp(int n) {
                return Function1.class.apply$mcZI$sp((Function1)this, (int)n);
            }

            public double apply$mcDI$sp(int n) {
                return Function1.class.apply$mcDI$sp((Function1)this, (int)n);
            }

            public float apply$mcFI$sp(int n) {
                return Function1.class.apply$mcFI$sp((Function1)this, (int)n);
            }

            public int apply$mcII$sp(int n) {
                return Function1.class.apply$mcII$sp((Function1)this, (int)n);
            }

            public long apply$mcJI$sp(int n) {
                return Function1.class.apply$mcJI$sp((Function1)this, (int)n);
            }

            public void apply$mcVI$sp(int n) {
                Function1.class.apply$mcVI$sp((Function1)this, (int)n);
            }

            public boolean apply$mcZJ$sp(long l) {
                return Function1.class.apply$mcZJ$sp((Function1)this, (long)l);
            }

            public double apply$mcDJ$sp(long l) {
                return Function1.class.apply$mcDJ$sp((Function1)this, (long)l);
            }

            public float apply$mcFJ$sp(long l) {
                return Function1.class.apply$mcFJ$sp((Function1)this, (long)l);
            }

            public int apply$mcIJ$sp(long l) {
                return Function1.class.apply$mcIJ$sp((Function1)this, (long)l);
            }

            public long apply$mcJJ$sp(long l) {
                return Function1.class.apply$mcJJ$sp((Function1)this, (long)l);
            }

            public void apply$mcVJ$sp(long l) {
                Function1.class.apply$mcVJ$sp((Function1)this, (long)l);
            }

            public <A> Function1<A, Replica> compose(Function1<A, Option<Replica>> function1) {
                return Function1.class.compose((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcZD$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcZD$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcDD$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcDD$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcFD$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcFD$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcID$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcID$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcJD$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcJD$sp((Function1)this, function1);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVD$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcVD$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcZF$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcZF$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcDF$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcDF$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcFF$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcFF$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcIF$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcIF$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcJF$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcJF$sp((Function1)this, function1);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVF$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcVF$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcZI$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcZI$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcDI$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcDI$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcFI$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcFI$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcII$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcII$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcJI$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcJI$sp((Function1)this, function1);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVI$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcVI$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcZJ$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcZJ$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcDJ$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcDJ$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcFJ$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcFJ$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcIJ$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcIJ$sp((Function1)this, function1);
            }

            public <A> Function1<A, Object> compose$mcJJ$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcJJ$sp((Function1)this, function1);
            }

            public <A> Function1<A, BoxedUnit> compose$mcVJ$sp(Function1<A, Object> function1) {
                return Function1.class.compose$mcVJ$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcZD$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcZD$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcDD$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcDD$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcFD$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcFD$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcID$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcID$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcJD$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcJD$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcVD$sp(Function1<BoxedUnit, A> function1) {
                return Function1.class.andThen$mcVD$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcZF$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcZF$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcDF$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcDF$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcFF$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcFF$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcIF$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcIF$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcJF$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcJF$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcVF$sp(Function1<BoxedUnit, A> function1) {
                return Function1.class.andThen$mcVF$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcZI$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcZI$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcDI$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcDI$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcFI$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcFI$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcII$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcII$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcJI$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcJI$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcVI$sp(Function1<BoxedUnit, A> function1) {
                return Function1.class.andThen$mcVI$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcZJ$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcZJ$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcDJ$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcDJ$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcFJ$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcFJ$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcIJ$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcIJ$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcJJ$sp(Function1<Object, A> function1) {
                return Function1.class.andThen$mcJJ$sp((Function1)this, function1);
            }

            public <A> Function1<Object, A> andThen$mcVJ$sp(Function1<BoxedUnit, A> function1) {
                return Function1.class.andThen$mcVJ$sp((Function1)this, function1);
            }

            public String toString() {
                return Function1.class.toString((Function1)this);
            }

            public final Replica apply(Option<Replica> option) {
                Option<Replica> option2 = option;
                if (option2 instanceof Some) {
                    return (Replica)((Some)option2).x();
                }
                throw new MatchError(option2);
            }

            public final boolean isDefinedAt(Option<Replica> option) {
                Option<Replica> option2 = option;
                return option2 instanceof Some;
            }
            {
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
            }
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map map = ((TraversableLike)iterable.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica replica) {
                return replica.log().isDefined();
            }
        })).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Replica replica) {
                return ((Log)replica.log().get()).dir().getParent();
            }
        });
        ((IterableLike)map.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, Iterable<Replica>> tuple2) {
                Tuple2<String, Iterable<Replica>> tuple22 = tuple2;
                if (tuple22 != null) {
                    Iterable iterable;
                    Iterable iterable2 = iterable = (Iterable)tuple22._2();
                    scala.collection.immutable.Map map = ((TraversableOnce)iterable2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Tuple2<TopicAndPartition, Object> apply(Replica replica) {
                            return Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(replica.topic(), replica.partitionId())).$minus$greater((Object)BoxesRunTime.boxToLong((long)replica.highWatermark()));
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                    ((HighwaterMarkCheckpoint)this.$outer.highWatermarkCheckpoints().apply(tuple22._1())).write((scala.collection.immutable.Map<TopicAndPartition, Object>)map);
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shut down";
            }
        });
        this.replicaFetcherManager().shutdown();
        this.checkpointHighWatermarks();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutted down completely";
            }
        });
    }

    public ReplicaManager(KafkaConfig kafkaConfig, Time time, ZkClient zkClient, KafkaScheduler kafkaScheduler, LogManager logManager, AtomicBoolean atomicBoolean) {
        this.config = kafkaConfig;
        this.time = time;
        this.zkClient = zkClient;
        this.kafkaScheduler = kafkaScheduler;
        this.logManager = logManager;
        this.isShuttingDown = atomicBoolean;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.kafka$server$ReplicaManager$$localBrokerId = kafkaConfig.brokerId();
        this.kafka$server$ReplicaManager$$allPartitions = new Pool(Pool$.MODULE$.init$default$1());
        this.kafka$server$ReplicaManager$$leaderPartitions = new HashSet();
        this.kafka$server$ReplicaManager$$leaderPartitionsLock = new Object();
        this.replicaFetcherManager = new ReplicaFetcherManager(kafkaConfig, this);
        this.highWatermarkCheckPointThreadStarted = new AtomicBoolean(false);
        this.highWatermarkCheckpoints = ((TraversableOnce)kafkaConfig.logDirs().map((Function1)new $anonfun$1(this), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.hwThreadInitialized = false;
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaManager$$localBrokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.newGauge("LeaderCount", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                Object object = this.$outer.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    Integer n = BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$leaderPartitions().size());
                    return BoxesRunTime.unboxToInt((Object)n);
                }
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        });
        this.newGauge("PartitionCount", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                return this.$outer.kafka$server$ReplicaManager$$allPartitions().size();
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        });
        this.newGauge("UnderReplicatedPartitions", new Gauge<Object>(this){
            private final ReplicaManager $outer;

            public int value() {
                Object object = this.$outer.kafka$server$ReplicaManager$$leaderPartitionsLock();
                synchronized (object) {
                    Integer n = BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaManager$$leaderPartitions().count((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(Partition partition) {
                            return partition.isUnderReplicated();
                        }
                    }));
                    return BoxesRunTime.unboxToInt((Object)n);
                }
            }
            {
                if (replicaManager == null) {
                    throw new NullPointerException();
                }
                this.$outer = replicaManager;
            }
        });
        this.isrExpandRate = this.newMeter("IsrExpandsPerSec", "expands", TimeUnit.SECONDS);
        this.isrShrinkRate = this.newMeter("ISRShrinksPerSec", "shrinks", TimeUnit.SECONDS);
    }
}

