/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.javaapi.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.DefaultDecoder;
import kafka.serializer.DefaultDecoder$;
import kafka.tools.KafkaMigrationTool;
import kafka.tools.MirrorMaker;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class MirrorMaker$
implements Logging {
    public static final MirrorMaker$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new MirrorMaker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        MirrorMaker$ mirrorMaker$ = this;
        synchronized (mirrorMaker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public void main(String[] stringArray) {
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Starting mirror maker";
            }
        });
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("consumer.config", "Consumer config to consume from a source cluster. You may specify multiple of these.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("producer.config", "Embedded producer config.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("num.producers", "Number of producer instances").withRequiredArg().describedAs("Number of producers").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec4 = optionParser.accepts("num.streams", "Number of consumption streams.").withRequiredArg().describedAs("Number of threads").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec5 = optionParser.accepts("queue.size", "Number of messages that are buffered between the consumer and producer").withRequiredArg().describedAs("Queue size in terms of number of messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec6 = optionParser.accepts("whitelist", "Whitelist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec7 = optionParser.accepts("blacklist", "Blacklist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        OptionSpecBuilder optionSpecBuilder = optionParser.accepts("help", "Print this message.");
        OptionSet optionSet = optionParser.parse(stringArray);
        if (optionSet.has((OptionSpec)optionSpecBuilder)) {
            optionParser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(optionParser, optionSet, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{argumentAcceptingOptionSpec, argumentAcceptingOptionSpec2}));
        if (List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec6, argumentAcceptingOptionSpec7})).count((Function1)new Serializable(optionSet){
            public static final long serialVersionUID;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(OptionSpec<?> optionSpec) {
                return this.options$1.has(optionSpec);
            }
            {
                this.options$1 = optionSet;
            }
        }) != 1) {
            Predef$.MODULE$.println((Object)"Exactly one of whitelist or blacklist is required.");
            System.exit(1);
        }
        Integer n = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec4);
        int n2 = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec5);
        IndexedSeq indexedSeq = (IndexedSeq)Predef$.MODULE$.intWrapper(1).to(((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec3)).intValue()).map((Function1)new Serializable(argumentAcceptingOptionSpec2, optionSet){
            public static final long serialVersionUID;
            private final ArgumentAcceptingOptionSpec producerConfigOpt$1;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final kafka.producer.Producer<byte[], byte[]> apply(int n) {
                ProducerConfig producerConfig = new ProducerConfig(Utils$.MODULE$.loadProps((String)this.options$1.valueOf((OptionSpec)this.producerConfigOpt$1)));
                return new kafka.producer.Producer<byte[], byte[]>(producerConfig);
            }
            {
                this.producerConfigOpt$1 = argumentAcceptingOptionSpec;
                this.options$1 = optionSet;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        List list = (List)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(optionSet.valuesOf((OptionSpec)argumentAcceptingOptionSpec)).toList().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ConsumerConfig apply(String string) {
                return new ConsumerConfig(Utils$.MODULE$.loadProps(string.toString()));
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ZookeeperConsumerConnector apply(ConsumerConfig consumerConfig) {
                return new ZookeeperConsumerConnector(consumerConfig);
            }
        }, List$.MODULE$.canBuildFrom());
        TopicFilter topicFilter = optionSet.has((OptionSpec)argumentAcceptingOptionSpec6) ? new Whitelist((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec6)) : new Blacklist((String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec7));
        Nil$ nil$ = Nil$.MODULE$;
        try {
            nil$ = (Seq)((GenericTraversableTemplate)list.map((Function1)new Serializable(n, topicFilter){
                public static final long serialVersionUID;
                private final Integer numStreams$1;
                private final TopicFilter filterSpec$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Seq<KafkaStream<byte[], byte[]>> apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                    return zookeeperConsumerConnector.createMessageStreamsByFilter(this.filterSpec$1, this.numStreams$1, new DefaultDecoder(DefaultDecoder$.MODULE$.init$default$1()), new DefaultDecoder(DefaultDecoder$.MODULE$.init$default$1()));
                }
                {
                    this.numStreams$1 = n;
                    this.filterSpec$1 = topicFilter;
                }
            }, List$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms());
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Unable to create stream - shutting down mirror maker.";
                }
            });
            list.foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                    zookeeperConsumerConnector.shutdown();
                }
            });
        }
        KafkaMigrationTool.ProducerDataChannel producerDataChannel = new KafkaMigrationTool.ProducerDataChannel(n2);
        Seq seq = (Seq)((TraversableLike)nil$.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(producerDataChannel){
            public static final long serialVersionUID;
            private final KafkaMigrationTool.ProducerDataChannel producerDataChannel$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final MirrorMaker.MirrorMakerThread apply(Tuple2<KafkaStream<byte[], byte[]>, Object> tuple2) {
                return new MirrorMaker.MirrorMakerThread((KafkaStream)tuple2._1(), this.producerDataChannel$1, tuple2._2$mcI$sp());
            }
            {
                this.producerDataChannel$1 = producerDataChannel;
            }
        }, Seq$.MODULE$.canBuildFrom());
        ListBuffer listBuffer = new ListBuffer();
        Runtime.getRuntime().addShutdownHook(new Thread(list, seq, listBuffer){
            private final List connectors$1;
            private final Seq consumerThreads$1;
            private final ListBuffer producerThreads$1;

            public void run() {
                MirrorMaker$.MODULE$.cleanShutdown$1(this.connectors$1, this.consumerThreads$1, this.producerThreads$1);
            }
            {
                this.connectors$1 = list;
                this.consumerThreads$1 = seq;
                this.producerThreads$1 = listBuffer;
            }
        });
        IntRef intRef = new IntRef(1);
        indexedSeq.foreach((Function1)new Serializable(producerDataChannel, listBuffer, intRef){
            public static final long serialVersionUID;
            private final KafkaMigrationTool.ProducerDataChannel producerDataChannel$1;
            private final ListBuffer producerThreads$1;
            private final IntRef i$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(kafka.producer.Producer<byte[], byte[]> producer) {
                KafkaMigrationTool.ProducerThread producerThread = new KafkaMigrationTool.ProducerThread(this.producerDataChannel$1, new Producer<byte[], byte[]>(producer), this.i$1.elem);
                this.producerThreads$1.$plus$eq((Object)producerThread);
                ++this.i$1.elem;
            }
            {
                this.producerDataChannel$1 = producerDataChannel;
                this.producerThreads$1 = listBuffer;
                this.i$1 = intRef;
            }
        });
        seq.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.MirrorMakerThread mirrorMakerThread) {
                mirrorMakerThread.start();
            }
        });
        listBuffer.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(KafkaMigrationTool.ProducerThread producerThread) {
                producerThread.start();
            }
        });
        seq.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.MirrorMakerThread mirrorMakerThread) {
                mirrorMakerThread.awaitShutdown();
            }
        });
        this.cleanShutdown$1(list, seq, listBuffer);
    }

    public final void cleanShutdown$1(List list, Seq seq, ListBuffer listBuffer) {
        list.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                zookeeperConsumerConnector.shutdown();
            }
        });
        seq.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.MirrorMakerThread mirrorMakerThread) {
                mirrorMakerThread.awaitShutdown();
            }
        });
        listBuffer.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(KafkaMigrationTool.ProducerThread producerThread) {
                producerThread.shutdown();
            }
        });
        listBuffer.foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(KafkaMigrationTool.ProducerThread producerThread) {
                producerThread.awaitShutdown();
            }
        });
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Kafka mirror maker shutdown successfully";
            }
        });
    }

    private MirrorMaker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

