/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.common.KafkaStorageException;
import kafka.log.FileMessageSet;
import kafka.log.Log$;
import kafka.log.LogFlushStats$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h'\u0016<W.\u001a8u\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0002\u0005\f\u0011\u0005%qQ\"\u0001\u0006\u000b\u0005-a\u0011\u0001\u00027b]\u001eT\u0011!D\u0001\u0005U\u00064\u0018-\u0003\u0002\u0010\u0015\t1qJ\u00196fGR\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0011\"a\u0002'pO\u001eLgn\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u0004\u0001\t\u0015\r\u0011\"\u0001\u001e+\u0005q\u0002CA\u0010!\u001b\u0005\u0011\u0011BA\u0011\u0003\u000591\u0015\u000e\\3NKN\u001c\u0018mZ3TKRD\u0001b\t\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0005Y><\u0007\u0005\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003\u0015Ig\u000eZ3y+\u00059\u0003CA\u0010)\u0013\tI#AA\u0006PM\u001a\u001cX\r^%oI\u0016D\b\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\r%tG-\u001a=!\u0011!i\u0003A!b\u0001\n\u0003q\u0013A\u00032bg\u0016|eMZ:fiV\tq\u0006\u0005\u0002\u0018a%\u0011\u0011\u0007\u0007\u0002\u0005\u0019>tw\r\u0003\u00054\u0001\t\u0005\t\u0015!\u00030\u0003-\u0011\u0017m]3PM\u001a\u001cX\r\u001e\u0011\t\u0011U\u0002!Q1A\u0005\u0002Y\n!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgV\tq\u0007\u0005\u0002\u0018q%\u0011\u0011\b\u0007\u0002\u0004\u0013:$\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002'%tG-\u001a=J]R,'O^1m\u0005f$Xm\u001d\u0011\t\u0011u\u0002!\u0011!Q\u0001\ny\nA\u0001^5nKB\u0011\u0011cP\u0005\u0003\u0001J\u0011A\u0001V5nK\")!\t\u0001C\u0001\u0007\u00061A(\u001b8jiz\"b\u0001R#G\u000f\"K\u0005CA\u0010\u0001\u0011\u0015\u0019\u0011\t1\u0001\u001f\u0011\u0015)\u0013\t1\u0001(\u0011\u0015i\u0013\t1\u00010\u0011\u0015)\u0014\t1\u00018\u0011\u0015i\u0014\t1\u0001?\u0011\u001dY\u0005\u00011A\u0005\u00029\nqa\u0019:fCR,G\rC\u0004N\u0001\u0001\u0007I\u0011\u0001(\u0002\u0017\r\u0014X-\u0019;fI~#S-\u001d\u000b\u0003\u001fJ\u0003\"a\u0006)\n\u0005EC\"\u0001B+oSRDqa\u0015'\u0002\u0002\u0003\u0007q&A\u0002yIEBa!\u0016\u0001!B\u0013y\u0013\u0001C2sK\u0006$X\r\u001a\u0011\t\u000f]\u0003\u0001\u0019!C\u0005m\u0005A\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=\t\u000fe\u0003\u0001\u0019!C\u00055\u0006a\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=`I\u0015\fHCA(\\\u0011\u001d\u0019\u0006,!AA\u0002]Ba!\u0018\u0001!B\u00139\u0014!\u00072zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss\u0002BQA\u0011\u0001\u0005\u0002}#b\u0001\u00121iU.l\u0007\"B1_\u0001\u0004\u0011\u0017a\u00013jeB\u00111MZ\u0007\u0002I*\u0011Q\rD\u0001\u0003S>L!a\u001a3\u0003\t\u0019KG.\u001a\u0005\u0006Sz\u0003\raL\u0001\fgR\f'\u000f^(gMN,G\u000fC\u00036=\u0002\u0007q\u0007C\u0003m=\u0002\u0007q'\u0001\u0007nCbLe\u000eZ3y'&TX\rC\u0003>=\u0002\u0007a\bC\u0003p\u0001\u0011\u0005a&\u0001\u0003tSj,\u0007\"B9\u0001\t\u0003\u0011\u0018AB1qa\u0016tG\rF\u0002PgVDQ\u0001\u001e9A\u0002=\naa\u001c4gg\u0016$\b\"\u0002<q\u0001\u00049\u0018\u0001C7fgN\fw-Z:\u0011\u0005a\\X\"A=\u000b\u0005i$\u0011aB7fgN\fw-Z\u0005\u0003yf\u0014ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$\bF\u00019\u007f!\t\tr0C\u0002\u0002\u0002I\u0011QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007\u0002CA\u0003\u0001\u0011\u0005!!a\u0002\u0002\u001fQ\u0014\u0018M\\:mCR,wJ\u001a4tKR$b!!\u0003\u0002\u0010\u0005E\u0001cA\u0010\u0002\f%\u0019\u0011Q\u0002\u0002\u0003\u001d=3gm]3u!>\u001c\u0018\u000e^5p]\"1A/a\u0001A\u0002=B\u0011\"a\u0005\u0002\u0004A\u0005\t\u0019A\u001c\u0002)M$\u0018M\u001d;j]\u001e4\u0015\u000e\\3Q_NLG/[8oQ\u0011\t\u0019!a\u0006\u0011\u0007E\tI\"C\u0002\u0002\u001cI\u0011!\u0002\u001e5sK\u0006$7/\u00194f\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\tAA]3bIRA\u00111EA\u0015\u0003W\t)\u0004E\u0002y\u0003KI1!a\nz\u0005)iUm]:bO\u0016\u001cV\r\u001e\u0005\u0007S\u0006u\u0001\u0019A\u0018\t\u0011\u00055\u0012Q\u0004a\u0001\u0003_\t\u0011\"\\1y\u001f\u001a47/\u001a;\u0011\t]\t\tdL\u0005\u0004\u0003gA\"AB(qi&|g\u000eC\u0004\u00028\u0005u\u0001\u0019A\u001c\u0002\u000f5\f\u0007pU5{K\"\"\u0011QDA\f\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007f\tqA]3d_Z,'\u000fF\u00028\u0003\u0003Bq!a\u0011\u0002<\u0001\u0007q'\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3)\u0007\u0005mb\u0010C\u0004\u0002J\u0001!\t%a\u0013\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0014\u0011\u0007%\ty%C\u0002\u0002R)\u0011aa\u0015;sS:<\u0007bBA+\u0001\u0011\u0005\u0011qK\u0001\u000biJ,hnY1uKR{GcA\u001c\u0002Z!1A/a\u0015A\u0002=B3!a\u0015\u007f\u0011\u001d\ty\u0006\u0001C\u0001\u0003C\n!B\\3yi>3gm]3u)\u0005y\u0003\u0006BA/\u0003/Aq!a\u001a\u0001\t\u0003\tI'A\u0003gYV\u001c\b\u000eF\u0001PQ\u0011\t)'a\u0006\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r\u0005\u00112\r[1oO\u00164\u0015\u000e\\3Tk\u001a4\u0017\u000e_3t)\u0015y\u00151OAB\u0011!\t)(!\u001cA\u0002\u0005]\u0014!C8mIN+hMZ5y!\u0011\tI(a \u000f\u0007]\tY(C\u0002\u0002~a\ta\u0001\u0015:fI\u00164\u0017\u0002BA)\u0003\u0003S1!! \u0019\u0011!\t))!\u001cA\u0002\u0005]\u0014!\u00038foN+hMZ5y\u0011\u001d\tI\t\u0001C\u0001\u0003S\nQa\u00197pg\u0016Dq!!$\u0001\t\u0003\tI'\u0001\u0004eK2,G/\u001a\u0005\u0007\u0003#\u0003A\u0011\u0001\u0018\u0002\u00191\f7\u000f^'pI&4\u0017.\u001a3\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\u0006\u0001B.Y:u\u001b>$\u0017NZ5fI~#S-\u001d\u000b\u0005\u00033\u000by\nE\u0002\u0018\u00037K1!!(\u0019\u0005\u001d\u0011un\u001c7fC:Dq!!)\u0002\u0014\u0002\u0007q&\u0001\u0002ng\"I\u0011Q\u0015\u0001\u0012\u0002\u0013\u0005\u0011qU\u0001\u001aiJ\fgn\u001d7bi\u0016|eMZ:fi\u0012\"WMZ1vYR$#'\u0006\u0002\u0002**\u001aq'a+,\u0005\u00055\u0006\u0003BAX\u0003sk!!!-\u000b\t\u0005M\u0016QW\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a.\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003w\u000b\tLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D#\u0001\u0001@")
public class LogSegment
implements Logging {
    private final FileMessageSet log;
    private final OffsetIndex index;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogSegment logSegment = this;
        synchronized (logSegment) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileMessageSet log() {
        return this.log;
    }

    public OffsetIndex index() {
        return this.index;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long created() {
        return this.created;
    }

    public void created_$eq(long l) {
        this.created = l;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int n) {
        this.bytesSinceLastIndexEntry = n;
    }

    public long size() {
        return this.log().sizeInBytes();
    }

    public void append(long offset$1, ByteBufferMessageSet messages$1) {
        if (messages$1.sizeInBytes() > 0) {
            this.trace((Function0<String>)new Serializable(this, offset$1, messages$1){
                public static final long serialVersionUID;
                private final LogSegment $outer;
                private final long offset$1;
                private final ByteBufferMessageSet messages$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Inserting %d bytes at offset %d at position %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.offset$1), BoxesRunTime.boxToInteger((int)this.$outer.log().sizeInBytes())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.offset$1 = l;
                    this.messages$1 = byteBufferMessageSet;
                }
            });
            if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
                this.index().append(offset$1, this.log().sizeInBytes());
                this.bytesSinceLastIndexEntry_$eq(0);
            }
            this.log().append(messages$1);
            this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + messages$1.sizeInBytes());
        }
    }

    public OffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.index().lookup(offset);
        return this.log().searchFor(offset, package$.MODULE$.max(mapping.position(), startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public MessageSet read(long startOffset, Option<Object> maxOffset, int maxSize) {
        Option<Object> option;
        block9: {
            int n;
            OffsetPosition startPosition;
            block8: {
                int logSize;
                block7: {
                    if (maxSize < 0) {
                        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Invalid max size for log read (%d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSize)})));
                    }
                    if (maxSize == 0) {
                        return MessageSet$.MODULE$.Empty();
                    }
                    logSize = this.log().sizeInBytes();
                    startPosition = this.translateOffset(startOffset, this.translateOffset$default$2());
                    if (startPosition == null) {
                        return null;
                    }
                    option = maxOffset;
                    None$ none$ = None$.MODULE$;
                    Option<Object> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                    n = maxSize;
                    break block8;
                }
                if (!(option instanceof Some)) break block9;
                Some some = (Some)option;
                long l = BoxesRunTime.unboxToLong((Object)some.x());
                long offset = l;
                if (offset < startOffset) {
                    throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Attempt to read with a maximum offset (%d) less than the start offset (%d).").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToLong((long)startOffset)})));
                }
                OffsetPosition mapping = this.translateOffset(offset, startPosition.position());
                int endPosition = mapping == null ? logSize : mapping.position();
                n = package$.MODULE$.min(endPosition - startPosition.position(), maxSize);
            }
            int length = n;
            return this.log().read(startPosition.position(), length);
        }
        throw new MatchError(option);
    }

    public int recover(int maxMessageSize) {
        this.index().truncate();
        this.index().resize(this.index().maxIndexSize());
        int validBytes = 0;
        int lastIndexEntry = 0;
        Iterator<MessageAndOffset> iter = this.log().iterator(maxMessageSize);
        try {
            while (iter.hasNext()) {
                MessageAndOffset entry2 = (MessageAndOffset)iter.next();
                entry2.message().ensureValid();
                if (validBytes - lastIndexEntry > this.indexIntervalBytes()) {
                    CompressionCodec compressionCodec = entry2.message().compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    long startOffset = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? entry2.offset() : ((MessageAndOffset)ByteBufferMessageSet$.MODULE$.decompress(entry2.message()).head()).offset();
                    this.index().append(startOffset, validBytes);
                    lastIndexEntry = validBytes;
                }
                validBytes += MessageSet$.MODULE$.entrySize(entry2.message());
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.logger().warn((Object)Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes), invalidMessageException.getMessage()})));
        }
        int truncated = this.log().sizeInBytes() - validBytes;
        this.log().truncateTo(validBytes);
        this.index().trimToValidSize();
        return truncated;
    }

    public String toString() {
        return new StringBuilder().append((Object)"LogSegment(baseOffset=").append((Object)BoxesRunTime.boxToLong((long)this.baseOffset())).append((Object)", size=").append((Object)BoxesRunTime.boxToLong((long)this.size())).append((Object)")").toString();
    }

    public int truncateTo(long offset) {
        OffsetPosition mapping = this.translateOffset(offset, this.translateOffset$default$2());
        if (mapping == null) {
            return 0;
        }
        this.index().truncateTo(offset);
        this.index().resize(this.index().maxIndexSize());
        int bytesTruncated = this.log().truncateTo(mapping.position());
        if (this.log().sizeInBytes() == 0) {
            this.created_$eq(this.time.milliseconds());
        }
        this.bytesSinceLastIndexEntry_$eq(0);
        return bytesTruncated;
    }

    public long nextOffset() {
        Option option;
        block5: {
            long l;
            block3: {
                block4: {
                    MessageSet ms;
                    block2: {
                        ms = this.read(this.index().lastOffset(), (Option<Object>)None$.MODULE$, this.log().sizeInBytes());
                        if (ms != null) break block2;
                        l = this.baseOffset();
                        break block3;
                    }
                    option = ms.lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                    l = this.baseOffset();
                    break block3;
                }
                if (!(option instanceof Some)) break block5;
                l = ((MessageAndOffset)((Some)option).x()).nextOffset();
            }
            return l;
        }
        throw new MatchError((Object)option);
    }

    public void flush() {
        LogFlushStats$.MODULE$.logFlushTimer().time(new Serializable(this){
            public static final long serialVersionUID;
            private final LogSegment $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().flush();
                this.$outer.index().flush();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        boolean logRenamed = this.log().renameTo(new File(Utils$.MODULE$.replaceSuffix(this.log().file().getPath(), oldSuffix, newSuffix)));
        if (logRenamed) {
            boolean indexRenamed = this.index().renameTo(new File(Utils$.MODULE$.replaceSuffix(this.index().file().getPath(), oldSuffix, newSuffix)));
            if (indexRenamed) {
                return;
            }
            throw new KafkaStorageException(Predef$.MODULE$.augmentString("Failed to change the index file suffix from %s to %s for log segment %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
        }
        throw new KafkaStorageException(Predef$.MODULE$.augmentString("Failed to change the log file suffix from %s to %s for log segment %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, newSuffix, BoxesRunTime.boxToLong((long)this.baseOffset())})));
    }

    public void close() {
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;
            private final LogSegment $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.index().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Utils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;
            private final LogSegment $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.log().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void delete() {
        boolean deletedLog = this.log().delete();
        boolean deletedIndex = this.index().delete();
        if (!deletedLog && this.log().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of log ").append((Object)this.log().file().getName()).append((Object)" failed.").toString());
        }
        if (!deletedIndex && this.index().file().exists()) {
            throw new KafkaStorageException(new StringBuilder().append((Object)"Delete of index ").append((Object)this.index().file().getName()).append((Object)" failed.").toString());
        }
    }

    public long lastModified() {
        return this.log().file().lastModified();
    }

    public boolean lastModified_$eq(long ms) {
        this.log().file().setLastModified(ms);
        return this.index().file().setLastModified(ms);
    }

    public LogSegment(FileMessageSet log, OffsetIndex index, long baseOffset, int indexIntervalBytes, Time time) {
        this.log = log;
        this.index = index;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.time = time;
        Logging$class.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
    }

    public LogSegment(File dir, long startOffset, int indexIntervalBytes, int maxIndexSize, Time time) {
        this(new FileMessageSet(Log$.MODULE$.logFilename(dir, startOffset)), new OffsetIndex(Log$.MODULE$.indexFilename(dir, startOffset), startOffset, maxIndexSize), startOffset, indexIntervalBytes, time);
    }
}

