/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001\u0002\u0005\f\u001d!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0015\u001b\u0005\u0011\"BA\n\u0005\u0003\u0015)H/\u001b7t\u0013\t)\"CA\u0004M_\u001e<\u0017N\\4\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011aB7fiJL7m]\u0005\u00037a\u0011\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\naaY8oM&<W#A\u0013\u0011\u0005\u0019:S\"\u0001\u0002\n\u0005!\u0012!!D\"mK\u0006tWM]\"p]\u001aLw\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003&\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!L\u0001\bY><G)\u001b:t+\u0005q\u0003cA\u000f0c%\u0011\u0001G\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003eUj\u0011a\r\u0006\u0003i1\t!![8\n\u0005Y\u001a$\u0001\u0002$jY\u0016D\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006IAL\u0001\tY><G)\u001b:tA!A!\b\u0001BC\u0002\u0013\u00051(\u0001\u0003m_\u001e\u001cX#\u0001\u001f\u0011\tEit(R\u0005\u0003}I\u0011A\u0001U8pYB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tB\u0001\u0007G>lWn\u001c8\n\u0005\u0011\u000b%!\u0005+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]B\u0011aER\u0005\u0003\u000f\n\u00111\u0001T8h\u0011!I\u0005A!A!\u0002\u0013a\u0014!\u00027pON\u0004\u0003\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\tQLW.\u001a\t\u0003#5K!A\u0014\n\u0003\tQKW.\u001a\u0005\u0006!\u0002!\t!U\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bI\u001bF+\u0016,\u0011\u0005\u0019\u0002\u0001\"B\u0012P\u0001\u0004)\u0003\"\u0002\u0017P\u0001\u0004q\u0003\"\u0002\u001eP\u0001\u0004a\u0004bB&P!\u0003\u0005\r\u0001\u0014\u0005\t1\u0002\u0011\r\u0011\"\u0001\u00033\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014X#\u0001.\u0011\u0005\u0019Z\u0016B\u0001/\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\u0007=\u0002\u0001\u000b\u0011\u0002.\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002Bq\u0001\u0019\u0001C\u0002\u0013%\u0011-A\u0005uQJ|G\u000f\u001e7feV\t!\r\u0005\u0002\u0012G&\u0011AM\u0005\u0002\n)\"\u0014x\u000e\u001e;mKJDaA\u001a\u0001!\u0002\u0013\u0011\u0017A\u0003;ie>$H\u000f\\3sA!9\u0001\u000e\u0001b\u0001\n\u0013I\u0017\u0001C2mK\u0006tWM]:\u0016\u0003)\u00042a\u001b9s\u001b\u0005a'BA7o\u0003%IW.\\;uC\ndWM\u0003\u0002p=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ed'AC%oI\u0016DX\rZ*fcB\u00111\u000f^\u0007\u0002\u0001\u0019!Q\u000f\u0001\u0003w\u00055\u0019E.Z1oKJ$\u0006N]3bIN\u0019Ao\u001e\u000f\u0011\u0005EA\u0018BA=\u0013\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u0011m$(\u0011!Q\u0001\nq\f\u0001\u0002\u001e5sK\u0006$\u0017\n\u001a\t\u0003;uL!A \u0010\u0003\u0007%sG\u000f\u0003\u0004Qi\u0012\u0005\u0011\u0011\u0001\u000b\u0004e\u0006\r\u0001\"B>\u0000\u0001\u0004a\b\"CA\u0004i\n\u0007I\u0011IA\u0005\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003\u0017\u00012!CA\u0007\u0013\r\tyA\u0003\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005MA\u000f)A\u0005\u0003\u0017\t1\u0002\\8hO\u0016\u0014h*Y7fA!I\u0011q\u0003;C\u0002\u0013\u0005\u0011\u0011D\u0001\bG2,\u0017M\\3s+\t\tY\u0002E\u0002'\u0003;I1!a\b\u0003\u0005\u001d\u0019E.Z1oKJD\u0001\"a\tuA\u0003%\u00111D\u0001\tG2,\u0017M\\3sA!I\u0011q\u0005;A\u0002\u0013\u0005\u0011\u0011F\u0001\nY\u0006\u001cHo\u0015;biN,\"!a\u000b\u0011\u0007\u0019\ni#C\u0002\u00020\t\u0011Ab\u00117fC:,'o\u0015;biND\u0011\"a\ru\u0001\u0004%\t!!\u000e\u0002\u001b1\f7\u000f^*uCR\u001cx\fJ3r)\u0011\t9$!\u0010\u0011\u0007u\tI$C\u0002\u0002<y\u0011A!\u00168ji\"Q\u0011qHA\u0019\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002DQ\u0004\u000b\u0015BA\u0016\u0003)a\u0017m\u001d;Ti\u0006$8\u000f\t\u0015\u0005\u0003\u0003\n9\u0005E\u0002\u001e\u0003\u0013J1!a\u0013\u001f\u0005!1x\u000e\\1uS2,\u0007\"CA(i\n\u0007I\u0011BA)\u0003A\u0011\u0017mY6PM\u001a<\u0016-\u001b;MCR\u001c\u0007.\u0006\u0002\u0002TA!\u0011QKA0\u001b\t\t9F\u0003\u0003\u0002Z\u0005m\u0013AC2p]\u000e,(O]3oi*\u0019\u0011Q\f\u0007\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003C\n9F\u0001\bD_VtG\u000fR8x]2\u000bGo\u00195\t\u0011\u0005\u0015D\u000f)A\u0005\u0003'\n\u0011CY1dW>3gmV1ji2\u000bGo\u00195!\u0011\u001d\tI\u0007\u001eC\u0005\u0003W\n\u0011b\u00195fG.$uN\\3\u0015\t\u0005]\u0012Q\u000e\u0005\b\u0003_\n9\u00071\u0001@\u0003E!x\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003g\"H\u0011IA;\u0003\u0019!wnV8sWR\u0011\u0011q\u0007\u0005\b\u0003s\"H\u0011IA;\u0003!\u0019\b.\u001e;e_^t\u0007bBA?i\u0012%\u0011QO\u0001\rG2,\u0017M\\(s'2,W\r\u001d\u0005\b\u0003\u0003#H\u0011AAB\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\u0005]\u0012QQAE\u00033\u000b\u0019+a*\t\u000f\u0005\u001d\u0015q\u0010a\u0001y\u0006\u0011\u0011\u000e\u001a\u0005\t\u0003\u0017\u000by\b1\u0001\u0002\u000e\u0006!a.Y7f!\u0011\ty)!&\u000f\u0007u\t\t*C\u0002\u0002\u0014z\ta\u0001\u0015:fI\u00164\u0017\u0002BA\b\u0003/S1!a%\u001f\u0011!\tY*a A\u0002\u0005u\u0015\u0001\u00024s_6\u00042!HAP\u0013\r\t\tK\b\u0002\u0005\u0019>tw\r\u0003\u0005\u0002&\u0006}\u0004\u0019AAO\u0003\t!x\u000e\u0003\u0005\u0002*\u0006}\u0004\u0019AA\u0016\u0003\u0015\u0019H/\u0019;t\u0011\u001d\ti\u000b\u0001Q\u0001\n)\f\u0011b\u00197fC:,'o\u001d\u0011\t\u000f\u0005E\u0006\u0001\"\u0001\u0002v\u000591\u000f^1siV\u0004\bbBA=\u0001\u0011\u0005\u0011Q\u000f\u0005\b\u0003o\u0003A\u0011AA]\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011qGA^\u0011\u001d\ty'!.A\u0002}Bq!a0\u0001\t\u0003\t\t-A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$B!a\u000e\u0002D\"9\u0011QYA_\u0001\u0004\t\u0014a\u00023bi\u0006$\u0015N\u001d\u0005\b\u0003\u0013\u0004A\u0011AAf\u0003U\t'm\u001c:u\u0003:$\u0007+Y;tK\u000ecW-\u00198j]\u001e$B!a\u000e\u0002N\"9\u0011qNAd\u0001\u0004y\u0004bBAi\u0001\u0011\u0005\u00111[\u0001\u000fe\u0016\u001cX/\\3DY\u0016\fg.\u001b8h)\u0011\t9$!6\t\u000f\u0005=\u0014q\u001aa\u0001\u007f!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0017\u0001D1xC&$8\t\\3b]\u0016$GCCA\u001c\u0003;\f\t/!:\u0002j\"A\u0011q\\Al\u0001\u0004\ti)A\u0003u_BL7\rC\u0004\u0002d\u0006]\u0007\u0019\u0001?\u0002\tA\f'\u000f\u001e\u0005\t\u0003O\f9\u000e1\u0001\u0002\u001e\u00061qN\u001a4tKRD!\"a;\u0002XB\u0005\t\u0019AAO\u0003\u001d!\u0018.\\3pkRD\u0011\"a<\u0001#\u0003%\t!!=\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIQ*\"!a=+\t\u0005u\u0015Q_\u0016\u0003\u0003o\u0004B!!?\u0003\u00045\u0011\u00111 \u0006\u0005\u0003{\fy0A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u0001\u0010\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0006\u0005m(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eI!\u0011\u0002\u0002\u0002\u0002#\u0015!1B\u0001\u000b\u0019><7\t\\3b]\u0016\u0014\bc\u0001\u0014\u0003\u000e\u0019A\u0011AAA\u0001\u0012\u000b\u0011ya\u0005\u0003\u0003\u000e!a\u0002b\u0002)\u0003\u000e\u0011\u0005!1\u0003\u000b\u0003\u0005\u0017A!Ba\u0006\u0003\u000eE\u0005I\u0011\u0001B\r\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIQ*\"Aa\u0007+\u00071\u000b)\u0010")
public class LogCleaner
implements KafkaMetricsGroup {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicAndPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Time init$default$4() {
        return LogCleaner$.MODULE$.init$default$4();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public Map newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public Map removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicAndPartition, Log> logs() {
        return this.logs;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public final Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Starting the log cleaner";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(CleanerThread cleanerThread) {
                cleanerThread.start();
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(CleanerThread cleanerThread) {
                cleanerThread.shutdown();
            }
        });
    }

    public void abortCleaning(TopicAndPartition topicAndPartition) {
        this.cleanerManager().abortCleaning(topicAndPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicAndPartition, Object>>)None$.MODULE$);
    }

    public void abortAndPauseCleaning(TopicAndPartition topicAndPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicAndPartition);
    }

    public void resumeCleaning(TopicAndPartition topicAndPartition) {
        this.cleanerManager().resumeCleaning(topicAndPartition);
    }

    public void awaitCleaned(String topic, int part, long offset, long timeout) {
        while (!this.cleanerManager().allCleanerCheckpoints().contains((Object)new TopicAndPartition(topic, part))) {
            Thread.sleep(10L);
        }
        return;
    }

    public long awaitCleaned$default$4() {
        return 30000L;
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicAndPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (IndexedSeq)Predef$.MODULE$.intWrapper(0).until(config.numThreads()).map((Function1)new $anonfun$1(this), IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final CleanerStats apply(CleanerThread cleanerThread) {
                        return cleanerThread.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final double apply(CleanerStats cleanerStats) {
                        return (double)100 * cleanerStats.bufferUtilization();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final LogCleaner $outer;

            public int value() {
                IndexedSeq stats = (IndexedSeq)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final CleanerStats apply(CleanerThread cleanerThread) {
                        return cleanerThread.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final long apply(CleanerStats cleanerStats) {
                        return cleanerStats.bytesWritten();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final long apply(CleanerStats cleanerStats) {
                        return cleanerStats.bytesRead();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final CleanerStats apply(CleanerThread cleanerThread) {
                        return cleanerThread.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final double apply(CleanerStats cleanerStats) {
                        return cleanerStats.elapsedSecs();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread
    implements ScalaObject {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private final CountDownLatch backOffWaitLatch;
        public final LogCleaner $outer;

        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats cleanerStats) {
            this.lastStats = cleanerStats;
        }

        private CountDownLatch backOffWaitLatch() {
            return this.backOffWaitLatch;
        }

        public final void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicAndPartition topicAndPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicAndPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        public void doWork() {
            this.cleanOrSleep();
        }

        public void shutdown() {
            this.initiateShutdown();
            this.backOffWaitLatch().countDown();
            this.awaitShutdown();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            LogToClean logToClean;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestLog();
            None$ none$ = None$.MODULE$;
            Option<LogToClean> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                this.backOffWaitLatch().await(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs(), TimeUnit.MILLISECONDS);
                return;
            }
            if (!(option instanceof Some)) throw new MatchError(option);
            Some some = (Some)option;
            LogToClean cleanable = logToClean = (LogToClean)some.x();
            long endOffset = cleanable.firstDirtyOffset();
            try {
                endOffset = this.cleaner().clean(cleanable);
                this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, this.cleaner().stats());
                return;
            }
            catch (LogCleaningAbortedException logCleaningAbortedException) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
            return;
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            this.cleaner().statsUnderlying().swap();
            String message$1 = new StringBuilder().append((Object)Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append((Object)Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new Serializable(this, message$1){
                public static final long serialVersionUID;
                private final String message$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = string;
                }
            });
        }

        public LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return this.$outer;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(LogCleaner $outer, int threadId) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append((Object)BoxesRunTime.boxToInteger((int)threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if ($outer.config().dedupeBufferSize() / (long)$outer.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                });
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min($outer.config().dedupeBufferSize() / (long)$outer.config().numThreads(), Integer.MAX_VALUE), $outer.config().hashAlgorithm()), $outer.config().ioBufferSize() / $outer.config().numThreads() / 2, $outer.config().maxMessageSize(), $outer.config().dedupeBufferLoadFactor(), $outer.kafka$log$LogCleaner$$throttler(), $outer.kafka$log$LogCleaner$$time, (Function1<TopicAndPartition, BoxedUnit>)new CleanerThread$$anonfun$6(this));
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.init$default$1());
            this.backOffWaitLatch = new CountDownLatch(1);
        }
    }
}

