/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponse$;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.TopicMetadataResponse$;
import kafka.metrics.KafkaTimer;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.network.BoundedByteBufferSend;
import kafka.network.Receive;
import kafka.producer.ProducerRequestStats;
import kafka.producer.ProducerRequestStatsRegistry$;
import kafka.producer.SyncProducer$;
import kafka.producer.SyncProducerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dt!B\u0001\u0003\u0011\u000b9\u0011\u0001D*z]\u000e\u0004&o\u001c3vG\u0016\u0014(BA\u0002\u0005\u0003!\u0001(o\u001c3vG\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0003\u0017\ta1+\u001f8d!J|G-^2feN\u0019\u0011\u0002\u0004\u000b\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u00111bU2bY\u0006|%M[3di\")1$\u0003C\u00019\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\b=%\u0011\r\u0011\"\u0001 \u0003)\u0011V-];fgR\\U-_\u000b\u0002AA\u0011Q#I\u0005\u0003EY\u0011Qa\u00155peRDa\u0001J\u0005!\u0002\u0013\u0001\u0013a\u0003*fcV,7\u000f^&fs\u0002BqAJ\u0005C\u0002\u0013\u0005q%A\bsC:$w.\\$f]\u0016\u0014\u0018\r^8s+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u0011\u0003\u0011)H/\u001b7\n\u00055R#A\u0002*b]\u0012|W\u000e\u0003\u00040\u0013\u0001\u0006I\u0001K\u0001\u0011e\u0006tGm\\7HK:,'/\u0019;pe\u00022AA\u0003\u0002\u0001cM!\u0001\u0007\u0004\u001a\u0015!\t\u0019d'D\u00015\u0015\t)D!A\u0003vi&d7/\u0003\u00028i\t9Aj\\4hS:<\u0007\u0002C\u001d1\u0005\u000b\u0007I\u0011\u0001\u001e\u0002\r\r|gNZ5h+\u0005Y\u0004C\u0001\u0005=\u0013\ti$A\u0001\nTs:\u001c\u0007K]8ek\u000e,'oQ8oM&<\u0007\u0002C 1\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u000f\r|gNZ5hA!)1\u0004\rC\u0001\u0003R\u0011!i\u0011\t\u0003\u0011ABQ!\u000f!A\u0002mBq!\u0012\u0019C\u0002\u0013%a)\u0001\u0003m_\u000e\\W#\u0001\u0007\t\r!\u0003\u0004\u0015!\u0003\r\u0003\u0015awnY6!\u0011\u001dQ\u0005\u00071A\u0005\n-\u000b\u0001b\u001d5vi\u0012|wO\\\u000b\u0002\u0019B\u0011Q#T\u0005\u0003\u001dZ\u0011qAQ8pY\u0016\fg\u000eC\u0004Qa\u0001\u0007I\u0011B)\u0002\u0019MDW\u000f\u001e3po:|F%Z9\u0015\u0005I+\u0006CA\u000bT\u0013\t!fC\u0001\u0003V]&$\bb\u0002,P\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0004B\u0002-1A\u0003&A*A\u0005tQV$Hm\\<oA!\u0012qK\u0017\t\u0003+mK!\u0001\u0018\f\u0003\u0011Y|G.\u0019;jY\u0016DqA\u0018\u0019C\u0002\u0013%q,A\bcY>\u001c7.\u001b8h\u0007\"\fgN\\3m+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2\u0005\u0003\u001dqW\r^<pe.L!!\u001a2\u0003\u001f\tcwnY6j]\u001e\u001c\u0005.\u00198oK2Daa\u001a\u0019!\u0002\u0013\u0001\u0017\u0001\u00052m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7!\u0011\u001dI\u0007G1A\u0005\u0002)\fA\u0003\u001d:pIV\u001cWM\u001d*fcV,7\u000f^*uCR\u001cX#A6\u0011\u0005!a\u0017BA7\u0003\u0005Q\u0001&o\u001c3vG\u0016\u0014(+Z9vKN$8\u000b^1ug\"1q\u000e\rQ\u0001\n-\fQ\u0003\u001d:pIV\u001cWM\u001d*fcV,7\u000f^*uCR\u001c\b\u0005C\u0003ra\u0011%!/A\u0007wKJLg-\u001f*fcV,7\u000f\u001e\u000b\u0003%NDQ\u0001\u001e9A\u0002U\fqA]3rk\u0016\u001cH\u000f\u0005\u0002ws6\tqO\u0003\u0002y\t\u0005\u0019\u0011\r]5\n\u0005i<(!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tK\")A\u0010\rC\u0005{\u00061Am\\*f]\u0012$RA`A\u0002\u0003\u000b\u0001\"!Y@\n\u0007\u0005\u0005!MA\u0004SK\u000e,\u0017N^3\t\u000bQ\\\b\u0019A;\t\u0011\u0005\u001d1\u0010%AA\u00021\u000bAB]3bIJ+7\u000f]8og\u0016Dq!a\u00031\t\u0003\ti!\u0001\u0003tK:$G\u0003BA\b\u0003+\u00012A^A\t\u0013\r\t\u0019b\u001e\u0002\u0011!J|G-^2feJ+7\u000f]8og\u0016D\u0001\"a\u0006\u0002\n\u0001\u0007\u0011\u0011D\u0001\u0010aJ|G-^2feJ+\u0017/^3tiB\u0019a/a\u0007\n\u0007\u0005uqOA\bQe>$WoY3s%\u0016\fX/Z:u\u0011\u001d\tY\u0001\rC\u0001\u0003C!B!a\t\u0002*A\u0019a/!\n\n\u0007\u0005\u001drOA\u000bU_BL7-T3uC\u0012\fG/\u0019*fgB|gn]3\t\u000fQ\fy\u00021\u0001\u0002,A\u0019a/!\f\n\u0007\u0005=rO\u0001\u000bU_BL7-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u0005\b\u0003g\u0001D\u0011AA\u001b\u0003\u0015\u0019Gn\\:f)\u0005\u0011\u0006bBA\u001da\u0011%\u0011QG\u0001\u000bI&\u001c8m\u001c8oK\u000e$\bbBA\u001fa\u0011%\u0011qH\u0001\bG>tg.Z2u)\u0005\u0001\u0007bBA\"a\u0011%\u0011QG\u0001\u0014O\u0016$xJ]'bW\u0016\u001cuN\u001c8fGRLwN\u001c\u0005\n\u0003\u000f\u0002\u0014\u0013!C\u0005\u0003\u0013\n\u0001\u0003Z8TK:$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-#f\u0001'\u0002N-\u0012\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003%)hn\u00195fG.,GMC\u0002\u0002ZY\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti&a\u0015\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rK\u00021\u0003C\u00022aMA2\u0013\r\t)\u0007\u000e\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0007")
public class SyncProducer
implements Logging {
    private final SyncProducerConfig config;
    private final Object lock;
    private volatile boolean shutdown;
    private final BlockingChannel blockingChannel;
    private final ProducerRequestStats producerRequestStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final Random randomGenerator() {
        return SyncProducer$.MODULE$.randomGenerator();
    }

    public static final short RequestKey() {
        return SyncProducer$.MODULE$.RequestKey();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SyncProducer syncProducer = this;
        synchronized (syncProducer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public SyncProducerConfig config() {
        return this.config;
    }

    private Object lock() {
        return this.lock;
    }

    private boolean shutdown() {
        return this.shutdown;
    }

    private void shutdown_$eq(boolean bl) {
        this.shutdown = bl;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    public ProducerRequestStats producerRequestStats() {
        return this.producerRequestStats;
    }

    private void verifyRequest(RequestOrResponse request) {
        if (this.logger().isDebugEnabled()) {
            ByteBuffer buffer$1 = new BoundedByteBufferSend(request).buffer();
            this.trace((Function0<String>)new Serializable(this, buffer$1){
                public static final long serialVersionUID;
                private final ByteBuffer buffer$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"verifying sendbuffer of size ").append((Object)BoxesRunTime.boxToInteger((int)this.buffer$1.limit())).toString();
                }
                {
                    this.buffer$1 = byteBuffer;
                }
            });
            short requestTypeId = buffer$1.getShort();
            if (requestTypeId == RequestKeys$.MODULE$.ProduceKey()) {
                ProducerRequest request$1 = ProducerRequest$.MODULE$.readFrom(buffer$1);
                this.trace((Function0<String>)new Serializable(this, request$1){
                    public static final long serialVersionUID;
                    private final ProducerRequest request$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return this.request$1.toString();
                    }
                    {
                        this.request$1 = producerRequest;
                    }
                });
            }
        }
    }

    public final Receive kafka$producer$SyncProducer$$doSend(RequestOrResponse request$2, boolean readResponse$1) {
        Object object = this.lock();
        synchronized (object) {
            this.verifyRequest(request$2);
            this.getOrMakeConnection();
            ObjectRef response$1 = new ObjectRef(null);
            this.liftedTree1$1(request$2, readResponse$1, response$1);
            Receive receive = (Receive)response$1.elem;
            return receive;
        }
    }

    private boolean doSend$default$2() {
        return true;
    }

    public ProducerResponse send(ProducerRequest producerRequest$1) {
        int requestSize = producerRequest$1.sizeInBytes();
        this.producerRequestStats().getProducerRequestStats(this.config().host(), this.config().port()).requestSizeHist().update(requestSize);
        this.producerRequestStats().getProducerRequestAllBrokersStats().requestSizeHist().update(requestSize);
        ObjectRef response$2 = new ObjectRef(null);
        KafkaTimer specificTimer$1 = this.producerRequestStats().getProducerRequestStats(this.config().host(), this.config().port()).requestTimer();
        KafkaTimer aggregateTimer = this.producerRequestStats().getProducerRequestAllBrokersStats().requestTimer();
        aggregateTimer.time(new Serializable(this, producerRequest$1, response$2, specificTimer$1){
            public static final long serialVersionUID;
            private final SyncProducer $outer;
            public final ProducerRequest producerRequest$1;
            public final ObjectRef response$2;
            private final KafkaTimer specificTimer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.specificTimer$1.time(new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$send$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.response$2.elem = this.$outer.kafka$producer$SyncProducer$$anonfun$$$outer().kafka$producer$SyncProducer$$doSend(this.$outer.producerRequest$1, this.$outer.producerRequest$1.requiredAcks() != 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public SyncProducer kafka$producer$SyncProducer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producerRequest$1 = producerRequest;
                this.response$2 = objectRef;
                this.specificTimer$1 = kafkaTimer;
            }
        });
        return producerRequest$1.requiredAcks() != 0 ? ProducerResponse$.MODULE$.readFrom(((Receive)response$2.elem).buffer()) : null;
    }

    public TopicMetadataResponse send(TopicMetadataRequest request) {
        Receive response = this.kafka$producer$SyncProducer$$doSend(request, this.doSend$default$2());
        return TopicMetadataResponse$.MODULE$.readFrom(response.buffer());
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.shutdown_$eq(true);
            return;
        }
    }

    private void disconnect() {
        try {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final SyncProducer $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Disconnecting from ").append((Object)Utils.formatAddress((String)this.$outer.config().host(), (Integer)Predef$.MODULE$.int2Integer(this.$outer.config().port()))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.blockingChannel().disconnect();
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Error on disconnect: ";
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID;
                private final Exception e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = exception;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BlockingChannel connect() {
        if (this.blockingChannel().isConnected() || this.shutdown()) return this.blockingChannel();
        try {
            this.blockingChannel().connect();
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final SyncProducer $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Connected to ").append((Object)Utils.formatAddress((String)this.$outer.config().host(), (Integer)Predef$.MODULE$.int2Integer(this.$outer.config().port()))).append((Object)" for producing").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Exception exception) {
            this.disconnect();
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final SyncProducer $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Producer connection to ").append((Object)Utils.formatAddress((String)this.$outer.config().host(), (Integer)Predef$.MODULE$.int2Integer(this.$outer.config().port()))).append((Object)" unsuccessful").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID;
                private final Exception e$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Exception apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = exception;
                }
            });
            throw exception;
        }
        return this.blockingChannel();
    }

    private void getOrMakeConnection() {
        if (!this.blockingChannel().isConnected()) {
            this.connect();
        }
    }

    private final void liftedTree1$1(RequestOrResponse requestOrResponse, boolean bl, ObjectRef objectRef) {
        try {
            this.blockingChannel().send(requestOrResponse);
            if (bl) {
                objectRef.elem = this.blockingChannel().receive();
            } else {
                this.trace((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Skipping reading response";
                    }
                });
            }
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public SyncProducer(SyncProducerConfig config) {
        this.config = config;
        Logging$class.$init$(this);
        this.lock = new Object();
        this.shutdown = false;
        this.blockingChannel = new BlockingChannel(config.host(), config.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), config.sendBufferBytes(), config.requestTimeoutMs());
        this.producerRequestStats = ProducerRequestStatsRegistry$.MODULE$.getProducerRequestStats(config.clientId());
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final SyncProducer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Instantiating Scala Sync Producer with properties: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.config().props()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

