/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$;
import kafka.server.KafkaApis;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u000f\t\u00192*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0003\u0001\u0011A\u0019\u0012\u0004\u0005\u0002\n\u001d5\t!B\u0003\u0002\f\u0019\u0005!A.\u00198h\u0015\u0005i\u0011\u0001\u00026bm\u0006L!a\u0004\u0006\u0003\r=\u0013'.Z2u!\tI\u0011#\u0003\u0002\u0013\u0015\tA!+\u001e8oC\ndW\r\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\t\u0005)Q\u000f^5mg&\u0011\u0001$\u0006\u0002\b\u0019><w-\u001b8h!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\u0001\u0002!\u0011!Q\u0001\n\u0005\n!!\u001b3\u0011\u0005i\u0011\u0013BA\u0012\u001c\u0005\rIe\u000e\u001e\u0005\tK\u0001\u0011\t\u0011)A\u0005C\u0005A!M]8lKJLE\r\u0003\u0005(\u0001\t\u0015\r\u0011\"\u0001)\u0003I\twm\u001a:fO\u0006$X-\u00133mK6+G/\u001a:\u0016\u0003%\u0002\"AK\u001a\u000e\u0003-R!\u0001L\u0017\u0002\t\r|'/\u001a\u0006\u0003]=\nq!\\3ue&\u001c7O\u0003\u00021c\u00051\u00110Y7nKJT\u0011AM\u0001\u0004G>l\u0017B\u0001\u001b,\u0005\u0015iU\r^3s\u0011!1\u0004A!A!\u0002\u0013I\u0013aE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011A\u001d\u0002'Q|G/\u00197IC:$G.\u001a:UQJ,\u0017\rZ:\u0016\u0003\u0005B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0015i>$\u0018\r\u001c%b]\u0012dWM\u001d+ie\u0016\fGm\u001d\u0011\t\u0011u\u0002!Q1A\u0005\u0002y\naB]3rk\u0016\u001cHo\u00115b]:,G.F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011E!A\u0004oKR<xN]6\n\u0005\u0011\u000b%A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u007f\u0005y!/Z9vKN$8\t[1o]\u0016d\u0007\u0005\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0003\u0011\t\u0007/[:\u0011\u0005)[U\"\u0001\u0002\n\u00051\u0013!!C&bM.\f\u0017\t]5t\u0011\u0015q\u0005\u0001\"\u0001P\u0003\u0019a\u0014N\\5u}Q9\u0001+\u0015*T)V3\u0006C\u0001&\u0001\u0011\u0015\u0001S\n1\u0001\"\u0011\u0015)S\n1\u0001\"\u0011\u00159S\n1\u0001*\u0011\u0015AT\n1\u0001\"\u0011\u0015iT\n1\u0001@\u0011\u0015AU\n1\u0001J\u0011\u0015A\u0006\u0001\"\u0001Z\u0003\r\u0011XO\u001c\u000b\u00025B\u0011!dW\u0005\u00039n\u0011A!\u00168ji\")a\f\u0001C\u00013\u0006A1\u000f[;uI><h\u000e")
public class KafkaRequestHandler
implements Runnable,
Logging {
    public final int kafka$server$KafkaRequestHandler$$id;
    public final int kafka$server$KafkaRequestHandler$$brokerId;
    private final Meter aggregateIdleMeter;
    private final int totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final KafkaApis apis;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        KafkaRequestHandler kafkaRequestHandler = this;
        synchronized (kafkaRequestHandler) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public int totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        {
            while (true) {
                ObjectRef req$1 = new ObjectRef(null);
                while ((RequestChannel.Request)req$1.elem == null) {
                    long startSelectTime = SystemTime$.MODULE$.nanoseconds();
                    req$1.elem = this.requestChannel().receiveRequest(300L);
                    long idleTime = SystemTime$.MODULE$.nanoseconds() - startSelectTime;
                    this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads());
                }
                if ((RequestChannel.Request)req$1.elem == RequestChannel$.MODULE$.AllDone()) {
                    this.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final KafkaRequestHandler $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Kafka request handler %d on broker %d received shut down command").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaRequestHandler$$id), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaRequestHandler$$brokerId)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                ((RequestChannel.Request)req$1.elem).requestDequeueTimeMs_$eq(SystemTime$.MODULE$.milliseconds());
                this.trace((Function0<String>)new Serializable(this, req$1){
                    public static final long serialVersionUID;
                    private final KafkaRequestHandler $outer;
                    private final ObjectRef req$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Kafka request handler %d on broker %d handling request %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaRequestHandler$$id), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$KafkaRequestHandler$$brokerId), (RequestChannel.Request)this.req$1.elem}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.req$1 = objectRef;
                    }
                });
                this.apis.handle((RequestChannel.Request)req$1.elem);
            }
        }
    }

    public void shutdown() {
        this.requestChannel().sendRequest(RequestChannel$.MODULE$.AllDone());
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, int totalHandlerThreads, RequestChannel requestChannel, KafkaApis apis) {
        this.kafka$server$KafkaRequestHandler$$id = id;
        this.kafka$server$KafkaRequestHandler$$brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Kafka Request Handler ").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)" on Broker ").append((Object)BoxesRunTime.boxToInteger((int)brokerId)).append((Object)"], ").toString());
    }
}

