/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.consumer.ZookeeperConsumerConnector;
import kafka.producer.BaseProducer;
import kafka.producer.NewShinyProducer;
import kafka.producer.OldProducer;
import kafka.serializer.DefaultDecoder;
import kafka.serializer.DefaultDecoder$;
import kafka.tools.MirrorMaker;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class MirrorMaker$
implements Logging {
    public static final MirrorMaker$ MODULE$;
    private Seq<ZookeeperConsumerConnector> connectors;
    private Seq<MirrorMaker.ConsumerThread> consumerThreads;
    private Seq<MirrorMaker.ProducerThread> producerThreads;
    private final AtomicBoolean isShuttingdown;
    private final ProducerRecord<byte[], byte[]> kafka$tools$MirrorMaker$$shutdownMessage;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new MirrorMaker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        MirrorMaker$ mirrorMaker$ = this;
        synchronized (mirrorMaker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private Seq<ZookeeperConsumerConnector> connectors() {
        return this.connectors;
    }

    private void connectors_$eq(Seq<ZookeeperConsumerConnector> seq) {
        this.connectors = seq;
    }

    private Seq<MirrorMaker.ConsumerThread> consumerThreads() {
        return this.consumerThreads;
    }

    private void consumerThreads_$eq(Seq<MirrorMaker.ConsumerThread> seq) {
        this.consumerThreads = seq;
    }

    private Seq<MirrorMaker.ProducerThread> producerThreads() {
        return this.producerThreads;
    }

    private void producerThreads_$eq(Seq<MirrorMaker.ProducerThread> seq) {
        this.producerThreads = seq;
    }

    private AtomicBoolean isShuttingdown() {
        return this.isShuttingdown;
    }

    public final ProducerRecord<byte[], byte[]> kafka$tools$MirrorMaker$$shutdownMessage() {
        return this.kafka$tools$MirrorMaker$$shutdownMessage;
    }

    public void main(String[] args) {
        OptionSet options$1;
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Starting mirror maker";
            }
        });
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec consumerConfigOpt = parser.accepts("consumer.config", "Consumer config to consume from a source cluster. You may specify multiple of these.").withRequiredArg().describedAs("config file").ofType(String.class);
        ArgumentAcceptingOptionSpec producerConfigOpt = parser.accepts("producer.config", "Embedded producer config.").withRequiredArg().describedAs("config file").ofType(String.class);
        OptionSpecBuilder useNewProducerOpt = parser.accepts("new.producer", "Use the new producer implementation.");
        ArgumentAcceptingOptionSpec numProducersOpt = parser.accepts("num.producers", "Number of producer instances").withRequiredArg().describedAs("Number of producers").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec numStreamsOpt = parser.accepts("num.streams", "Number of consumption streams.").withRequiredArg().describedAs("Number of threads").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec bufferSizeOpt = parser.accepts("queue.size", "Number of messages that are buffered between the consumer and producer").withRequiredArg().describedAs("Queue size in terms of number of messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        ArgumentAcceptingOptionSpec blacklistOpt = parser.accepts("blacklist", "Blacklist of topics to mirror.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class);
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print this message.");
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Continuously copy data between two Kafka clusters.");
        }
        if ((options$1 = parser.parse(args)).has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options$1, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{consumerConfigOpt, producerConfigOpt}));
        if (List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{whitelistOpt, blacklistOpt})).count((Function1)new Serializable(options$1){
            public static final long serialVersionUID;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(OptionSpec<?> optionSpec) {
                return this.options$1.has(optionSpec);
            }
            {
                this.options$1 = optionSet;
            }
        }) != 1) {
            Predef$.MODULE$.println((Object)"Exactly one of whitelist or blacklist is required.");
            System.exit(1);
        }
        int numProducers = (Integer)options$1.valueOf((OptionSpec)numProducersOpt);
        int numStreams$1 = (Integer)options$1.valueOf((OptionSpec)numStreamsOpt);
        int bufferSize = (Integer)options$1.valueOf((OptionSpec)bufferSizeOpt);
        this.connectors_$eq((Seq<ZookeeperConsumerConnector>)((Seq)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(options$1.valuesOf((OptionSpec)consumerConfigOpt)).toList().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ConsumerConfig apply(String cfg) {
                return new ConsumerConfig(Utils$.MODULE$.loadProps(cfg));
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ZookeeperConsumerConnector apply(ConsumerConfig consumerConfig) {
                return new ZookeeperConsumerConnector(consumerConfig);
            }
        }, List$.MODULE$.canBuildFrom())));
        int numConsumers = this.connectors().size() * numStreams$1;
        MirrorMaker.DataChannel mirrorDataChannel$1 = new MirrorMaker.DataChannel(bufferSize, numConsumers, numProducers);
        boolean useNewProducer$1 = options$1.has((OptionSpec)useNewProducerOpt);
        Properties producerProps$1 = Utils$.MODULE$.loadProps((String)options$1.valueOf((OptionSpec)producerConfigOpt));
        String clientId$1 = producerProps$1.getProperty("client.id", "");
        this.producerThreads_$eq((Seq<MirrorMaker.ProducerThread>)((Seq)Predef$.MODULE$.intWrapper(0).until(numProducers).map((Function1)new Serializable(mirrorDataChannel$1, useNewProducer$1, producerProps$1, clientId$1){
            public static final long serialVersionUID;
            private final MirrorMaker.DataChannel mirrorDataChannel$1;
            private final boolean useNewProducer$1;
            private final Properties producerProps$1;
            private final String clientId$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final MirrorMaker.ProducerThread apply(int i) {
                BaseProducer baseProducer;
                this.producerProps$1.setProperty("client.id", new StringBuilder().append((Object)this.clientId$1).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                if (this.useNewProducer$1) {
                    this.producerProps$1.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
                    this.producerProps$1.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
                    baseProducer = new NewShinyProducer(this.producerProps$1);
                } else {
                    baseProducer = new OldProducer(this.producerProps$1);
                }
                OldProducer producer = baseProducer;
                return new MirrorMaker.ProducerThread(this.mirrorDataChannel$1, producer, i);
            }
            {
                this.mirrorDataChannel$1 = dataChannel;
                this.useNewProducer$1 = bl;
                this.producerProps$1 = properties;
                this.clientId$1 = string;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        TopicFilter filterSpec$1 = options$1.has((OptionSpec)whitelistOpt) ? new Whitelist((String)options$1.valueOf((OptionSpec)whitelistOpt)) : new Blacklist((String)options$1.valueOf((OptionSpec)blacklistOpt));
        Nil$ streams2 = Nil$.MODULE$;
        try {
            streams2 = (Seq)((GenericTraversableTemplate)this.connectors().map((Function1)new Serializable(numStreams$1, filterSpec$1){
                public static final long serialVersionUID;
                private final int numStreams$1;
                private final TopicFilter filterSpec$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Seq<KafkaStream<byte[], byte[]>> apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                    return zookeeperConsumerConnector.createMessageStreamsByFilter(this.filterSpec$1, this.numStreams$1, new DefaultDecoder(DefaultDecoder$.MODULE$.init$default$1()), new DefaultDecoder(DefaultDecoder$.MODULE$.init$default$1()));
                }
                {
                    this.numStreams$1 = n;
                    this.filterSpec$1 = topicFilter;
                }
            }, Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.conforms());
        }
        catch (Throwable throwable) {
            this.fatal((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Unable to create stream - shutting down mirror maker.";
                }
            });
            this.connectors().foreach((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                    zookeeperConsumerConnector.shutdown();
                }
            });
        }
        this.consumerThreads_$eq((Seq<MirrorMaker.ConsumerThread>)((Seq)((TraversableLike)streams2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(mirrorDataChannel$1){
            public static final long serialVersionUID;
            private final MirrorMaker.DataChannel mirrorDataChannel$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final MirrorMaker.ConsumerThread apply(Tuple2<KafkaStream<byte[], byte[]>, Object> streamAndIndex) {
                return new MirrorMaker.ConsumerThread((KafkaStream)streamAndIndex._1(), this.mirrorDataChannel$1, streamAndIndex._2$mcI$sp());
            }
            {
                this.mirrorDataChannel$1 = dataChannel;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        Predef$.MODULE$.assert(this.consumerThreads().size() == numConsumers);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MirrorMaker$.MODULE$.cleanShutdown();
            }
        });
        this.consumerThreads().foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.ConsumerThread consumerThread) {
                consumerThread.start();
            }
        });
        this.producerThreads().foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.ProducerThread producerThread) {
                producerThread.start();
            }
        });
        this.producerThreads().foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MirrorMaker.ProducerThread producerThread) {
                producerThread.awaitShutdown();
            }
        });
    }

    public void cleanShutdown() {
        if (this.isShuttingdown().compareAndSet(false, true)) {
            if (this.connectors() != null) {
                this.connectors().foreach((Function1)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(ZookeeperConsumerConnector zookeeperConsumerConnector) {
                        zookeeperConsumerConnector.shutdown();
                    }
                });
            }
            if (this.consumerThreads() != null) {
                this.consumerThreads().foreach((Function1)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(MirrorMaker.ConsumerThread consumerThread) {
                        consumerThread.awaitShutdown();
                    }
                });
            }
            if (this.producerThreads() != null) {
                this.producerThreads().foreach((Function1)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(MirrorMaker.ProducerThread producerThread) {
                        producerThread.shutdown();
                    }
                });
                this.producerThreads().foreach((Function1)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(MirrorMaker.ProducerThread producerThread) {
                        producerThread.awaitShutdown();
                    }
                });
            }
            this.info((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Kafka mirror maker shutdown successfully";
                }
            });
        }
    }

    private MirrorMaker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.connectors = null;
        this.consumerThreads = null;
        this.producerThreads = null;
        this.isShuttingdown = new AtomicBoolean(false);
        this.kafka$tools$MirrorMaker$$shutdownMessage = new ProducerRecord("shutdown", (Object)"shutdown".getBytes());
    }
}

