/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.Request$;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.tools.DefaultMessageFormatter;
import kafka.tools.MessageFormatter;
import kafka.tools.SimpleConsumerShell$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ToolsUtils$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class SimpleConsumerShell$
implements Logging {
    public static final SimpleConsumerShell$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new SimpleConsumerShell$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SimpleConsumerShell$ simpleConsumerShell$ = this;
        synchronized (simpleConsumerShell$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int UseLeaderReplica() {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        ObjectRef fetchTargetBroker$1;
        FetchRequestBuilder fetchRequestBuilder$1;
        Properties formatterArgs;
        Class<?> messageFormatterClass;
        boolean noWaitAtEndOfLog$1;
        boolean printOffsets$1;
        boolean skipMessageOnError$1;
        int maxMessages$1;
        String clientId;
        int fetchSize$1;
        LongRef startingOffset$1;
        int replicaId$1;
        int partitionId$1;
        String topic$1;
        block15: {
            Seq<PartitionMetadata> partitionsMetadata;
            Option partitionMetadataOpt;
            OptionParser parser = new OptionParser();
            ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
            ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
            ArgumentAcceptingOptionSpec partitionIdOpt = parser.accepts("partition", "The partition to consume from.").withRequiredArg().describedAs("partition").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec replicaIdOpt = parser.accepts("replica", "The replica id to consume from, default -1 means leader broker.").withRequiredArg().describedAs("replica id").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(this.UseLeaderReplica()), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec offsetOpt = parser.accepts("offset", "The offset id to consume from, default to -2 which means from beginning; while value -1 means from end").withRequiredArg().describedAs("consume offset").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(OffsetRequest$.MODULE$.EarliestTime()), (Object[])new Long[0]);
            ArgumentAcceptingOptionSpec clientIdOpt = parser.accepts("clientId", "The ID of this client.").withRequiredArg().describedAs("clientId").ofType(String.class).defaultsTo((Object)"SimpleConsumerShell", (Object[])new String[0]);
            ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetchsize", "The fetch size of each request.").withRequiredArg().describedAs("fetchsize").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec messageFormatterOpt = parser.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)DefaultMessageFormatter.class.getName(), (Object[])new String[0]);
            ArgumentAcceptingOptionSpec messageFormatterArgOpt = parser.accepts("property").withRequiredArg().describedAs("prop").ofType(String.class);
            OptionSpecBuilder printOffsetOpt = parser.accepts("print-offsets", "Print the offsets returned by the iterator");
            ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec maxMessagesOpt = parser.accepts("max-messages", "The number of messages to consume").withRequiredArg().describedAs("max-messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
            OptionSpecBuilder skipMessageOnErrorOpt = parser.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
            OptionSpecBuilder noWaitAtEndOfLogOpt = parser.accepts("no-wait-at-logend", "If set, when the simple consumer reaches the end of the Log, it will stop, not waiting for new produced messages");
            if (args.length == 0) {
                CommandLineUtils$.MODULE$.printUsageAndDie(parser, "A low-level tool for fetching data directly from a particular replica.");
            }
            OptionSet options = parser.parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt, partitionIdOpt}));
            topic$1 = (String)options.valueOf((OptionSpec)topicOpt);
            partitionId$1 = (Integer)options.valueOf((OptionSpec)partitionIdOpt);
            replicaId$1 = (Integer)options.valueOf((OptionSpec)replicaIdOpt);
            startingOffset$1 = new LongRef(((Long)options.valueOf((OptionSpec)offsetOpt)).longValue());
            fetchSize$1 = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
            clientId = ((String)options.valueOf((OptionSpec)clientIdOpt)).toString();
            int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
            maxMessages$1 = (Integer)options.valueOf((OptionSpec)maxMessagesOpt);
            skipMessageOnError$1 = options.has((OptionSpec)skipMessageOnErrorOpt);
            printOffsets$1 = options.has((OptionSpec)printOffsetOpt);
            noWaitAtEndOfLog$1 = options.has((OptionSpec)noWaitAtEndOfLogOpt);
            messageFormatterClass = Class.forName((String)options.valueOf((OptionSpec)messageFormatterOpt));
            formatterArgs = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)JavaConversions$.MODULE$.asScalaBuffer(options.valuesOf((OptionSpec)messageFormatterArgOpt)));
            fetchRequestBuilder$1 = new FetchRequestBuilder().clientId(clientId).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(maxWaitMs).minBytes(ConsumerConfig$.MODULE$.MinFetchBytes());
            this.info((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Getting topic metatdata...";
                }
            });
            String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
            ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
            Seq<Broker> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
            Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))), metadataTargetBrokers, clientId, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
            if (topicsMetadata.size() != 1 || !((TopicMetadata)topicsMetadata.apply(0)).topic().equals(topic$1)) {
                System.err.println(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s, what we get from server is only: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$1, topicsMetadata})));
                System.exit(1);
            }
            if (!(partitionMetadataOpt = (partitionsMetadata = ((TopicMetadata)topicsMetadata.apply(0)).partitionsMetadata()).find((Function1)new Serializable(partitionId$1){
                public static final long serialVersionUID;
                private final int partitionId$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(PartitionMetadata p) {
                    return p.partitionId() == this.partitionId$1;
                }
                {
                    this.partitionId$1 = n;
                }
            })).isDefined()) {
                System.err.println(Predef$.MODULE$.augmentString("Error: partition %d does not exist for topic %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId$1), topic$1})));
                System.exit(1);
            }
            fetchTargetBroker$1 = new ObjectRef(null);
            Option replicaOpt = null;
            if (replicaId$1 == this.UseLeaderReplica()) {
                replicaOpt = ((PartitionMetadata)partitionMetadataOpt.get()).leader();
                if (!replicaOpt.isDefined()) {
                    System.err.println(Predef$.MODULE$.augmentString("Error: user speicifies to fetch from leader for partition (%s, %d) which has not been elected yet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topic$1, BoxesRunTime.boxToInteger((int)partitionId$1)})));
                    System.exit(1);
                }
            } else {
                Seq<Broker> replicasForPartition2 = ((PartitionMetadata)partitionMetadataOpt.get()).replicas();
                replicaOpt = replicasForPartition2.find((Function1)new Serializable(replicaId$1){
                    public static final long serialVersionUID;
                    private final int replicaId$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Broker r) {
                        return r.id() == this.replicaId$1;
                    }
                    {
                        this.replicaId$1 = n;
                    }
                });
                if (!replicaOpt.isDefined()) {
                    System.err.println(Predef$.MODULE$.augmentString("Error: replica %d does not exist for partition (%s, %d)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topic$1, BoxesRunTime.boxToInteger((int)partitionId$1)})));
                    System.exit(1);
                }
            }
            fetchTargetBroker$1.elem = (Broker)replicaOpt.get();
            if (startingOffset$1.elem < OffsetRequest$.MODULE$.EarliestTime()) {
                System.err.println(Predef$.MODULE$.augmentString("Invalid starting offset: %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startingOffset$1.elem)})));
                System.exit(1);
            }
            if (startingOffset$1.elem < 0L) {
                SimpleConsumer simpleConsumer = new SimpleConsumer(((Broker)fetchTargetBroker$1.elem).host(), ((Broker)fetchTargetBroker$1.elem).port(), ConsumerConfig$.MODULE$.SocketTimeout(), ConsumerConfig$.MODULE$.SocketBufferSize(), clientId);
                try {
                    startingOffset$1.elem = simpleConsumer.earliestOrLatestOffset(new TopicAndPartition(topic$1, partitionId$1), startingOffset$1.elem, Request$.MODULE$.DebuggingConsumerId());
                    if (simpleConsumer != null) {
                        simpleConsumer.close();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        System.err.println(new StringBuilder().append((Object)"Error in getting earliest or latest offset due to: ").append((Object)Utils$.MODULE$.stackTrace(throwable)).toString());
                        System.exit(1);
                    }
                    finally {
                        if (simpleConsumer == null) break block15;
                        simpleConsumer.close();
                    }
                }
            }
        }
        MessageFormatter formatter$1 = (MessageFormatter)messageFormatterClass.newInstance();
        formatter$1.init(formatterArgs);
        String replicaString$1 = replicaId$1 > 0 ? "leader" : "replica";
        this.info((Function0<String>)new Serializable(topic$1, partitionId$1, replicaId$1, startingOffset$1, fetchTargetBroker$1, replicaString$1){
            public static final long serialVersionUID;
            private final String topic$1;
            private final int partitionId$1;
            private final int replicaId$1;
            private final LongRef startingOffset$1;
            private final ObjectRef fetchTargetBroker$1;
            private final String replicaString$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Starting simple consumer shell to partition [%s, %d], %s [%d], host and port: [%s, %d], from offset [%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1), this.replicaString$1, BoxesRunTime.boxToInteger((int)this.replicaId$1), ((Broker)this.fetchTargetBroker$1.elem).host(), BoxesRunTime.boxToInteger((int)((Broker)this.fetchTargetBroker$1.elem).port()), BoxesRunTime.boxToLong((long)this.startingOffset$1.elem)}));
            }
            {
                this.topic$1 = string;
                this.partitionId$1 = n;
                this.replicaId$1 = n2;
                this.startingOffset$1 = longRef;
                this.fetchTargetBroker$1 = objectRef;
                this.replicaString$1 = string2;
            }
        });
        SimpleConsumer simpleConsumer$1 = new SimpleConsumer(((Broker)fetchTargetBroker$1.elem).host(), ((Broker)fetchTargetBroker$1.elem).port(), 10000, 65536, clientId);
        Thread thread = Utils$.MODULE$.newThread("kafka-simpleconsumer-shell", new Runnable(topic$1, partitionId$1, replicaId$1, startingOffset$1, fetchSize$1, maxMessages$1, skipMessageOnError$1, printOffsets$1, noWaitAtEndOfLog$1, fetchRequestBuilder$1, formatter$1, simpleConsumer$1){
            public final String topic$1;
            public final int partitionId$1;
            public final int replicaId$1;
            private final LongRef startingOffset$1;
            private final int fetchSize$1;
            public final int maxMessages$1;
            public final boolean skipMessageOnError$1;
            public final boolean printOffsets$1;
            private final boolean noWaitAtEndOfLog$1;
            private final FetchRequestBuilder fetchRequestBuilder$1;
            public final MessageFormatter formatter$1;
            public final SimpleConsumer simpleConsumer$1;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                LongRef offset$1 = new LongRef(this.startingOffset$1.elem);
                IntRef numMessagesConsumed$1 = new IntRef(0);
                while (true) {
                    ByteBufferMessageSet messageSet$1;
                    try {
                        if (numMessagesConsumed$1.elem >= this.maxMessages$1) break;
                        FetchRequest fetchRequest = this.fetchRequestBuilder$1.addFetch(this.topic$1, this.partitionId$1, offset$1.elem, this.fetchSize$1).build();
                        FetchResponse fetchResponse = this.simpleConsumer$1.fetch(fetchRequest);
                        messageSet$1 = fetchResponse.messageSet(this.topic$1, this.partitionId$1);
                        if (messageSet$1.validBytes() <= 0 && this.noWaitAtEndOfLog$1) {
                            Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("Terminating. Reached the end of partition (%s, %d) at offset %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partitionId$1), BoxesRunTime.boxToLong((long)offset$1.elem)})));
                            SimpleConsumerShell$.MODULE$.info((Function0<String>)new Serializable(this, numMessagesConsumed$1){
                                public static final long serialVersionUID;
                                private final IntRef numMessagesConsumed$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Consumed ").append((Object)BoxesRunTime.boxToInteger((int)this.numMessagesConsumed$1.elem)).append((Object)" messages").toString();
                                }
                                {
                                    this.numMessagesConsumed$1 = intRef;
                                }
                            });
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            SimpleConsumerShell$.MODULE$.error((Function0<String>)new Serializable(this, offset$1){
                                public static final long serialVersionUID;
                                private final anon.1 $outer;
                                private final LongRef offset$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Error consuming topic, partition, replica (%s, %d, %d) with offset [%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.$outer.partitionId$1), BoxesRunTime.boxToInteger((int)this.$outer.replicaId$1), BoxesRunTime.boxToLong((long)this.offset$1.elem)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.offset$1 = longRef;
                                }
                            }, (Function0<Throwable>)new Serializable(this, throwable){
                                public static final long serialVersionUID;
                                private final Throwable e$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Throwable apply() {
                                    return this.e$2;
                                }
                                {
                                    this.e$2 = throwable;
                                }
                            });
                            SimpleConsumerShell$.MODULE$.info((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                        catch (Throwable throwable2) {
                            SimpleConsumerShell$.MODULE$.info((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                            throw throwable2;
                        }
                    }
                    {
                        SimpleConsumerShell$.MODULE$.debug((Function0<String>)new Serializable(this, offset$1, messageSet$1){
                            public static final long serialVersionUID;
                            private final LongRef offset$1;
                            private final ByteBufferMessageSet messageSet$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"multi fetched ").append((Object)BoxesRunTime.boxToInteger((int)this.messageSet$1.sizeInBytes())).append((Object)" bytes from offset ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1.elem)).toString();
                            }
                            {
                                this.offset$1 = longRef;
                                this.messageSet$1 = byteBufferMessageSet;
                            }
                        });
                        messageSet$1.withFilter((Function1)new Serializable(this, numMessagesConsumed$1){
                            public static final long serialVersionUID;
                            private final anon.1 $outer;
                            private final IntRef numMessagesConsumed$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final boolean apply(MessageAndOffset messageAndOffset) {
                                return this.numMessagesConsumed$1.elem < this.$outer.maxMessages$1;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.numMessagesConsumed$1 = intRef;
                            }
                        }).foreach((Function1)new Serializable(this, offset$1, numMessagesConsumed$1){
                            public static final long serialVersionUID;
                            private final anon.1 $outer;
                            private final LongRef offset$1;
                            private final IntRef numMessagesConsumed$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply(MessageAndOffset messageAndOffset) {
                                Throwable throwable2;
                                block4: {
                                    try {
                                        Message message;
                                        this.offset$1.elem = messageAndOffset.nextOffset();
                                        if (this.$outer.printOffsets$1) {
                                            System.out.println(new StringBuilder().append((Object)"next offset = ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1.elem)).toString());
                                        }
                                        byte[] key = (message = messageAndOffset.message()).hasKey() ? Utils$.MODULE$.readBytes(message.key()) : null;
                                        this.$outer.formatter$1.writeTo(key, message.isNull() ? null : Utils$.MODULE$.readBytes(message.payload()), System.out);
                                        ++this.numMessagesConsumed$1.elem;
                                    }
                                    catch (Throwable throwable2) {
                                        if (!this.$outer.skipMessageOnError$1) break block4;
                                        SimpleConsumerShell$.MODULE$.error((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return "Error processing message, skipping this message: ";
                                            }
                                        }, (Function0<Throwable>)new Serializable(this, throwable2){
                                            public static final long serialVersionUID;
                                            private final Throwable e$1;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final Throwable apply() {
                                                return this.e$1;
                                            }
                                            {
                                                this.e$1 = throwable;
                                            }
                                        });
                                    }
                                    if (System.out.checkError()) {
                                        System.err.println("Unable to write to standard out, closing consumer.");
                                        this.$outer.formatter$1.close();
                                        this.$outer.simpleConsumer$1.close();
                                        System.exit(1);
                                    }
                                    return;
                                }
                                throw throwable2;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.offset$1 = longRef;
                                this.numMessagesConsumed$1 = intRef;
                            }
                        });
                        continue;
                    }
                    break;
                }
                SimpleConsumerShell$.MODULE$.info((Function0<String>)new /* invalid duplicate definition of identical inner class */);
            }
            {
                this.topic$1 = string;
                this.partitionId$1 = n;
                this.replicaId$1 = n2;
                this.startingOffset$1 = longRef;
                this.fetchSize$1 = n3;
                this.maxMessages$1 = n4;
                this.skipMessageOnError$1 = bl;
                this.printOffsets$1 = bl2;
                this.noWaitAtEndOfLog$1 = bl3;
                this.fetchRequestBuilder$1 = fetchRequestBuilder;
                this.formatter$1 = messageFormatter;
                this.simpleConsumer$1 = simpleConsumer;
            }
        }, false);
        thread.start();
        thread.join();
        System.out.flush();
        formatter$1.close();
        simpleConsumer$1.close();
    }

    private SimpleConsumerShell$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

