/*
 * Decompiled with CFR 0.152.
 */
package kafka.javaapi;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import kafka.api.RequestKeys$;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u000f\t!Bk\u001c9jG6+G/\u00193bi\u0006\u0014V-];fgRT!a\u0001\u0003\u0002\u000f)\fg/Y1qS*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0019\u0011\r]5\n\u00055Q!!\u0005*fcV,7\u000f^(s%\u0016\u001c\bo\u001c8tKB\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\tY1kY1mC>\u0013'.Z2u\u0011!)\u0002A!b\u0001\n\u00031\u0012!\u0003<feNLwN\\%e+\u00059\u0002CA\b\u0019\u0013\tI\u0002CA\u0003TQ>\u0014H\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003)1XM]:j_:LE\r\t\u0005\t;\u0001\u0011)\u0019!C\u0001=\u0005i1m\u001c:sK2\fG/[8o\u0013\u0012,\u0012a\b\t\u0003\u001f\u0001J!!\t\t\u0003\u0007%sG\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003 \u00039\u0019wN\u001d:fY\u0006$\u0018n\u001c8JI\u0002B\u0001\"\n\u0001\u0003\u0006\u0004%\tAJ\u0001\tG2LWM\u001c;JIV\tq\u0005\u0005\u0002)W9\u0011q\"K\u0005\u0003UA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!\u0006\u0005\u0005\t_\u0001\u0011\t\u0011)A\u0005O\u0005I1\r\\5f]RLE\r\t\u0005\tc\u0001\u0011)\u0019!C\u0001e\u00051Ao\u001c9jGN,\u0012a\r\t\u0004ie:S\"A\u001b\u000b\u0005Y:\u0014\u0001B;uS2T\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\t!A*[:u\u0011!a\u0004A!A!\u0002\u0013\u0019\u0014a\u0002;pa&\u001c7\u000f\t\u0005\u0006}\u0001!\taP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0001\u00135\tR#\u0011\u0005\u0005\u0003Q\"\u0001\u0002\t\u000bUi\u0004\u0019A\f\t\u000bui\u0004\u0019A\u0010\t\u000b\u0015j\u0004\u0019A\u0014\t\u000bEj\u0004\u0019A\u001a\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\u0006QQO\u001c3fe2L\u0018N\\4\u0016\u0003%\u0003\"!\u0003&\n\u0005\u0005Q\u0001B\u0002'\u0001A\u0003%\u0011*A\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\u0003\"\u0002 \u0001\t\u0003qEC\u0001!P\u0011\u0015\tT\n1\u00014\u0011\u0015q\u0004\u0001\"\u0001R)\r\u0001%k\u0015\u0005\u0006cA\u0003\ra\r\u0005\u0006;A\u0003\ra\b\u0005\u0006+\u0002!\tAV\u0001\boJLG/\u001a+p)\t9&\f\u0005\u0002\u00101&\u0011\u0011\f\u0005\u0002\u0005+:LG\u000fC\u0003\\)\u0002\u0007A,\u0001\u0004ck\u001a4WM\u001d\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?^\n1A\\5p\u0013\t\tgL\u0001\u0006CsR,')\u001e4gKJDQa\u0019\u0001\u0005\u0002y\t1b]5{K&s')\u001f;fg\")Q\r\u0001C!M\u0006AAo\\*ue&tw\rF\u0001(\u0011\u0015A\u0007\u0001\"\u0011j\u0003!!Wm]2sS\n,GCA\u0014k\u0011\u0015Yw\r1\u0001m\u0003\u001d!W\r^1jYN\u0004\"aD7\n\u00059\u0004\"a\u0002\"p_2,\u0017M\u001c")
public class TopicMetadataRequest
extends RequestOrResponse
implements ScalaObject {
    private final short versionId;
    private final int correlationId;
    private final String clientId;
    private final List<String> topics;
    private final kafka.api.TopicMetadataRequest underlying;

    public short versionId() {
        return this.versionId;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public List<String> topics() {
        return this.topics;
    }

    public kafka.api.TopicMetadataRequest underlying() {
        return this.underlying;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        this.underlying().writeTo(buffer);
    }

    @Override
    public int sizeInBytes() {
        return this.underlying().sizeInBytes();
    }

    public String toString() {
        return this.describe(true);
    }

    @Override
    public String describe(boolean details) {
        StringBuilder topicMetadataRequest = new StringBuilder();
        topicMetadataRequest.append(new StringBuilder().append((Object)"Name: ").append((Object)this.getClass().getSimpleName()).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; Version: ").append((Object)BoxesRunTime.boxToShort((short)this.versionId())).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; CorrelationId: ").append((Object)BoxesRunTime.boxToInteger((int)this.correlationId())).toString());
        topicMetadataRequest.append(new StringBuilder().append((Object)"; ClientId: ").append((Object)this.clientId()).toString());
        if (details) {
            topicMetadataRequest.append("; Topics: ");
            Iterator<String> topicIterator = this.topics().iterator();
            while (topicIterator.hasNext()) {
                String topic = topicIterator.next();
                topicMetadataRequest.append(Predef$.MODULE$.augmentString("%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
                Object object = topicIterator.hasNext() ? topicMetadataRequest.append(",") : BoxedUnit.UNIT;
            }
        }
        return topicMetadataRequest.toString();
    }

    public TopicMetadataRequest(short versionId, int correlationId, String clientId, List<String> topics) {
        this.versionId = versionId;
        this.correlationId = correlationId;
        this.clientId = clientId;
        this.topics = topics;
        super((Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)RequestKeys$.MODULE$.MetadataKey())));
        this.underlying = new kafka.api.TopicMetadataRequest(versionId, correlationId, clientId, (Seq<String>)JavaConversions$.MODULE$.asScalaBuffer(topics));
    }

    public TopicMetadataRequest(List<String> topics) {
        this(TopicMetadataRequest$.MODULE$.CurrentVersion(), 0, TopicMetadataRequest$.MODULE$.DefaultClientId(), topics);
    }

    public TopicMetadataRequest(List<String> topics, int correlationId) {
        this(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId, TopicMetadataRequest$.MODULE$.DefaultClientId(), topics);
    }
}

