/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005mu!B\u0001\u0003\u0011\u000b9\u0011\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+GO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0003\u0017\t!\")\u001f;f\u0005V4g-\u001a:NKN\u001c\u0018mZ3TKR\u001c2!\u0003\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"aC*dC2\fwJ\u00196fGRDQaG\u0005\u0005\u0002q\ta\u0001P5oSRtD#A\u0004\t\u000byIA\u0011B\u0010\u0002\r\r\u0014X-\u0019;f)\u0011\u0001cEM\u001c\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\r\u0002\u0012a\u00018j_&\u0011QE\t\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B\u0014\u001e\u0001\u0004A\u0013!D8gMN,GoQ8v]R,'\u000f\u0005\u0002*a5\t!F\u0003\u0002,Y\u00051\u0011\r^8nS\u000eT!!\f\u0018\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00020!\u0005!Q\u000f^5m\u0013\t\t$F\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDQaM\u000fA\u0002Q\n\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0011\u0005!)\u0014B\u0001\u001c\u0003\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\rC\u00039;\u0001\u0007\u0011(\u0001\u0005nKN\u001c\u0018mZ3t!\r)\"\bP\u0005\u0003wY\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\tAQ(\u0003\u0002?\u0005\t9Q*Z:tC\u001e,\u0007\"\u0002!\n\t\u0003\t\u0015A\u00033fG>l\u0007O]3tgR\u0019!)!$\u0011\u0005!\u0019e\u0001\u0002\u0006\u0003\u0001\u0011\u001bBaQ#I)A\u0011\u0001BR\u0005\u0003\u000f\n\u0011!\"T3tg\u0006<WmU3u!\tIE*D\u0001K\u0015\tYE!A\u0003vi&d7/\u0003\u0002N\u0015\n9Aj\\4hS:<\u0007\u0002C(D\u0005\u000b\u0007I\u0011\u0001)\u0002\r\t,hMZ3s+\u0005\u0001\u0003\u0002\u0003*D\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\u000f\t,hMZ3sA!)1d\u0011C\u0001)R\u0011!)\u0016\u0005\u0006\u001fN\u0003\r\u0001\t\u0005\b/\u000e\u0003\r\u0011\"\u0003Y\u0003U\u0019\b.\u00197m_^4\u0016\r\\5e\u0005f$XmQ8v]R,\u0012!\u0017\t\u0003+iK!a\u0017\f\u0003\u0007%sG\u000fC\u0004^\u0007\u0002\u0007I\u0011\u00020\u00023MD\u0017\r\u001c7poZ\u000bG.\u001b3CsR,7i\\;oi~#S-\u001d\u000b\u0003?\n\u0004\"!\u00061\n\u0005\u00054\"\u0001B+oSRDqa\u0019/\u0002\u0002\u0003\u0007\u0011,A\u0002yIEBa!Z\"!B\u0013I\u0016AF:iC2dwn\u001e,bY&$')\u001f;f\u0007>,h\u000e\u001e\u0011\t\u000bm\u0019E\u0011A4\u0015\u0007\tC\u0017\u000eC\u00034M\u0002\u0007A\u0007C\u00039M\u0002\u0007\u0011\bC\u0003\u001c\u0007\u0012\u00051\u000e\u0006\u0003CY6t\u0007\"B\u001ak\u0001\u0004!\u0004\"B\u0014k\u0001\u0004A\u0003\"\u0002\u001dk\u0001\u0004I\u0004\"B\u000eD\t\u0003\u0001HC\u0001\"r\u0011\u0015At\u000e1\u0001:\u0011\u0015\u00198\t\"\u0001Q\u0003%9W\r\u001e\"vM\u001a,'\u000fC\u0003v\u0007\u0012%\u0001,A\ttQ\u0006dGn\\<WC2LGMQ=uKNDQa^\"\u0005\u0002a\fqa\u001e:ji\u0016$v\u000e\u0006\u0004Zs\u0006\r\u0011Q\u0002\u0005\u0006uZ\u0004\ra_\u0001\bG\"\fgN\\3m!\tax0D\u0001~\u0015\tq(%\u0001\u0005dQ\u0006tg.\u001a7t\u0013\r\t\t! \u0002\u0015\u000f\u0006$\b.\u001a:j]\u001e\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\t\u000f\u0005\u0015a\u000f1\u0001\u0002\b\u00051qN\u001a4tKR\u00042!FA\u0005\u0013\r\tYA\u0006\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\u0010Y\u0004\r!W\u0001\u0005g&TX\rC\u0004\u0002\u0014\r#\t%!\u0006\u0002\u0011%$XM]1u_J,\"!a\u0006\u0011\r\u0005e\u0011\u0011FA\u0018\u001d\u0011\tY\"!\n\u000f\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t\u0007\u0003\u0019a$o\\8u}%\tq#C\u0002\u0002(Y\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00055\"\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005\u001db\u0003E\u0002\t\u0003cI1!a\r\u0003\u0005AiUm]:bO\u0016\fe\u000eZ(gMN,G\u000fC\u0004\u00028\r#\t!!\u0006\u0002\u001fMD\u0017\r\u001c7po&#XM]1u_JDq!a\u000fD\t\u0013\ti$\u0001\tj]R,'O\\1m\u0013R,'/\u0019;peR!\u0011qCA \u0011)\t\t%!\u000f\u0011\u0002\u0003\u0007\u00111I\u0001\nSN\u001c\u0006.\u00197m_^\u00042!FA#\u0013\r\t9E\u0006\u0002\b\u0005>|G.Z1o\u0011!\tYe\u0011C\u0001\t\u00055\u0013!D1tg&<gn\u00144gg\u0016$8\u000fF\u0003C\u0003\u001f\n\t\u0006\u0003\u0004(\u0003\u0013\u0002\r\u0001\u000b\u0005\b\u0003'\nI\u00051\u00015\u0003\u0015\u0019w\u000eZ3d\u0011\u0019\t9f\u0011C\u00011\u0006Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t\u0011\u0019\tYf\u0011C\u00011\u0006Qa/\u00197jI\nKH/Z:\t\u000f\u0005}3\t\"\u0011\u0002b\u00051Q-];bYN$B!a\u0011\u0002d!A\u0011QMA/\u0001\u0004\t9'A\u0003pi\",'\u000fE\u0002\u0016\u0003SJ1!a\u001b\u0017\u0005\r\te.\u001f\u0005\b\u0003_\u001aE\u0011IA9\u0003!A\u0017m\u001d5D_\u0012,G#A-\t\u0013\u0005U4)%A\u0005\n\u0005]\u0014AG5oi\u0016\u0014h.\u00197Ji\u0016\u0014\u0018\r^8sI\u0011,g-Y;mi\u0012\nTCAA=U\u0011\t\u0019%a\u001f,\u0005\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\"\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\u000b\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DQaA A\u0002qB\u0001\"!%\n\t\u0003!\u00111S\u0001\roJLG/Z'fgN\fw-\u001a\u000b\b?\u0006U\u0015qSAM\u0011\u0019y\u0015q\u0012a\u0001A!11!a$A\u0002qB\u0001\"!\u0002\u0002\u0010\u0002\u0007\u0011q\u0001")
public class ByteBufferMessageSet
extends MessageSet
implements Logging {
    private final ByteBuffer buffer;
    private int shallowValidByteCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final ByteBufferMessageSet decompress(Message message) {
        return ByteBufferMessageSet$.MODULE$.decompress(message);
    }

    public static final ByteBuffer kafka$message$ByteBufferMessageSet$$create(AtomicLong atomicLong, CompressionCodec compressionCodec, Seq<Message> seq) {
        return ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(atomicLong, compressionCodec, seq);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ByteBufferMessageSet byteBufferMessageSet = this;
        synchronized (byteBufferMessageSet) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    private int shallowValidByteCount() {
        return this.shallowValidByteCount;
    }

    private void shallowValidByteCount_$eq(int n) {
        this.shallowValidByteCount = n;
    }

    public ByteBuffer getBuffer() {
        return this.buffer();
    }

    private int shallowValidBytes() {
        if (this.shallowValidByteCount() < 0) {
            int bytes = 0;
            Iterator<MessageAndOffset> iter = this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
            while (iter.hasNext()) {
                MessageAndOffset messageAndOffset = (MessageAndOffset)iter.next();
                bytes += MessageSet$.MODULE$.entrySize(messageAndOffset.message());
            }
            this.shallowValidByteCount_$eq(bytes);
        }
        return this.shallowValidByteCount();
    }

    @Override
    public int writeTo(GatheringByteChannel channel, long offset, int size2) {
        int written;
        this.buffer().mark();
        for (written = 0; written < this.sizeInBytes(); written += channel.write(this.buffer())) {
        }
        this.buffer().reset();
        return written;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(this.kafka$message$ByteBufferMessageSet$$internalIterator$default$1());
    }

    public Iterator<MessageAndOffset> shallowIterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
    }

    public final Iterator<MessageAndOffset> kafka$message$ByteBufferMessageSet$$internalIterator(boolean isShallow$1) {
        return new IteratorTemplate<MessageAndOffset>(this, isShallow$1){
            private ByteBuffer topIter;
            private Iterator<MessageAndOffset> innerIter;
            private final boolean isShallow$1;

            private ByteBuffer topIter() {
                return this.topIter;
            }

            private void topIter_$eq(ByteBuffer byteBuffer) {
                this.topIter = byteBuffer;
            }

            private Iterator<MessageAndOffset> innerIter() {
                return this.innerIter;
            }

            private void innerIter_$eq(Iterator<MessageAndOffset> iterator) {
                this.innerIter = iterator;
            }

            private boolean innerDone() {
                return this.innerIter() == null || !this.innerIter().hasNext();
            }

            private MessageAndOffset makeNextOuter() {
                MessageAndOffset messageAndOffset;
                if (this.topIter().remaining() < 12) {
                    return (MessageAndOffset)this.allDone();
                }
                long offset = this.topIter().getLong();
                int size2 = this.topIter().getInt();
                if (size2 < Message$.MODULE$.MinHeaderSize()) {
                    throw new InvalidMessageException(new StringBuilder().append((Object)"Message found with corrupt size (").append((Object)BoxesRunTime.boxToInteger((int)size2)).append((Object)")").toString());
                }
                if (this.topIter().remaining() < size2) {
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer message = this.topIter().slice();
                message.limit(size2);
                this.topIter().position(this.topIter().position() + size2);
                Message newMessage = new Message(message);
                if (this.isShallow$1) {
                    messageAndOffset = new MessageAndOffset(newMessage, offset);
                } else {
                    CompressionCodec compressionCodec = newMessage.compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    if (!(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null)) {
                        this.innerIter_$eq(null);
                        messageAndOffset = new MessageAndOffset(newMessage, offset);
                    } else {
                        ByteBufferMessageSet qual$1 = ByteBufferMessageSet$.MODULE$.decompress(newMessage);
                        boolean x$3 = qual$1.kafka$message$ByteBufferMessageSet$$internalIterator$default$1();
                        this.innerIter_$eq(qual$1.kafka$message$ByteBufferMessageSet$$internalIterator(x$3));
                        if (!this.innerIter().hasNext()) {
                            this.innerIter_$eq(null);
                        }
                        messageAndOffset = this.makeNext();
                    }
                }
                return messageAndOffset;
            }

            public MessageAndOffset makeNext() {
                return this.isShallow$1 ? this.makeNextOuter() : (this.innerDone() ? this.makeNextOuter() : (MessageAndOffset)this.innerIter().next());
            }
            {
                this.isShallow$1 = bl;
                this.topIter = $outer.buffer().slice();
                this.innerIter = null;
            }
        };
    }

    public final boolean kafka$message$ByteBufferMessageSet$$internalIterator$default$1() {
        return false;
    }

    public ByteBufferMessageSet assignOffsets(AtomicLong offsetCounter, CompressionCodec codec) {
        ByteBufferMessageSet byteBufferMessageSet;
        CompressionCodec compressionCodec = codec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            this.buffer().mark();
            for (int position = 0; position < this.sizeInBytes() - MessageSet$.MODULE$.LogOverhead(); position += MessageSet$.MODULE$.LogOverhead() + this.buffer().getInt()) {
                this.buffer().position(position);
                this.buffer().putLong(offsetCounter.getAndIncrement());
            }
            this.buffer().reset();
            byteBufferMessageSet = this;
        } else {
            Iterator messages = this.kafka$message$ByteBufferMessageSet$$internalIterator(false).map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Message apply(MessageAndOffset messageAndOffset) {
                    return messageAndOffset.message();
                }
            });
            byteBufferMessageSet = new ByteBufferMessageSet(codec, offsetCounter, (Seq<Message>)messages.toBuffer());
        }
        return byteBufferMessageSet;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer().limit();
    }

    public int validBytes() {
        return this.shallowValidBytes();
    }

    public boolean equals(Object other) {
        Object object = other;
        return object instanceof ByteBufferMessageSet ? this.buffer().equals(((ByteBufferMessageSet)object).buffer()) : false;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public ByteBufferMessageSet(ByteBuffer buffer) {
        this.buffer = buffer;
        Logging$class.$init$(this);
        this.shallowValidByteCount = -1;
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(new AtomicLong(0L), compressionCodec, messages));
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, AtomicLong offsetCounter, Seq<Message> messages) {
        this(ByteBufferMessageSet$.MODULE$.kafka$message$ByteBufferMessageSet$$create(offsetCounter, compressionCodec, messages));
    }

    public ByteBufferMessageSet(Seq<Message> messages) {
        this(NoCompressionCodec$.MODULE$, new AtomicLong(0L), messages);
    }
}

