/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.api.FetchRequest;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.cluster.Replica;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.network.RequestChannel;
import kafka.server.DelayedFetch$;
import kafka.server.DelayedRequest;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionDataAndOffset;
import kafka.server.ReplicaManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u000f\taA)\u001a7bs\u0016$g)\u001a;dQ*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003\u001d\u0011+G.Y=fIJ+\u0017/^3tiB\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\tY1kY1mC>\u0013'.Z2u\u0011!\u0019\u0002A!b\u0001\n\u0003\"\u0012\u0001B6fsN,\u0012!\u0006\t\u0004-eYR\"A\f\u000b\u0005aq\u0011AC2pY2,7\r^5p]&\u0011!d\u0006\u0002\u0004'\u0016\f\bC\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0005\u0003\u0019\u0019w.\\7p]&\u0011\u0001%\b\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\"\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000b$\u0003\u0015YW-_:!\u0013\t\u0019\"\u0002\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0011'\u0003\u001d\u0011X-];fgR,\u0012a\n\t\u0003Q9r!!\u000b\u0017\u000e\u0003)R!a\u000b\u0003\u0002\u000f9,Go^8sW&\u0011QFK\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\ty\u0003GA\u0004SKF,Xm\u001d;\u000b\u00055R\u0003\"\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u00144\u0003!\u0011X-];fgR\u0004\u0013BA\u0013\u000b\u0011!)\u0004A!b\u0001\n\u00032\u0014a\u00023fY\u0006LXj]\u000b\u0002oA\u0011Q\u0002O\u0005\u0003s9\u0011A\u0001T8oO\"A1\b\u0001B\u0001B\u0003%q'\u0001\u0005eK2\f\u00170T:!\u0011!i\u0004A!b\u0001\n\u0003q\u0014!\u00024fi\u000eDW#A \u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t#\u0011aA1qS&\u0011A)\u0011\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u007f\u00051a-\u001a;dQ\u0002B\u0001\u0002\u0013\u0001\u0003\u0006\u0004%I!S\u0001\u0016a\u0006\u0014H/\u001b;j_:4U\r^2i\u001f\u001a47/\u001a;t+\u0005Q\u0005\u0003B&O7Ak\u0011\u0001\u0014\u0006\u0003\u001b^\t\u0011\"[7nkR\f'\r\\3\n\u0005=c%aA'baB\u0011\u0011\"U\u0005\u0003%\n\u0011\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011!!\u0006A!A!\u0002\u0013Q\u0015A\u00069beRLG/[8o\r\u0016$8\r[(gMN,Go\u001d\u0011\t\u000bY\u0003A\u0011A,\u0002\rqJg.\u001b;?)\u0019A\u0016LW.];B\u0011\u0011\u0002\u0001\u0005\u0006'U\u0003\r!\u0006\u0005\u0006KU\u0003\ra\n\u0005\u0006kU\u0003\ra\u000e\u0005\u0006{U\u0003\ra\u0010\u0005\u0006\u0011V\u0003\rA\u0013\u0005\u0006?\u0002!\t\u0001Y\u0001\fSN\u001c\u0016\r^5tM&,G\r\u0006\u0002bIB\u0011QBY\u0005\u0003G:\u0011qAQ8pY\u0016\fg\u000eC\u0003f=\u0002\u0007a-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0005%9\u0017B\u00015\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDQA\u001b\u0001\u0005\u0002-\fqA]3ta>tG\r\u0006\u0002m_B\u0011\u0001)\\\u0005\u0003]\u0006\u0013QBR3uG\"\u0014Vm\u001d9p]N,\u0007\"B3j\u0001\u00041\u0007")
public class DelayedFetch
extends DelayedRequest
implements ScalaObject {
    private final long delayMs;
    private final FetchRequest fetch;
    private final Map<TopicAndPartition, LogOffsetMetadata> partitionFetchOffsets;

    public Seq<TopicAndPartition> keys() {
        return super.keys();
    }

    @Override
    public RequestChannel.Request request() {
        return super.request();
    }

    @Override
    public long delayMs() {
        return this.delayMs;
    }

    public FetchRequest fetch() {
        return this.fetch;
    }

    private Map<TopicAndPartition, LogOffsetMetadata> partitionFetchOffsets() {
        return this.partitionFetchOffsets;
    }

    public boolean isSatisfied(ReplicaManager replicaManager$1) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object = new Object();
            boolean exceptionResult1 = false;
            try {
                IntRef accumulatedSize$1 = new IntRef(0);
                boolean fromFollower$1 = this.fetch().isFromFollower();
                this.partitionFetchOffsets().foreach((Function1)new Serializable(this, replicaManager$1, accumulatedSize$1, fromFollower$1, object){
                    public static final long serialVersionUID;
                    private final DelayedFetch $outer;
                    private final ReplicaManager replicaManager$1;
                    private final IntRef accumulatedSize$1;
                    private final boolean fromFollower$1;
                    private final Object nonLocalReturnKey1$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple2<TopicAndPartition, LogOffsetMetadata> tuple2) {
                        Tuple2<TopicAndPartition, LogOffsetMetadata> tuple22 = tuple2;
                        if (tuple22 == null) throw new MatchError(tuple22);
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                        LogOffsetMetadata logOffsetMetadata = (LogOffsetMetadata)tuple22._2();
                        TopicAndPartition topicAndPartition$1 = topicAndPartition;
                        LogOffsetMetadata fetchOffset = logOffsetMetadata;
                        try {
                            LogOffsetMetadata endOffset;
                            LogOffsetMetadata logOffsetMetadata2 = fetchOffset;
                            LogOffsetMetadata logOffsetMetadata3 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
                            if (!(logOffsetMetadata2 == null ? logOffsetMetadata3 != null : !((Object)logOffsetMetadata2).equals(logOffsetMetadata3))) return;
                            Replica replica = this.replicaManager$1.getLeaderReplicaIfLocal(topicAndPartition$1.topic(), topicAndPartition$1.partition());
                            LogOffsetMetadata logOffsetMetadata4 = endOffset = this.fromFollower$1 ? replica.logEndOffset() : replica.highWatermark();
                            if (endOffset.offsetOnOlderSegment(fetchOffset)) {
                                this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition$1){
                                    public static final long serialVersionUID;
                                    private final $anonfun$isSatisfied$1 $outer;
                                    private final TopicAndPartition topicAndPartition$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Satisfying fetch request %s since it is fetching later segments of partition %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().fetch(), this.topicAndPartition$1}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.topicAndPartition$1 = topicAndPartition;
                                    }
                                });
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                            }
                            if (fetchOffset.offsetOnOlderSegment(endOffset)) {
                                this.$outer.debug((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID;
                                    private final $anonfun$isSatisfied$1 $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Satisfying fetch request %s immediately since it is fetching older segments.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().fetch()}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                            }
                            if (!fetchOffset.precedes(endOffset)) return;
                            this.accumulatedSize$1.elem += endOffset.positionDiff(fetchOffset);
                            return;
                        }
                        catch (NotLeaderForPartitionException notLeaderForPartitionException) {
                            this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition$1){
                                public static final long serialVersionUID;
                                private final $anonfun$isSatisfied$1 $outer;
                                private final TopicAndPartition topicAndPartition$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Broker is no longer the leader of %s, satisfy %s immediately").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().fetch()}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topicAndPartition$1 = topicAndPartition;
                                }
                            });
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        }
                        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                            this.$outer.debug((Function0<String>)new Serializable(this, topicAndPartition$1){
                                public static final long serialVersionUID;
                                private final $anonfun$isSatisfied$1 $outer;
                                private final TopicAndPartition topicAndPartition$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Broker no longer know of %s, satisfy %s immediately").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.$outer.kafka$server$DelayedFetch$$anonfun$$$outer().fetch()}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.topicAndPartition$1 = topicAndPartition;
                                }
                            });
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        }
                    }

                    public DelayedFetch kafka$server$DelayedFetch$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.replicaManager$1 = replicaManager;
                        this.accumulatedSize$1 = intRef;
                        this.fromFollower$1 = bl;
                        this.nonLocalReturnKey1$1 = object;
                    }
                });
                exceptionResult1 = accumulatedSize$1.elem >= this.fetch().minBytes();
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                exceptionResult1 = BoxesRunTime.unboxToBoolean((Object)nonLocalReturnControl2.value());
            }
            return exceptionResult1;
        }
        throw nonLocalReturnControl2;
    }

    public FetchResponse respond(ReplicaManager replicaManager) {
        Map<TopicAndPartition, PartitionDataAndOffset> topicData = replicaManager.readMessageSets(this.fetch());
        return new FetchResponse(this.fetch().correlationId(), (Map<TopicAndPartition, FetchResponsePartitionData>)topicData.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final FetchResponsePartitionData apply(PartitionDataAndOffset partitionDataAndOffset) {
                return partitionDataAndOffset.data();
            }
        }));
    }

    public DelayedFetch(Seq<TopicAndPartition> keys, RequestChannel.Request request, long delayMs, FetchRequest fetch2, Map<TopicAndPartition, LogOffsetMetadata> partitionFetchOffsets) {
        this.delayMs = delayMs;
        this.fetch = fetch2;
        this.partitionFetchOffsets = partitionFetchOffsets;
        super(keys, request, delayMs);
    }
}

