/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.util.Dictionary;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;

@Command(scope="config", name="edit", description="Creates or edits a configuration.", detailedDescription="classpath:edit.txt")
public class EditCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="pid", description="PID of the configuration", required=true, multiValued=false)
    String pid;
    @Option(name="--force", aliases={}, description="Force the edition of this config, even if another one was under edition", required=false, multiValued=false)
    boolean force;

    protected Object doExecute() throws Exception {
        String oldPid = (String)this.session.get("ConfigCommand.PID");
        if (oldPid != null && !oldPid.equals(this.pid) && !this.force) {
            System.err.println("Another config is being edited.  Cancel / update first, or use the --force option");
            return null;
        }
        Dictionary props = this.configRepository.getConfigProperties(this.pid);
        this.session.put("ConfigCommand.PID", (Object)this.pid);
        this.session.put("ConfigCommand.Props", (Object)props);
        return null;
    }
}

