/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.osgi.service.cm.Configuration;

@Command(scope="config", name="list", description="Lists existing configurations.")
public class ListCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="query", description="Query in LDAP syntax. Example: \"(service.pid=org.apache.karaf.log)\"", required=false, multiValued=false)
    String query;

    protected Object doExecute() throws Exception {
        Configuration[] configs = this.configRepository.getConfigAdmin().listConfigurations(this.query);
        if (configs != null) {
            for (Configuration config : configs) {
                System.out.println("----------------------------------------------------------------");
                System.out.println("Pid:            " + config.getPid());
                if (config.getFactoryPid() != null) {
                    System.out.println("FactoryPid:     " + config.getFactoryPid());
                }
                System.out.println("BundleLocation: " + config.getBundleLocation());
                if (config.getProperties() == null) continue;
                System.out.println("Properties:");
                Dictionary props = config.getProperties();
                Enumeration e = props.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    System.out.println("   " + key + " = " + props.get(key));
                }
            }
        }
        return null;
    }
}

