/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.config.core.ConfigMBean;
import org.apache.karaf.config.core.ConfigRepository;
import org.osgi.service.cm.Configuration;

public class Config
extends StandardMBean
implements ConfigMBean {
    private ConfigRepository configRepo;

    public Config() throws NotCompliantMBeanException {
        super(ConfigMBean.class);
    }

    private Configuration getConfiguration(String pid) throws IOException {
        Configuration configuration = this.configRepo.getConfigAdmin().getConfiguration(pid);
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration PID " + pid + " doesn't exist");
        }
        return configuration;
    }

    private Dictionary getConfigProperties(String pid) throws IOException {
        Configuration configuration = this.getConfiguration(pid);
        Dictionary dictionary = configuration.getProperties();
        if (dictionary == null) {
            dictionary = new Properties();
        }
        return dictionary;
    }

    @Override
    public List<String> getConfigs() throws Exception {
        Configuration[] configurations = this.configRepo.getConfigAdmin().listConfigurations(null);
        ArrayList<String> pids = new ArrayList<String>();
        for (int i = 0; i < configurations.length; ++i) {
            pids.add(configurations[i].getPid());
        }
        return pids;
    }

    @Override
    public void create(String pid) throws Exception {
        this.configRepo.update(pid, new Hashtable());
    }

    @Override
    public void update(String pid, Map<String, String> properties) throws IOException {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        for (String key : properties.keySet()) {
            ((Dictionary)dictionary).put(key, properties.get(key));
        }
        this.configRepo.update(pid, dictionary);
    }

    @Override
    public void delete(String pid) throws Exception {
        this.configRepo.delete(pid);
    }

    @Override
    public Map<String, String> listProperties(String pid) throws Exception {
        Dictionary dictionary = this.getConfigProperties(pid);
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Enumeration e = dictionary.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = dictionary.get(key);
            propertiesMap.put(key.toString(), value.toString());
        }
        return propertiesMap;
    }

    @Override
    public void deleteProperty(String pid, String key) throws Exception {
        Dictionary dictionary = this.getConfigProperties(pid);
        dictionary.remove(key);
        this.configRepo.update(pid, dictionary);
    }

    @Override
    public void appendProperty(String pid, String key, String value) throws Exception {
        Dictionary dictionary = this.getConfigProperties(pid);
        Object currentValue = dictionary.get(key);
        if (currentValue == null) {
            dictionary.put(key, value);
        } else if (currentValue instanceof String) {
            dictionary.put(key, currentValue + value);
        } else {
            throw new IllegalStateException("Current value is not a String");
        }
        this.configRepo.update(pid, dictionary);
    }

    @Override
    public void setProperty(String pid, String key, String value) throws Exception {
        Dictionary dictionary = this.getConfigProperties(pid);
        dictionary.put(key, value);
        this.configRepo.update(pid, dictionary);
    }

    public void setConfigRepo(ConfigRepository configRepo) {
        this.configRepo = configRepo;
    }
}

