/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.karaf.config.core.ConfigRepository;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigRepositoryImpl
implements ConfigRepository {
    private ConfigurationAdmin configAdmin;
    private File storage;

    public ConfigRepositoryImpl(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    @Override
    public void update(String pid, Dictionary props) throws IOException {
        Configuration cfg = this.configAdmin.getConfiguration(pid, null);
        if (cfg.getBundleLocation() != null) {
            cfg.setBundleLocation(null);
        }
        cfg.update(props);
    }

    @Override
    public void delete(String pid) throws Exception {
        Configuration configuration = this.configAdmin.getConfiguration(pid);
        configuration.delete();
        this.deleteStorage(pid);
    }

    protected void deleteStorage(String pid) throws Exception {
        if (this.storage != null) {
            File cfgFile = new File(this.storage, pid + ".cfg");
            cfgFile.delete();
        }
    }

    @Override
    public Dictionary getConfigProperties(String pid) throws IOException, InvalidSyntaxException {
        Configuration configuration;
        if (pid != null && this.configAdmin != null && (configuration = this.configAdmin.getConfiguration(pid)) != null) {
            Dictionary props = configuration.getProperties();
            return props != null ? props : new Hashtable();
        }
        return null;
    }

    @Override
    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    @Override
    public String createFactoryConfiguration(String factoryPid, Dictionary<String, ?> properties) {
        try {
            Configuration config = this.configAdmin.createFactoryConfiguration(factoryPid);
            config.update(properties);
            return config.getPid();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

