/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.config.discovery;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.ClientConfig;
import io.searchbox.cluster.NodesInfo;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeChecker
extends AbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(NodeChecker.class);
    private static final String PUBLISH_ADDRESS_KEY = "http_address";
    private static final Pattern INETSOCKETADDRESS_PATTERN = Pattern.compile("(?:inet\\[)?(?:(?:[^:]+)?\\/)?([^:]+):(\\d+)\\]?");
    private final NodesInfo action = new NodesInfo.Builder().withHttp().build();
    protected JestClient client;
    protected AbstractScheduledService.Scheduler scheduler;
    protected String defaultScheme;
    protected Set<String> bootstrapServerList;

    public NodeChecker(JestClient jestClient, ClientConfig clientConfig) {
        this(jestClient, clientConfig.getDefaultSchemeForDiscoveredNodes(), clientConfig.getDiscoveryFrequency(), clientConfig.getDiscoveryFrequencyTimeUnit(), clientConfig.getServerList());
    }

    public NodeChecker(JestClient jestClient, String defaultScheme, Long discoveryFrequency, TimeUnit discoveryFrequencyTimeUnit, Set<String> servers) {
        this.client = jestClient;
        this.defaultScheme = defaultScheme;
        this.scheduler = AbstractScheduledService.Scheduler.newFixedDelaySchedule(0L, discoveryFrequency, discoveryFrequencyTimeUnit);
        this.bootstrapServerList = ImmutableSet.copyOf(servers);
    }

    @Override
    protected void runOneIteration() throws Exception {
        JestResult result;
        try {
            result = this.client.execute(this.action);
        }
        catch (Exception e) {
            log.error("Error executing NodesInfo!", (Throwable)e);
            this.client.setServers(this.bootstrapServerList);
            return;
        }
        if (result.isSucceeded()) {
            LinkedHashSet<String> httpHosts = new LinkedHashSet<String>();
            JsonObject jsonMap = result.getJsonObject();
            JsonObject nodes = (JsonObject)jsonMap.get("nodes");
            if (nodes != null) {
                for (Map.Entry<String, JsonElement> entry : nodes.entrySet()) {
                    String httpAddress;
                    JsonElement addressElement;
                    JsonObject host = entry.getValue().getAsJsonObject();
                    if (!host.has(PUBLISH_ADDRESS_KEY) || (addressElement = host.get(PUBLISH_ADDRESS_KEY)).isJsonNull() || (httpAddress = this.getHttpAddress(addressElement.getAsString())) == null) continue;
                    httpHosts.add(httpAddress);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Discovered {} HTTP hosts: {}", (Object)httpHosts.size(), (Object)StringUtils.join(httpHosts, ","));
            }
            this.client.setServers(httpHosts);
        } else {
            log.warn("NodesInfo request resulted in error: {}", (Object)result.getErrorMessage());
            this.client.setServers(this.bootstrapServerList);
        }
    }

    @Override
    protected AbstractScheduledService.Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    protected ScheduledExecutorService executor() {
        final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.serviceName()).build());
        this.addListener(new Service.Listener(){

            @Override
            public void terminated(Service.State from) {
                executor.shutdown();
            }

            @Override
            public void failed(Service.State from, Throwable failure) {
                executor.shutdown();
            }
        }, MoreExecutors.directExecutor());
        return executor;
    }

    protected String getHttpAddress(String httpAddress) {
        Matcher resolvedMatcher = INETSOCKETADDRESS_PATTERN.matcher(httpAddress);
        if (resolvedMatcher.matches()) {
            return this.defaultScheme + resolvedMatcher.group(1) + ":" + resolvedMatcher.group(2);
        }
        return null;
    }
}

