/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.MetricAggregation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class PercentilesAggregation
extends MetricAggregation {
    public static final String TYPE = "percentiles";
    private Map<String, Double> percentiles = new HashMap<String, Double>();

    public PercentilesAggregation(String name, JsonObject percentilesAggregation) {
        super(name, percentilesAggregation);
        this.parseSource(percentilesAggregation.getAsJsonObject(String.valueOf((Object)AggregationField.VALUES)));
    }

    private void parseSource(JsonObject source) {
        for (Map.Entry<String, JsonElement> entry : source.entrySet()) {
            if (Double.isNaN(entry.getValue().getAsDouble())) continue;
            this.percentiles.put(entry.getKey(), entry.getValue().getAsDouble());
        }
    }

    public Map<String, Double> getPercentiles() {
        return this.percentiles;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PercentilesAggregation rhs = (PercentilesAggregation)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.percentiles, rhs.percentiles).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.percentiles).toHashCode();
    }
}

