/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.providers;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.diagnostic.core.common.TextDumpProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleDumpProvider
extends TextDumpProvider {
    private static Map<Integer, String> stateMap = new HashMap<Integer, String>();
    private BundleContext bundleContext;

    public BundleDumpProvider(BundleContext context) {
        super("bundles.txt");
        this.bundleContext = context;
    }

    protected void writeDump(OutputStreamWriter writer) throws IOException {
        Bundle[] bundles = this.bundleContext.getBundles();
        writer.write("Number of installed bundles " + bundles.length + "\n");
        writer.write("Id\tSymbolic name\tVersion\tState\n");
        for (Bundle bundle : bundles) {
            writer.write(bundle.getBundleId() + "\t" + bundle.getSymbolicName() + '\t' + bundle.getVersion() + "\t" + stateMap.get(bundle.getState()) + "\n");
        }
        writer.flush();
    }

    static {
        stateMap.put(1, "UNINSTALLED");
        stateMap.put(2, "INSTALLED");
        stateMap.put(4, "RESOLVED");
        stateMap.put(8, "STARTING");
        stateMap.put(16, "STOPPING");
        stateMap.put(32, "ACTIVE");
    }
}

