/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.diagnostic.core.DumpProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapDumpProvider
implements DumpProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeapDumpProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDump(DumpDestination destination) throws Exception {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Class<?> diagnosticMXBeanClass = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Object diagnosticMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServer, "com.sun.management:type=HotSpotDiagnostic", diagnosticMXBeanClass);
            Method method = diagnosticMXBeanClass.getMethod("dumpHeap", String.class, Boolean.TYPE);
            method.invoke(diagnosticMXBean, "heapdump.txt", false);
            File heapDumpFile = new File("heapdump.txt");
            in = new FileInputStream(heapDumpFile);
            out = destination.add("heapdump.txt");
            byte[] buffer = new byte[2048];
            while (in.read(buffer) != -1) {
                out.write(buffer);
            }
            if (heapDumpFile.exists()) {
                heapDumpFile.delete();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't create heapdump", (Throwable)e);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

