/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.karaf.diagnostic.core.DumpDestination;
import org.apache.karaf.diagnostic.core.DumpProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class LogDumpProvider
implements DumpProvider {
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void createDump(DumpDestination destination) throws Exception {
        ServiceReference ref = this.bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (ref == null) {
            return;
        }
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(ref);
        try {
            Configuration configuration = configurationAdmin.getConfiguration("org.ops4j.pax.logging", null);
            Dictionary dictionary = configuration.getProperties();
            Enumeration e = dictionary.keys();
            while (e.hasMoreElements()) {
                String location;
                File file;
                String property = (String)e.nextElement();
                if (!property.endsWith(".file") || !(file = new File(location = (String)dictionary.get(property))).exists()) continue;
                FileInputStream inputStream = new FileInputStream(file);
                OutputStream outputStream = destination.add("log/" + file.getName());
                this.copy(inputStream, outputStream);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
        }
    }
}

