/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.instance.command;

import java.util.List;
import org.apache.karaf.instance.command.InstanceCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;

@Command(scope="instance", name="connect", description="Connects to an existing container instance.")
public class ConnectCommand
extends InstanceCommandSupport {
    @Option(name="-u", aliases={"--username"}, description="Remote user name", required=false, multiValued=false)
    private String username;
    @Argument(index=0, name="name", description="The name of the container instance", required=true, multiValued=false)
    private String instance = null;
    @Argument(index=1, name="command", description="Optional command to execute", required=false, multiValued=true)
    private List<String> command;

    protected Object doExecute() throws Exception {
        String cmdStr = "";
        if (this.command != null) {
            StringBuilder sb = new StringBuilder();
            for (String cmd : this.command) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(cmd);
            }
            cmdStr = "'" + sb.toString().replaceAll("'", "\\'") + "'";
        }
        int port = this.getExistingInstance(this.instance).getSshPort();
        if (this.username != null) {
            this.session.execute((CharSequence)("ssh -l " + this.username + " -p " + port + " localhost " + cmdStr));
        } else {
            this.session.execute((CharSequence)("ssh -p " + port + " localhost " + cmdStr));
        }
        return null;
    }
}

