/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;

@Command(scope="jdbc", name="create", description="Create a JDBC datasource")
public class CreateCommand
extends JdbcCommandSupport {
    @Argument(index=0, name="name", description="The JDBC datasource name", required=true, multiValued=false)
    String name;
    @Option(name="-t", aliases={"--type"}, description="The JDBC datasource type (generic, MySQL, MSSQL, Oracle, Postgres, H2, HSQL, Derby)", required=false, multiValued=false)
    String type;
    @Option(name="-d", aliases={"--driver"}, description="The classname of the JDBC driver to use. NB: this option is used only the type generic", required=false, multiValued=false)
    String driver;
    @Option(name="-v", aliases={"--version"}, description="The version of the driver to use", required=false, multiValued=false)
    String version;
    @Option(name="-url", description="The JDBC URL to use", required=false, multiValued=false)
    String url;
    @Option(name="-u", aliases={"--username"}, description="The database username", required=false, multiValued=false)
    String username;
    @Option(name="-p", aliases={"--password"}, description="The database password", required=false, multiValued=false)
    String password;
    @Option(name="-i", aliases={"--install-bundles"}, description="Try to install the bundles providing the JDBC driver", required=false, multiValued=false)
    boolean installBundles = false;

    public Object doExecute() throws Exception {
        this.getJdbcService().create(this.name, this.type, this.driver, this.version, this.url, this.username, this.password, this.installBundles);
        return null;
    }
}

