/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command;

import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;

@Command(scope="jdbc", name="datasources", description="List the JDBC datasources")
public class DataSourcesCommand
extends JdbcCommandSupport {
    private static final String JDBC_DATASOURCES_STRING_FORMAT = "%10s %15s %10s %45s %5s";

    public Object doExecute() throws Exception {
        System.out.println(String.format(JDBC_DATASOURCES_STRING_FORMAT, "Name", "Product", "Version", "URL", "Status"));
        List datasources = this.getJdbcService().datasources();
        for (String datasource : datasources) {
            try {
                Map info = this.getJdbcService().info(datasource);
                System.out.println(String.format(JDBC_DATASOURCES_STRING_FORMAT, datasource, info.get("db.product"), info.get("db.version"), info.get("url"), "OK"));
            }
            catch (Exception e) {
                System.out.println(String.format(JDBC_DATASOURCES_STRING_FORMAT, datasource, "", "", "", "Error"));
            }
        }
        return null;
    }
}

