/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command.ds;

import java.util.Collection;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;

@Command(scope="jdbc", name="ds-factories", description="List the JDBC DataSourceFactories")
@Service
public class DSFactoriesCommand
extends JdbcCommandSupport {
    @Reference
    BundleContext context;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Class");
        table.column("Version");
        Collection refs = this.context.getServiceReferences(DataSourceFactory.class, null);
        for (ServiceReference ref : refs) {
            String driverName = (String)ref.getProperty("osgi.jdbc.driver.name");
            String driverClass = (String)ref.getProperty("osgi.jdbc.driver.class");
            String driverVersion = (String)ref.getProperty("osgi.jdbc.driver.version");
            table.addRow().addContent(new Object[]{driverName, driverClass, driverVersion});
        }
        table.print(System.out);
        return null;
    }
}

