/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command.ds;

import java.util.List;
import java.util.Map;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="jdbc", name="ds-list", description="List the JDBC datasources")
@Service
public class ListCommand
extends JdbcCommandSupport {
    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Product");
        table.column("Version");
        table.column("URL");
        table.column("Status");
        List<String> datasources = this.getJdbcService().datasources();
        for (String dsName : datasources) {
            try {
                Map<String, String> info = this.getJdbcService().info(dsName);
                table.addRow().addContent(new Object[]{dsName, info.get("db.product"), info.get("db.version"), info.get("url"), "OK"});
            }
            catch (Exception e) {
                table.addRow().addContent(new Object[]{dsName, "", "", "", "Error " + e.getMessage()});
            }
        }
        table.print(System.out);
        return null;
    }
}

