/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.internal;

import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.jdbc.JdbcMBean;
import org.apache.karaf.jdbc.JdbcService;

public class JdbcMBeanImpl
implements JdbcMBean {
    private JdbcService jdbcService;

    @Override
    public TabularData getDatasources() throws MBeanException {
        try {
            CompositeType type = new CompositeType("DataSource", "JDBC DataSource", new String[]{"name", "product", "version", "url", "status"}, new String[]{"Name", "Database product", "Database version", "JDBC URL", "Status"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
            TabularType tableType = new TabularType("JDBC DataSources", "Table of the JDBC DataSources", type, new String[]{"name"});
            TabularDataSupport table = new TabularDataSupport(tableType);
            for (String datasource : this.jdbcService.datasources()) {
                CompositeDataSupport data;
                try {
                    Map<String, String> info = this.jdbcService.info(datasource);
                    data = new CompositeDataSupport(type, new String[]{"name", "product", "version", "url", "status"}, new Object[]{datasource, info.get("db.product"), info.get("db.version"), info.get("url"), "OK"});
                    table.put(data);
                }
                catch (Exception e) {
                    data = new CompositeDataSupport(type, new String[]{"name", "product", "version", "url", "status"}, new Object[]{datasource, "", "", "", "ERROR"});
                    table.put(data);
                }
            }
            return table;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void create(String name, String driverName, String driverClass, String databaseName, String url, String user, String password) throws MBeanException {
        try {
            this.jdbcService.create(name, driverName, driverClass, databaseName, url, user, password);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void delete(String name) throws MBeanException {
        try {
            this.jdbcService.delete(name);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public Map<String, String> info(String datasource) throws MBeanException {
        try {
            return this.jdbcService.info(datasource);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public TabularData tables(String datasource) throws MBeanException {
        try {
            Map<String, List<String>> result = this.jdbcService.tables(datasource);
            OpenType[] stringTypes = new OpenType[result.keySet().size()];
            for (int i = 0; i < stringTypes.length; ++i) {
                stringTypes[i] = SimpleType.STRING;
            }
            String[] columns = result.keySet().toArray(new String[result.keySet().size()]);
            CompositeType type = new CompositeType("Columns", "Columns", columns, columns, stringTypes);
            TabularType rows = new TabularType("Result", "Result Rows", type, columns);
            TabularDataSupport table = new TabularDataSupport(rows);
            int rowCount = result.get(result.keySet().iterator().next()).size();
            for (int i = 0; i < rowCount; ++i) {
                Object[] row = new Object[columns.length];
                for (int j = 0; j < columns.length; ++j) {
                    row[j] = result.get(columns[j]).get(i);
                }
                CompositeDataSupport data = new CompositeDataSupport(type, columns, row);
                table.put(data);
            }
            return table;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void execute(String datasource, String command) throws MBeanException {
        try {
            this.jdbcService.execute(datasource, command);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public TabularData query(String datasource, String query) throws MBeanException {
        try {
            Map<String, List<String>> result = this.jdbcService.query(datasource, query);
            OpenType[] stringTypes = new OpenType[result.keySet().size()];
            for (int i = 0; i < stringTypes.length; ++i) {
                stringTypes[i] = SimpleType.STRING;
            }
            String[] columns = result.keySet().toArray(new String[result.keySet().size()]);
            CompositeType type = new CompositeType("Columns", "Columns", columns, columns, stringTypes);
            TabularType rows = new TabularType("Result", "Result Rows", type, columns);
            TabularDataSupport table = new TabularDataSupport(rows);
            int rowCount = result.get(result.keySet().iterator().next()).size();
            for (int i = 0; i < rowCount; ++i) {
                Object[] row = new Object[columns.length];
                for (int j = 0; j < columns.length; ++j) {
                    row[j] = result.get(columns[j]).get(i);
                }
                CompositeDataSupport data = new CompositeDataSupport(type, columns, row);
                table.put(data);
            }
            return table;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    public JdbcService getJdbcService() {
        return this.jdbcService;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }
}

