/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.internal;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.karaf.jdbc.JdbcService;
import org.apache.karaf.jdbc.internal.JdbcConnector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcServiceImpl
implements JdbcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcServiceImpl.class);
    private BundleContext bundleContext;
    private ConfigurationAdmin configAdmin;

    @Override
    public void create(String name, String driverName, String driverClass, String databaseName, String url, String user, String password) throws Exception {
        if (driverName == null && driverClass == null) {
            throw new IllegalStateException("No driverName or driverClass supplied");
        }
        if (this.datasources().contains(name)) {
            throw new IllegalArgumentException("There is already a DataSource with the name " + name);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("dataSourceName", name);
        if (driverName != null) {
            ((Dictionary)properties).put("osgi.jdbc.driver.name", driverName);
        }
        if (driverClass != null) {
            ((Dictionary)properties).put("osgi.jdbc.driver.class", driverClass);
        }
        if (databaseName != null) {
            ((Dictionary)properties).put("databaseName", databaseName);
        }
        if (url != null) {
            ((Dictionary)properties).put("url", url);
        }
        if (user != null) {
            ((Dictionary)properties).put("user", user);
        }
        if (password != null) {
            ((Dictionary)properties).put("password", password);
        }
        Configuration config = this.configAdmin.createFactoryConfiguration("org.ops4j.datasource", null);
        config.update(properties);
    }

    @Override
    public void delete(String name) throws Exception {
        Configuration[] configs;
        String filter = String.format("(%s=%s)", "dataSourceName", name);
        for (Configuration config : configs = this.configAdmin.listConfigurations(filter)) {
            config.delete();
        }
    }

    @Override
    public List<String> datasources() throws Exception {
        ArrayList<String> datasources = new ArrayList<String>();
        Collection references = this.bundleContext.getServiceReferences(DataSource.class, null);
        if (references == null) {
            return datasources;
        }
        for (ServiceReference reference : references) {
            String dsName = (String)reference.getProperty("dataSourceName");
            if (dsName == null) continue;
            datasources.add(dsName);
        }
        return datasources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> query(String datasource, String query) throws Exception {
        try (JdbcConnector jdbcConnector = new JdbcConnector(this.bundleContext, this.lookupDataSource(datasource));){
            int c;
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            Statement statement = jdbcConnector.createStatement();
            ResultSet resultSet = jdbcConnector.register(statement.executeQuery(query));
            ResultSetMetaData metaData = resultSet.getMetaData();
            for (c = 1; c <= metaData.getColumnCount(); ++c) {
                map.put(metaData.getColumnLabel(c), new ArrayList());
            }
            while (resultSet.next()) {
                for (c = 1; c <= metaData.getColumnCount(); ++c) {
                    ((List)map.get(metaData.getColumnLabel(c))).add(resultSet.getString(c));
                }
            }
            HashMap<String, List<String>> hashMap = map;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String datasource, String command) throws Exception {
        try (JdbcConnector jdbcConnector = new JdbcConnector(this.bundleContext, this.lookupDataSource(datasource));){
            jdbcConnector.createStatement().execute(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> tables(String datasource) throws Exception {
        try (JdbcConnector jdbcConnector = new JdbcConnector(this.bundleContext, this.lookupDataSource(datasource));){
            int c;
            DatabaseMetaData dbMetaData = jdbcConnector.connect().getMetaData();
            ResultSet resultSet = jdbcConnector.register(dbMetaData.getTables(null, null, null, null));
            ResultSetMetaData metaData = resultSet.getMetaData();
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            for (c = 1; c <= metaData.getColumnCount(); ++c) {
                map.put(metaData.getColumnLabel(c), new ArrayList());
            }
            while (resultSet.next()) {
                for (c = 1; c <= metaData.getColumnCount(); ++c) {
                    ((List)map.get(metaData.getColumnLabel(c))).add(resultSet.getString(c));
                }
            }
            HashMap<String, List<String>> hashMap = map;
            return hashMap;
        }
    }

    @Override
    public Map<String, String> info(String datasource) throws Exception {
        try (JdbcConnector jdbcConnector = new JdbcConnector(this.bundleContext, this.lookupDataSource(datasource));){
            DatabaseMetaData dbMetaData = jdbcConnector.connect().getMetaData();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("db.product", dbMetaData.getDatabaseProductName());
            map.put("db.version", dbMetaData.getDatabaseProductVersion());
            map.put("url", dbMetaData.getURL());
            map.put("username", dbMetaData.getUserName());
            map.put("driver.name", dbMetaData.getDriverName());
            map.put("driver.version", dbMetaData.getDriverVersion());
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
    }

    private ServiceReference<?> lookupDataSource(String name) {
        Object[] references;
        try {
            references = this.bundleContext.getServiceReferences((String)null, "(&(|(objectClass=" + DataSource.class.getName() + ")" + "(" + "objectClass" + "=" + XADataSource.class.getName() + "))" + "(|(osgi.jndi.service.name=" + name + ")(datasource=" + name + ")(name=" + name + ")(service.id=" + name + ")))");
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Error finding datasource with name " + name, e);
        }
        if (references == null || references.length == 0) {
            throw new IllegalArgumentException("No JDBC datasource found for " + name);
        }
        if (references.length > 1) {
            Arrays.sort(references);
            if (this.getRank((ServiceReference<?>)references[references.length - 1]) == this.getRank((ServiceReference<?>)references[references.length - 2])) {
                LOGGER.warn("Multiple JDBC datasources found with the same service ranking for " + name);
            }
        }
        return references[references.length - 1];
    }

    private int getRank(ServiceReference<?> reference) {
        Object rankObj = reference.getProperty("service.ranking");
        rankObj = rankObj == null ? new Integer(0) : rankObj;
        return rankObj instanceof Integer ? (Integer)rankObj : 0;
    }

    @Override
    public List<String> factoryNames() throws Exception {
        ArrayList<String> factories = new ArrayList<String>();
        Collection references = this.bundleContext.getServiceReferences(DataSourceFactory.class, null);
        if (references == null) {
            return factories;
        }
        for (ServiceReference reference : references) {
            String driverName = (String)reference.getProperty("osgi.jdbc.driver.name");
            if (driverName == null) continue;
            factories.add(driverName);
        }
        return factories;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

