/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jndi.command;

import java.util.List;
import org.apache.karaf.jndi.JndiService;
import org.apache.karaf.jndi.command.completers.ContextsCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="jndi", name="contexts", description="List the JNDI sub-contexts.")
@Service
public class ContextsCommand
implements Action {
    @Argument(index=0, name="context", description="The base JNDI context", required=false, multiValued=false)
    @Completion(value=ContextsCompleter.class)
    String context;
    @Reference
    JndiService jndiService;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("JNDI Sub-Context");
        List<String> contexts = this.context == null ? this.jndiService.contexts() : this.jndiService.contexts(this.context);
        for (String c : contexts) {
            table.addRow().addContent(new Object[]{c});
        }
        table.print(System.out);
        return null;
    }
}

