/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.obr.command;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.karaf.obr.command.ObrCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;

@Command(scope="obr", name="info", description="Prints information about OBR bundles.")
public class InfoCommand
extends ObrCommandSupport {
    @Argument(index=0, name="bundles", description="Specify bundles to query for information (separated by whitespaces)", required=true, multiValued=true)
    List<String> bundles;

    @Override
    protected void doExecute(RepositoryAdmin admin) throws Exception {
        for (String bundle : this.bundles) {
            String[] target = this.getTarget(bundle);
            Resource[] resources = this.searchRepository(admin, target[0], target[1]);
            if (resources == null) {
                System.err.println("Unknown bundle and/or version: " + target[0]);
                continue;
            }
            for (int resIdx = 0; resIdx < resources.length; ++resIdx) {
                if (resIdx > 0) {
                    System.out.println("");
                }
                this.printResource(System.out, resources[resIdx]);
            }
        }
    }

    private void printResource(PrintStream out, Resource resource) {
        Capability[] caps;
        this.printUnderline(out, resource.getPresentationName().length());
        out.println(resource.getPresentationName());
        this.printUnderline(out, resource.getPresentationName().length());
        Map map = resource.getProperties();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue().getClass().isArray()) {
                out.println(entry.getKey() + ":");
                for (int j = 0; j < Array.getLength(entry.getValue()); ++j) {
                    out.println("   " + Array.get(entry.getValue(), j));
                }
                continue;
            }
            out.println(entry.getKey() + ": " + entry.getValue());
        }
        Requirement[] reqs = resource.getRequirements();
        if (reqs != null && reqs.length > 0) {
            out.println("Requires:");
            for (int i = 0; i < reqs.length; ++i) {
                out.println("   " + reqs[i].getName() + ":" + reqs[i].getFilter());
            }
        }
        if ((caps = resource.getCapabilities()) != null && caps.length > 0) {
            out.println("Capabilities:");
            for (int i = 0; i < caps.length; ++i) {
                out.println("   " + caps[i].getName() + ":" + caps[i].getPropertiesAsMap());
            }
        }
    }
}

