/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.obr.command;

import java.util.List;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.Action;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="obr", name="list", description="Lists OBR bundles, optionally providing the given packages.")
public class ListCommand
implements Action {
    @Argument(index=0, name="packages", description="A list of packages separated by whitespaces.", required=false, multiValued=true)
    List<String> packages;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;
    RepositoryAdmin repoAdmin;

    public void setRepoAdmin(RepositoryAdmin repoAdmin) {
        this.repoAdmin = repoAdmin;
    }

    public Object execute(CommandSession session) throws Exception {
        StringBuilder substr = new StringBuilder();
        if (this.packages != null) {
            for (String packageName : this.packages) {
                substr.append(" ");
                substr.append(packageName);
            }
        }
        String query = substr == null || substr.length() == 0 ? "(|(presentationname=*)(symbolicname=*))" : "(|(presentationname=*" + substr + "*)(symbolicname=*" + substr + "*))";
        Resource[] resources = this.repoAdmin.discoverResources(query);
        int maxPName = 4;
        int maxSName = 13;
        int maxVersion = 7;
        for (Resource resource : resources) {
            maxPName = Math.max(maxPName, this.emptyIfNull(resource.getPresentationName()).length());
            maxSName = Math.max(maxSName, this.emptyIfNull(resource.getSymbolicName()).length());
            maxVersion = Math.max(maxVersion, this.emptyIfNull(resource.getVersion()).length());
        }
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Symbolic Name");
        table.column("Version");
        table.emptyTableText("No matching bundles");
        for (Resource resource : resources) {
            table.addRow().addContent(new Object[]{this.emptyIfNull(resource.getPresentationName()), this.emptyIfNull(resource.getSymbolicName()), this.emptyIfNull(resource.getVersion())});
        }
        table.print(System.out, !this.noFormat);
        return null;
    }

    private String emptyIfNull(Object st) {
        return st == null ? "" : st.toString();
    }
}

