/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.obr.core.internal;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.karaf.obr.core.ObrMBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class ObrMBeanImpl
extends StandardMBean
implements ObrMBean {
    private static final char VERSION_DELIM = ',';
    private BundleContext bundleContext;
    private RepositoryAdmin repositoryAdmin;

    public ObrMBeanImpl(BundleContext bundleContext, RepositoryAdmin repositoryAdmin) throws NotCompliantMBeanException {
        super(ObrMBean.class);
        this.bundleContext = bundleContext;
        this.repositoryAdmin = repositoryAdmin;
    }

    @Override
    public List<String> getUrls() {
        Repository[] repositories = this.repositoryAdmin.listRepositories();
        ArrayList<String> urls = new ArrayList<String>();
        for (int i = 0; i < repositories.length; ++i) {
            urls.add(repositories[i].getURI());
        }
        return urls;
    }

    @Override
    public TabularData getBundles() throws MBeanException {
        try {
            CompositeType bundleType = new CompositeType("OBR Resource", "Bundle available in the OBR", new String[]{"presentationname", "symbolicname", "version"}, new String[]{"Presentation Name", "Symbolic Name", "Version"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
            TabularType tableType = new TabularType("OBR Resources", "Table of all resources/bundles available in the OBR", bundleType, new String[]{"symbolicname", "version"});
            TabularDataSupport table = new TabularDataSupport(tableType);
            Resource[] resources = this.repositoryAdmin.discoverResources("(|(presentationname=*)(symbolicname=*))");
            for (int i = 0; i < resources.length; ++i) {
                try {
                    CompositeDataSupport data = new CompositeDataSupport(bundleType, new String[]{"presentationname", "symbolicname", "version"}, new Object[]{resources[i].getPresentationName(), resources[i].getSymbolicName(), resources[i].getVersion().toString()});
                    table.put(data);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return table;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void addUrl(String url) throws MBeanException {
        try {
            this.repositoryAdmin.addRepository(url);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void removeUrl(String url) {
        this.repositoryAdmin.removeRepository(url);
    }

    @Override
    public void refreshUrl(String url) throws MBeanException {
        try {
            this.repositoryAdmin.addRepository(url);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void deployBundle(String bundle) throws MBeanException {
        try {
            this.deployBundle(bundle, false, false);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.getMessage());
        }
    }

    @Override
    public void deployBundle(String bundle, boolean start, boolean deployOptional) throws MBeanException {
        block5: {
            try {
                Resolver resolver = this.repositoryAdmin.resolver();
                String[] target = this.getTarget(bundle);
                Resource resource = this.selectNewestVersion(this.searchRepository(this.repositoryAdmin, target[0], target[1]));
                if (resource == null) {
                    throw new IllegalArgumentException("Unknown bundle " + target[0]);
                }
                resolver.add(resource);
                if (resolver.getAddedResources() == null || resolver.getAddedResources().length <= 0 || !resolver.resolve(deployOptional ? 0 : 1)) break block5;
                try {
                    resolver.deploy(start ? 16 : 0);
                }
                catch (IllegalStateException ex) {
                    throw new IllegalStateException("Can't deploy using OBR", ex);
                }
            }
            catch (Exception e) {
                throw new MBeanException(null, e.getMessage());
            }
        }
    }

    private Resource[] searchRepository(RepositoryAdmin admin, String targetId, String targetVersion) throws InvalidSyntaxException {
        try {
            Bundle bundle = this.bundleContext.getBundle(Long.parseLong(targetId));
            targetId = bundle.getSymbolicName();
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer("(|(presentationname=");
        sb.append(targetId);
        sb.append(")(symbolicname=");
        sb.append(targetId);
        sb.append("))");
        if (targetVersion != null) {
            sb.insert(0, "(&");
            sb.append("(version=");
            sb.append(targetVersion);
            sb.append("))");
        }
        return admin.discoverResources(sb.toString());
    }

    private Resource selectNewestVersion(Resource[] resources) {
        int idx = -1;
        Version v = null;
        for (int i = 0; resources != null && i < resources.length; ++i) {
            if (i == 0) {
                idx = 0;
                v = resources[i].getVersion();
                continue;
            }
            Version vtmp = resources[i].getVersion();
            if (vtmp.compareTo(v) <= 0) continue;
            idx = i;
            v = vtmp;
        }
        return idx < 0 ? null : resources[idx];
    }

    private String[] getTarget(String bundle) {
        int idx = bundle.indexOf(44);
        String[] target = idx > 0 ? new String[]{bundle.substring(0, idx), bundle.substring(idx + 1)} : new String[]{bundle, null};
        return target;
    }
}

