/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.obr.command;

import java.util.List;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.karaf.obr.command.ObrCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="obr", name="url-refresh", description="Reloads the repositories to obtain a fresh list of bundles.")
@Service
public class RefreshUrlCommand
extends ObrCommandSupport {
    @Option(name="-i", aliases={"--index"}, description="Use index to identify URL", required=false, multiValued=false)
    boolean useIndex;
    @Argument(index=0, name="ids", description="Repository URLs (or indexes if you use -i) to refresh (leave empty for all)", required=false, multiValued=true)
    List<String> ids;

    @Override
    protected void doExecute(RepositoryAdmin admin) throws Exception {
        block5: {
            block4: {
                if (this.ids == null || this.ids.isEmpty()) break block4;
                for (String id : this.ids) {
                    if (this.useIndex) {
                        Repository[] repos = admin.listRepositories();
                        int index = Integer.parseInt(id);
                        if (index >= 0 && index < repos.length) {
                            admin.addRepository(repos[index].getURI());
                            continue;
                        }
                        System.err.println("Invalid index");
                        continue;
                    }
                    admin.addRepository(id);
                }
                break block5;
            }
            Repository[] repos = admin.listRepositories();
            if (repos == null || repos.length <= 0) break block5;
            for (int i = 0; i < repos.length; ++i) {
                admin.addRepository(repos[i].getURI());
            }
        }
    }
}

