/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.client;

public class ClientConfig {
    private String host = "localhost";
    private int port = 8101;
    private String user = "karaf";
    private int level = 1;
    private int retryAttempts = 0;
    private int retryDelay = 2;
    private boolean batch = false;
    private String file = null;
    private String command;

    public ClientConfig(String[] args) {
        StringBuilder commandBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                if (args[i].equals("-a")) {
                    this.port = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-h")) {
                    this.host = args[++i];
                    continue;
                }
                if (args[i].equals("-u")) {
                    this.user = args[++i];
                    continue;
                }
                if (args[i].equals("-v")) {
                    ++this.level;
                    continue;
                }
                if (args[i].equals("-r")) {
                    this.retryAttempts = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-d")) {
                    this.retryDelay = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-b")) {
                    this.batch = true;
                    continue;
                }
                if (args[i].equals("-f ")) {
                    this.file = args[++i];
                    continue;
                }
                if (args[i].equals("--help")) {
                    ClientConfig.showHelp();
                    continue;
                }
                System.err.println("Unknown option: " + args[i]);
                System.err.println("Run with --help for usage");
                System.exit(1);
                continue;
            }
            commandBuilder.append(args[i]);
            commandBuilder.append(' ');
        }
        this.command = commandBuilder.toString();
    }

    private static void showHelp() {
        System.out.println("Apache Karaf client");
        System.out.println("  -a [port]     specify the port to connect to");
        System.out.println("  -h [host]     specify the host to connect to");
        System.out.println("  -u [user]     specify the user name");
        System.out.println("  --help        shows this help message");
        System.out.println("  -v            raise verbosity");
        System.out.println("  -r [attempts] retry connection establishment (up to attempts times)");
        System.out.println("  -d [delay]    intra-retry delay (defaults to 2 seconds)");
        System.out.println("  -b            batch mode, specify multiple commands via standard input");
        System.out.println("  -f [file]     read commands from the specified file");
        System.out.println("  [commands]    commands to run");
        System.out.println("If no commands are specified, the client will be put in an interactive mode");
        System.exit(0);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public int getLevel() {
        return this.level;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public String getFile() {
        return this.file;
    }
}

