/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.lock;

import org.apache.karaf.main.lock.Lock;
import org.apache.karaf.main.lock.LockCallBack;
import org.apache.karaf.main.lock.SimpleFileLock;

public class LockManager {
    private Lock lock;
    private boolean exiting = false;
    public static final String PROPERTY_USE_LOCK = "karaf.lock";
    public static final String PROPERTY_LOCK_CLASS = "karaf.lock.class";
    public static final String PROPERTY_LOCK_CLASS_DEFAULT = SimpleFileLock.class.getName();
    private final LockCallBack lockCallback;
    private final int lockCheckInterval;

    public LockManager(Lock lock, LockCallBack lockCallback, int lockCheckIntervalSeconds) {
        this.lock = lock;
        this.lockCallback = lockCallback;
        this.lockCheckInterval = lockCheckIntervalSeconds;
    }

    public void startLockMonitor() {
        new Thread(){

            @Override
            public void run() {
                LockManager.this.runLockManager();
            }
        }.start();
    }

    public void stopLockMonitor() {
        this.exiting = true;
    }

    private void runLockManager() {
        while (!this.exiting) {
            try {
                if (this.lock.lock()) {
                    this.lockCallback.lockAquired();
                    while (this.lock.isAlive() && !this.exiting) {
                        Thread.sleep(this.lockCheckInterval);
                    }
                    if (!this.exiting) {
                        this.lockCallback.lockLost();
                    }
                } else {
                    this.lockCallback.waitingForLock();
                }
                Thread.sleep(this.lockCheckInterval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void unlock() throws Exception {
        this.lock.release();
    }

    public Lock getLock() {
        return this.lock;
    }
}

