/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.apache.karaf.main.util.SubstHelper;

public class BootstrapLogManager {
    private static Handler handler;
    private static final String KARAF_BOOTSTRAP_LOG = "karaf.bootstrap.log";
    private static Properties configProps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Handler getDefaultHandler() throws Exception {
        File log;
        if (handler != null) {
            return handler;
        }
        Properties props = new Properties();
        String filename = configProps.getProperty(KARAF_BOOTSTRAP_LOG);
        if (filename != null) {
            log = new File(filename);
        } else {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(System.getProperty("karaf.base") + "/etc/org.ops4j.pax.logging.cfg");
                props.load(fis);
            }
            catch (IOException e) {
                props.setProperty("log4j.appender.out.file", "${karaf.data}/log/karaf.log");
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
            filename = SubstHelper.substVars(props.getProperty("log4j.appender.out.file"), "log4j.appender.out.file", null, null);
            log = new File(filename);
        }
        return new SimpleFileHandler(log);
    }

    public static void setProperties(Properties configProps) {
        BootstrapLogManager.configProps = configProps;
    }

    public static class SimpleFileHandler
    extends StreamHandler {
        public SimpleFileHandler(File file) throws IOException {
            this.open(file, true);
        }

        private void open(File logfile, boolean append) throws IOException {
            if (!logfile.getParentFile().exists()) {
                try {
                    logfile.getParentFile().mkdirs();
                }
                catch (SecurityException se) {
                    throw new IOException(se.getMessage());
                }
            }
            FileOutputStream fout = new FileOutputStream(logfile, append);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            this.setOutputStream(out);
        }

        @Override
        public synchronized void publish(LogRecord record) {
            if (!this.isLoggable(record)) {
                return;
            }
            super.publish(record);
            this.flush();
        }
    }
}

