/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.main.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SubstHelper {
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";

    public static String substVars(String val, String currentKey, Map<String, String> cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null) {
            substValue = System.getProperty(variable, "");
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = SubstHelper.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }
}

