/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.properties.Properties;

public class PropertiesLoader {
    private static final String INCLUDES_PROPERTY = "${includes}";
    private static final String OPTIONALS_PROPERTY = "${optionals}";
    private static final String OVERRIDE_PREFIX = "karaf.override.";

    public static Properties loadConfigProperties(File file) throws Exception {
        URL configPropURL;
        try {
            configPropURL = file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            System.err.print("Main: " + ex);
            return null;
        }
        Properties configProps = PropertiesLoader.loadPropertiesFile(configPropURL, false);
        PropertiesLoader.copySystemProperties(configProps);
        configProps.substitute();
        return configProps;
    }

    public static void loadSystemProperties(File file) throws IOException {
        Properties props = new Properties(false);
        try {
            FileInputStream is = new FileInputStream(file);
            props.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e1) {
            // empty catch block
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.startsWith(OVERRIDE_PREFIX)) {
                String overrideName = name.substring(OVERRIDE_PREFIX.length());
                String value = props.getProperty(name);
                System.setProperty(overrideName, InterpolationHelper.substVars(value, name, null, props));
                continue;
            }
            String value = System.getProperty(name, props.getProperty(name));
            System.setProperty(name, InterpolationHelper.substVars(value, name, null, props));
        }
    }

    public static void copySystemProperties(Properties configProps) {
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("felix.") && !key.startsWith("karaf.") && !key.startsWith("org.osgi.framework.")) continue;
            configProps.setProperty(key, System.getProperty(key));
        }
    }

    public static Properties loadPropertiesOrFail(File configFile) {
        try {
            URL configPropURL = configFile.toURI().toURL();
            return PropertiesLoader.loadPropertiesFile(configPropURL, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading properties from " + configFile, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFile(URL configPropURL, boolean failIfNotFound) throws Exception {
        Properties configProps = new Properties(null, false);
        InputStream is = null;
        try {
            is = configPropURL.openConnection().getInputStream();
            configProps.load(is);
            is.close();
        }
        catch (FileNotFoundException ex) {
            if (failIfNotFound) {
                throw ex;
            }
            System.err.println("WARN: " + configPropURL + " is not found, so not loaded");
        }
        catch (Exception ex) {
            System.err.println("Error loading config properties from " + configPropURL);
            System.err.println("Main: " + ex);
            Properties properties = configProps;
            return properties;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex2) {}
        }
        PropertiesLoader.loadIncludes(INCLUDES_PROPERTY, true, configPropURL, configProps);
        PropertiesLoader.loadIncludes(OPTIONALS_PROPERTY, false, configPropURL, configProps);
        PropertiesLoader.trimValues(configProps);
        return configProps;
    }

    private static void loadIncludes(String propertyName, boolean mandatory, URL configPropURL, Properties configProps) throws MalformedURLException, Exception {
        StringTokenizer st;
        String includes = (String)configProps.get(propertyName);
        if (includes != null && (st = new StringTokenizer(includes, "\" ", true)).countTokens() > 0) {
            String location;
            do {
                if ((location = PropertiesLoader.nextLocation(st)) == null) continue;
                URL url = new URL(configPropURL, location);
                Properties props = PropertiesLoader.loadPropertiesFile(url, mandatory);
                configProps.putAll(props);
            } while (location != null);
        }
        configProps.remove(propertyName);
    }

    private static void trimValues(Properties configProps) {
        for (String key : configProps.keySet()) {
            configProps.put(key, ((String)configProps.get(key)).trim());
        }
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuffer tokBuf = new StringBuffer(10);
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                String tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuffer(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
        }
        return retVal;
    }
}

