/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util.jaas;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;

public class JaasHelper {
    private static final String ROLE_WILDCARD = "*";

    public static boolean currentUserHasRole(String requestedRole) {
        if (ROLE_WILDCARD.equals(requestedRole)) {
            return true;
        }
        AccessControlContext acc = AccessController.getContext();
        if (acc == null) {
            return false;
        }
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return false;
        }
        return JaasHelper.currentUserHasRole(subject.getPrincipals(), requestedRole);
    }

    public static boolean currentUserHasRole(Set<Principal> principals, String requestedRole) {
        String role;
        String clazz;
        if (ROLE_WILDCARD.equals(requestedRole)) {
            return true;
        }
        int index = requestedRole.indexOf(58);
        if (index > 0) {
            clazz = requestedRole.substring(0, index);
            role = requestedRole.substring(index + 1);
        } else {
            clazz = RolePrincipal.class.getName();
            role = requestedRole;
        }
        for (Principal p : principals) {
            if (!clazz.equals(p.getClass().getName()) || !role.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    public static void runAs(Subject subject, Runnable action) {
        if (action == null) {
            throw new NullPointerException();
        }
        JaasHelper.doAs(subject, () -> {
            action.run();
            return null;
        });
    }

    public static <T> T doAs(Subject subject, PrivilegedAction<T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        AccessControlContext currentAcc = AccessController.getContext();
        AccessControlContext newAcc = AccessController.doPrivileged(() -> new AccessControlContext(currentAcc, subject != null ? new OsgiSubjectDomainCombiner(subject) : null));
        return AccessController.doPrivileged(action, newAcc);
    }

    public static <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (action == null) {
            throw new NullPointerException();
        }
        AccessControlContext currentAcc = AccessController.getContext();
        AccessControlContext newAcc = AccessController.doPrivileged(() -> new AccessControlContext(currentAcc, subject != null ? new OsgiSubjectDomainCombiner(subject) : null));
        return AccessController.doPrivileged(action, newAcc);
    }

    public static class DelegatingProtectionDomain
    extends ProtectionDomain {
        private final ProtectionDomain delegate;

        DelegatingProtectionDomain(ProtectionDomain delegate, Principal[] principals) {
            super(delegate.getCodeSource(), delegate.getPermissions(), delegate.getClassLoader(), principals);
            this.delegate = delegate;
        }

        @Override
        public boolean implies(Permission permission) {
            return this.delegate.implies(permission);
        }
    }

    public static class OsgiSubjectDomainCombiner
    extends SubjectDomainCombiner {
        private final Subject subject;

        public OsgiSubjectDomainCombiner(Subject subject) {
            super(subject);
            this.subject = subject;
        }

        @Override
        public ProtectionDomain[] combine(ProtectionDomain[] currentDomains, ProtectionDomain[] assignedDomains) {
            int i;
            int cLen = currentDomains == null ? 0 : currentDomains.length;
            int aLen = assignedDomains == null ? 0 : assignedDomains.length;
            ProtectionDomain[] newDomains = new ProtectionDomain[cLen + aLen];
            Principal[] principals = this.subject.getPrincipals().toArray(new Principal[0]);
            for (i = 0; i < cLen; ++i) {
                newDomains[i] = new DelegatingProtectionDomain(currentDomains[i], principals);
            }
            for (i = 0; i < aLen; ++i) {
                newDomains[cLen + i] = assignedDomains[i];
            }
            newDomains = this.optimize(newDomains);
            return newDomains;
        }

        private ProtectionDomain[] optimize(ProtectionDomain[] domains) {
            if (domains == null || domains.length == 0) {
                return null;
            }
            ProtectionDomain[] optimized = new ProtectionDomain[domains.length];
            int num = 0;
            for (ProtectionDomain domain : domains) {
                ProtectionDomain pd = domain;
                if (pd == null) continue;
                boolean found = false;
                for (int j = 0; j < num && !found; ++j) {
                    found = optimized[j] == pd;
                }
                if (found) continue;
                optimized[num++] = pd;
            }
            if (num > 0 && num < domains.length) {
                ProtectionDomain[] downSize = new ProtectionDomain[num];
                System.arraycopy(optimized, 0, downSize, 0, downSize.length);
                optimized = downSize;
            }
            return num == 0 || optimized.length == 0 ? null : optimized;
        }
    }
}

