/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.service.knoxsso;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.service.knoxsso.KnoxSSOMessages;
import org.apache.hadoop.gateway.services.GatewayServices;
import org.apache.hadoop.gateway.services.security.token.JWTokenAuthority;
import org.apache.hadoop.gateway.services.security.token.impl.JWT;
import org.apache.hadoop.gateway.services.security.token.impl.JWTToken;

@Path(value="/knoxsso/api/v1/websso")
public class WebSSOResource {
    private static final String ORIGINAL_URL_REQUEST_PARAM = "originalUrl";
    private static final String ORIGINAL_URL_COOKIE_NAME = "original-url";
    private static final String JWT_COOKIE_NAME = "hadoop-jwt";
    static final String RESOURCE_PATH = "/knoxsso/api/v1/websso";
    private static KnoxSSOMessages log = (KnoxSSOMessages)MessagesFactory.get(KnoxSSOMessages.class);
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return this.getAuthenticationToken(307);
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return this.getAuthenticationToken(303);
    }

    private Response getAuthenticationToken(int statusCode) {
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.hadoop.gateway.gateway.services");
        boolean removeOriginalUrlCookie = true;
        String original = this.getCookieValue(this.request, ORIGINAL_URL_COOKIE_NAME);
        if (original == null) {
            removeOriginalUrlCookie = false;
            original = this.request.getParameter(ORIGINAL_URL_REQUEST_PARAM);
            if (original == null) {
                log.originalURLNotFound();
                throw new WebApplicationException("Original URL not found in the request.", Response.Status.BAD_REQUEST);
            }
        }
        JWTokenAuthority ts = (JWTokenAuthority)services.getService("TokenService");
        Principal p = this.request.getUserPrincipal();
        JWTToken token = ts.issueToken(p, "RS256");
        this.addJWTHadoopCookie(original, (JWT)token);
        if (removeOriginalUrlCookie) {
            this.removeOriginalUrlCookie(this.response);
        }
        log.aboutToRedirectToOriginal(original);
        this.response.setStatus(statusCode);
        this.response.setHeader("Location", original);
        try {
            this.response.getOutputStream().close();
        }
        catch (IOException e) {
            log.unableToCloseOutputStream(e.getMessage(), e.getStackTrace().toString());
        }
        return null;
    }

    public void addJWTHadoopCookie(String original, JWT token) {
        log.addingJWTCookie(token.toString());
        Cookie c = new Cookie(JWT_COOKIE_NAME, token.toString());
        c.setPath("/");
        try {
            String domain = this.getDomainName(original);
            c.setDomain(domain);
            c.setHttpOnly(true);
            c.setSecure(true);
            c.setMaxAge(120);
            this.response.addCookie(c);
            log.addedJWTCookie();
        }
        catch (Exception e) {
            log.unableAddCookieToResponse(e.getMessage(), e.getStackTrace().toString());
            throw new WebApplicationException("Unable to add JWT cookie to response.");
        }
    }

    private void removeOriginalUrlCookie(HttpServletResponse response) {
        Cookie c = new Cookie(ORIGINAL_URL_COOKIE_NAME, null);
        c.setMaxAge(0);
        c.setPath(RESOURCE_PATH);
        response.addCookie(c);
    }

    public String getDomainName(String url) throws URISyntaxException {
        URI uri = new URI(url);
        String domain = uri.getHost();
        int idx = domain.indexOf(46);
        if (idx == -1) {
            idx = 0;
        }
        return domain.startsWith("www.") ? domain.substring(4) : domain.substring(idx);
    }

    private String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        String value = null;
        for (Cookie cookie : cookies) {
            if (!name.equals(cookie.getName())) continue;
            value = cookie.getValue();
        }
        if (value == null) {
            log.cookieNotFound(name);
        }
        return value;
    }
}

