/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.livy;

import org.apache.kylin.common.livy.LivyRestBuilder;
import org.apache.kylin.common.livy.LivyRestClient;
import org.apache.kylin.common.livy.LivyStateEnum;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivyRestExecutor {
    protected static final Logger logger = LoggerFactory.getLogger(LivyRestExecutor.class);

    public void execute(LivyRestBuilder livyRestBuilder, org.apache.kylin.common.util.Logger logAppender) {
        try {
            long startTime = System.currentTimeMillis();
            String dataJson = livyRestBuilder.build();
            logAppender.log("Livy submit Json: ");
            logAppender.log(dataJson + "\n");
            LivyRestClient restClient = new LivyRestClient();
            String result = restClient.livySubmitJobBatches(dataJson);
            JSONObject resultJson = new JSONObject(result);
            String state = resultJson.getString("state");
            logAppender.log("Livy submit Result: " + state);
            logger.info("Livy submit Result: {}", (Object)state);
            this.livyLog(resultJson, logAppender);
            String livyTaskId = resultJson.getString("id");
            while (!(LivyStateEnum.shutting_down.toString().equalsIgnoreCase(state) || LivyStateEnum.error.toString().equalsIgnoreCase(state) || LivyStateEnum.dead.toString().equalsIgnoreCase(state) || LivyStateEnum.success.toString().equalsIgnoreCase(state))) {
                String statusResult = restClient.livyGetJobStatusBatches(livyTaskId);
                JSONObject stateJson = new JSONObject(statusResult);
                if (!state.equalsIgnoreCase(stateJson.getString("state"))) {
                    logAppender.log("Livy status Result: " + stateJson.getString("state"));
                    this.livyLog(stateJson, logAppender);
                }
                state = stateJson.getString("state");
                Thread.sleep(10000L);
            }
            if (!LivyStateEnum.success.toString().equalsIgnoreCase(state)) {
                logAppender.log("livy start execute failed. state is " + state);
                logger.info("livy start execute failed. state is {}", (Object)state);
                throw new RuntimeException("livy get status failed. state is " + state);
            }
            logAppender.log("costTime : " + (System.currentTimeMillis() - startTime) / 1000L + " s");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("livy execute failed. \n" + e.getMessage());
        }
    }

    public String state(String batchId) {
        try {
            LivyRestClient restClient = new LivyRestClient();
            String statusResult = restClient.livyGetJobStatusBatches(batchId);
            JSONObject stateJson = new JSONObject(statusResult);
            return stateJson.getString("state");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public Boolean kill(String batchId) {
        try {
            LivyRestClient restClient = new LivyRestClient();
            String statusResult = restClient.livyDeleteBatches(batchId);
            JSONObject stateJson = new JSONObject(statusResult);
            return stateJson.getString("msg").equalsIgnoreCase("deleted");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void livyLog(JSONObject logInfo, org.apache.kylin.common.util.Logger logger) {
        if (logInfo.has("log")) {
            try {
                JSONArray logArray = logInfo.getJSONArray("log");
                for (int i = 0; i < logArray.length(); ++i) {
                    String info = logArray.getString(i);
                    logger.log(info);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            logInfo.remove("log");
            logger.log(logInfo.toString());
        }
    }
}

