/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.perflog;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.metrics.common.Metrics;
import org.apache.kylin.common.metrics.common.MetricsFactory;
import org.apache.kylin.common.metrics.common.MetricsScope;
import org.apache.kylin.common.metrics.perflog.IPerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfLogger
implements IPerfLogger {
    private static final Logger LOG = LoggerFactory.getLogger((String)PerfLogger.class.getName());
    protected final Map<String, Long> startTimes = new HashMap<String, Long>();
    protected final Map<String, Long> endTimes = new HashMap<String, Long>();
    transient Map<String, MetricsScope> openScopes = new HashMap<String, MetricsScope>();

    @Override
    public void perfLogBegin(String callerName, String method) {
        long startTime = System.currentTimeMillis();
        this.startTimes.put(method, new Long(startTime));
        if (LOG.isDebugEnabled()) {
            LOG.debug("<PERFLOG method=" + method + " from=" + callerName + ">");
        }
        this.beginMetrics(callerName + "." + method);
    }

    @Override
    public long perfLogEnd(String callerName, String method) {
        return this.perfLogEnd(callerName, method, null);
    }

    @Override
    public long perfLogEnd(String callerName, String method, String additionalInfo) {
        long duration;
        Long startTime = this.startTimes.get(method);
        long endTime = System.currentTimeMillis();
        this.endTimes.put(method, new Long(endTime));
        long l = duration = startTime == null ? -1L : endTime - startTime;
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("</PERFLOG method=").append(method);
            if (startTime != null) {
                sb.append(" start=").append(startTime);
            }
            sb.append(" end=").append(endTime);
            if (startTime != null) {
                sb.append(" duration=").append(duration);
            }
            sb.append(" from=").append(callerName);
            if (additionalInfo != null) {
                sb.append(" ").append(additionalInfo);
            }
            sb.append(">");
            LOG.debug(sb.toString());
        }
        this.endMetrics(callerName + "." + method);
        return duration;
    }

    public Long getStartTime(String method) {
        long startTime = 0L;
        if (this.startTimes.containsKey(method)) {
            startTime = this.startTimes.get(method);
        }
        return startTime;
    }

    public Long getEndTime(String method) {
        long endTime = 0L;
        if (this.endTimes.containsKey(method)) {
            endTime = this.endTimes.get(method);
        }
        return endTime;
    }

    public boolean startTimeHasMethod(String method) {
        return this.startTimes.containsKey(method);
    }

    public boolean endTimeHasMethod(String method) {
        return this.endTimes.containsKey(method);
    }

    public Long getDuration(String method) {
        long duration = 0L;
        if (this.startTimes.containsKey(method) && this.endTimes.containsKey(method)) {
            duration = this.endTimes.get(method) - this.startTimes.get(method);
        }
        return duration;
    }

    public ImmutableMap<String, Long> getStartTimes() {
        return ImmutableMap.copyOf(this.startTimes);
    }

    public ImmutableMap<String, Long> getEndTimes() {
        return ImmutableMap.copyOf(this.endTimes);
    }

    private void beginMetrics(String method) {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            MetricsScope scope = metrics.createScope(method);
            this.openScopes.put(method, scope);
        }
    }

    private void endMetrics(String method) {
        MetricsScope scope;
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null && (scope = this.openScopes.remove(method)) != null) {
            metrics.endScope(scope);
        }
    }

    public void cleanupPerfLogMetrics() {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            for (MetricsScope openScope : this.openScopes.values()) {
                metrics.endScope(openScope);
            }
        }
        this.openScopes.clear();
    }
}

